/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;

public abstract class PojoEndpointBase
extends Endpoint {
    private final Log log = LogFactory.getLog(PojoEndpointBase.class);
    private static final StringManager sm = StringManager.getManager(PojoEndpointBase.class);
    private Object pojo;
    private Map<String, String> pathParameters;
    private PojoMethodMapping methodMapping;

    protected final void doOnOpen(Session session, EndpointConfig config) {
        PojoMethodMapping methodMapping = this.getMethodMapping();
        Object pojo = this.getPojo();
        Map<String, String> pathParameters = this.getPathParameters();
        for (MessageHandler mh : methodMapping.getMessageHandlers(pojo, pathParameters, session, config)) {
            session.addMessageHandler(mh);
        }
        if (methodMapping.getOnOpen() != null) {
            try {
                methodMapping.getOnOpen().invoke(pojo, methodMapping.getOnOpenArgs(pathParameters, session, config));
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)sm.getString("pojoEndpointBase.onOpenFail", pojo.getClass().getName()), (Throwable)e);
                this.handleOnOpenOrCloseError(session, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                this.handleOnOpenOrCloseError(session, cause);
            }
            catch (Throwable t) {
                this.handleOnOpenOrCloseError(session, t);
            }
        }
    }

    private void handleOnOpenOrCloseError(Session session, Throwable t) {
        ExceptionUtils.handleThrowable(t);
        this.onError(session, t);
        try {
            session.close();
        }
        catch (IOException ioe) {
            this.log.warn((Object)sm.getString("pojoEndpointBase.closeSessionFail"), (Throwable)ioe);
        }
    }

    @Override
    public final void onClose(Session session, CloseReason closeReason) {
        if (this.methodMapping.getOnClose() != null) {
            try {
                this.methodMapping.getOnClose().invoke(this.pojo, this.methodMapping.getOnCloseArgs(this.pathParameters, session, closeReason));
            }
            catch (Throwable t) {
                this.log.error((Object)sm.getString("pojoEndpointBase.onCloseFail", this.pojo.getClass().getName()), t);
                this.handleOnOpenOrCloseError(session, t);
            }
        }
        Set<MessageHandler> messageHandlers = session.getMessageHandlers();
        for (MessageHandler messageHandler : messageHandlers) {
            if (!(messageHandler instanceof PojoMessageHandlerWholeBase)) continue;
            ((PojoMessageHandlerWholeBase)messageHandler).onClose();
        }
    }

    @Override
    public final void onError(Session session, Throwable throwable) {
        if (this.methodMapping.getOnError() == null) {
            this.log.error((Object)sm.getString("pojoEndpointBase.onError", this.pojo.getClass().getName()), throwable);
        } else {
            try {
                this.methodMapping.getOnError().invoke(this.pojo, this.methodMapping.getOnErrorArgs(this.pathParameters, session, throwable));
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.log.error((Object)sm.getString("pojoEndpointBase.onErrorFail", this.pojo.getClass().getName()), t);
            }
        }
    }

    protected Object getPojo() {
        return this.pojo;
    }

    protected void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    protected Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    protected void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    protected PojoMethodMapping getMethodMapping() {
        return this.methodMapping;
    }

    protected void setMethodMapping(PojoMethodMapping methodMapping) {
        this.methodMapping = methodMapping;
    }
}

