/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.functionality.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManagerImpl;
import org.wso2.carbon.identity.user.functionality.mgt.internal.UserFunctionalityManagerComponentDataHolder;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="carbon.identity.user.functionality.mgt.component", immediate=true)
public class UserFunctionalityManagerServiceComponent {
    private static final Log log = LogFactory.getLog(UserFunctionalityManagerServiceComponent.class);
    private ServiceRegistration userFunctionalityMgtService;

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            BundleContext bundleContext = componentContext.getBundleContext();
            UserFunctionalityManagerImpl userFunctionalityManager = new UserFunctionalityManagerImpl();
            this.userFunctionalityMgtService = bundleContext.registerService(UserFunctionalityManager.class, (Object)userFunctionalityManager, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"User Functionality Manager bundle is activated.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating UserFunctionalityManagerServiceComponent.", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        bundleContext.ungetService(this.userFunctionalityMgtService.getReference());
        if (log.isDebugEnabled()) {
            log.debug((Object)"User Functionality Manager bundle is deactivated.");
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in the User Functionality Manager bundle");
        }
        UserFunctionalityManagerComponentDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unset in the User Functionality Manager bundle");
        }
        UserFunctionalityManagerComponentDataHolder.getInstance().setRealmService(null);
    }
}

