/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.functionality.mgt.dao.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.configuration.mgt.core.util.JdbcUtils;
import org.wso2.carbon.identity.user.functionality.mgt.dao.UserFunctionalityPropertyDAO;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementServerException;

public class UserFunctionalityPropertyDAOImpl
implements UserFunctionalityPropertyDAO {
    private static final Log log = LogFactory.getLog((String)UserFunctionalityPropertyDAOImpl.class.getName());
    private static String TABLE_NAME;

    private static String getOracleTableName() throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return (String)jdbcTemplate.fetchSingleRecord("SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME IN ('IDN_USR_FUNCTIONALITY_PROPERTY','IDN_USER_FUNCTIONALITY_PROPERTY')", (resultSet, i) -> resultSet.getString("TABLE_NAME"), preparedStatement -> {});
        }
        catch (DataAccessException e) {
            String message = "Error occurred while retrieving db table name from user_tables.";
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    private static boolean isOracleDB() throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        return jdbcTemplate.getDriverName().toLowerCase().contains("oracle") || jdbcTemplate.getDatabaseProductName().toLowerCase().contains("oracle");
    }

    @Override
    public void addProperties(String userId, int tenantId, String functionalityIdentifier, Map<String, String> propertiesToAdd) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        for (Map.Entry<String, String> entry : propertiesToAdd.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            try {
                String query;
                if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                    if (StringUtils.isEmpty((String)TABLE_NAME)) {
                        TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                    }
                    query = String.format("INSERT INTO %s (ID, USER_ID, TENANT_ID, FUNCTIONALITY_ID, PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?,?,?,?,?)", TABLE_NAME);
                } else {
                    query = "INSERT INTO IDN_USER_FUNCTIONALITY_PROPERTY (ID, USER_ID, TENANT_ID, FUNCTIONALITY_ID, PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?,?,?,?,?)";
                }
                jdbcTemplate.executeUpdate(query, preparedStatement -> {
                    preparedStatement.setString(1, UUID.randomUUID().toString());
                    preparedStatement.setString(2, userId);
                    preparedStatement.setInt(3, tenantId);
                    preparedStatement.setString(4, functionalityIdentifier);
                    preparedStatement.setString(5, propertyName);
                    preparedStatement.setString(6, propertyValue);
                });
            }
            catch (DataAccessException e) {
                String message = String.format("Error occurred while adding the property: %s for functionality: %s in user: %s, tenant id: %d", propertyName, functionalityIdentifier, userId, tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)e);
                }
                throw new UserFunctionalityManagementServerException(message, e);
            }
        }
    }

    @Override
    public Map<String, String> getAllProperties(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementServerException {
        HashMap<String, String> properties = new HashMap<String, String>();
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String query;
            if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                if (StringUtils.isEmpty((String)TABLE_NAME)) {
                    TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                }
                query = String.format("SELECT PROPERTY_NAME, PROPERTY_VALUE FROM %s WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", TABLE_NAME);
            } else {
                query = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM IDN_USER_FUNCTIONALITY_PROPERTY WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?";
            }
            jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> properties.put(resultSet.getString(1), resultSet.getString(2)), preparedStatement -> {
                preparedStatement.setString(1, userId);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, functionalityIdentifier);
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while retrieving functionality lock properties from DB for user Id: %s, tenant Id: %d and functionality id: %s.", userId, tenantId, functionalityIdentifier);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
        return properties;
    }

    @Override
    public void updateProperties(String userId, int tenantId, String functionalityIdentifier, Map<String, String> propertiesToUpdate) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        for (Map.Entry<String, String> entry : propertiesToUpdate.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            try {
                String query;
                if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                    if (StringUtils.isEmpty((String)TABLE_NAME)) {
                        TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                    }
                    query = String.format("UPDATE %s SET PROPERTY_VALUE=? WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=? AND PROPERTY_NAME=?", TABLE_NAME);
                } else {
                    query = "UPDATE IDN_USER_FUNCTIONALITY_PROPERTY SET PROPERTY_VALUE=? WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=? AND PROPERTY_NAME=?";
                }
                jdbcTemplate.executeUpdate(query, preparedStatement -> {
                    preparedStatement.setString(1, propertyValue);
                    preparedStatement.setString(2, userId);
                    preparedStatement.setInt(3, tenantId);
                    preparedStatement.setString(4, functionalityIdentifier);
                    preparedStatement.setString(5, propertyName);
                });
            }
            catch (DataAccessException e) {
                String message = String.format("Error occurred while updating the functionality lock property: %s for functionality Id: %s, user Id: %s and tenantId: %d.", propertyName, functionalityIdentifier, userId, tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)e);
                }
                throw new UserFunctionalityManagementServerException(message, e);
            }
        }
    }

    @Override
    public void deletePropertiesForUser(String userId, int tenantId, String functionalityIdentifier, Set<String> propertiesToDelete) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        for (String propertyName : propertiesToDelete) {
            try {
                String query;
                if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                    if (StringUtils.isEmpty((String)TABLE_NAME)) {
                        TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                    }
                    query = String.format("DELETE FROM %s WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=? AND PROPERTY_NAME=?", TABLE_NAME);
                } else {
                    query = "DELETE FROM IDN_USER_FUNCTIONALITY_PROPERTY WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=? AND PROPERTY_NAME=?";
                }
                jdbcTemplate.executeUpdate(query, preparedStatement -> {
                    preparedStatement.setString(1, userId);
                    preparedStatement.setInt(2, tenantId);
                    preparedStatement.setString(3, functionalityIdentifier);
                    preparedStatement.setString(4, propertyName);
                });
            }
            catch (DataAccessException e) {
                String message = String.format("Error occurred while deleting functionality lock property from DB for functionality Id: %s, property: %s, user Id: %s and tenant Id: %d.", functionalityIdentifier, propertyName, userId, tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)e);
                }
                throw new UserFunctionalityManagementServerException(message, e);
            }
        }
    }

    @Override
    public void deleteAllPropertiesForUser(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String query;
            if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                if (StringUtils.isEmpty((String)TABLE_NAME)) {
                    TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                }
                query = String.format("DELETE FROM %s WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", TABLE_NAME);
            } else {
                query = "DELETE FROM IDN_USER_FUNCTIONALITY_PROPERTY WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?";
            }
            jdbcTemplate.executeUpdate(query, preparedStatement -> {
                preparedStatement.setString(1, userId);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, functionalityIdentifier);
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while deleting functionality lock properties from DB for functionality Id: %s, user Id: %s and tenant Id: %d.", functionalityIdentifier, userId, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    @Override
    public void deleteAllPropertiesForTenant(int tenantId) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String query;
            if (UserFunctionalityPropertyDAOImpl.isOracleDB()) {
                if (StringUtils.isEmpty((String)TABLE_NAME)) {
                    TABLE_NAME = UserFunctionalityPropertyDAOImpl.getOracleTableName();
                }
                query = String.format("DELETE FROM %s WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", TABLE_NAME);
            } else {
                query = "DELETE FROM IDN_USER_FUNCTIONALITY_PROPERTY WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?";
            }
            jdbcTemplate.executeUpdate(query, preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while deleting functionality lock properties from DB for tenant Id: %d.", tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }
}

