/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.functionality.mgt.dao.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.configuration.mgt.core.util.JdbcUtils;
import org.wso2.carbon.identity.user.functionality.mgt.dao.UserFunctionalityManagerDAO;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementServerException;
import org.wso2.carbon.identity.user.functionality.mgt.model.FunctionalityLockStatus;

public class UserFunctionalityManagerDAOImpl
implements UserFunctionalityManagerDAO {
    private static final Log log = LogFactory.getLog((String)UserFunctionalityManagerDAOImpl.class.getName());

    @Override
    public void addFunctionalityLock(String userId, int tenantId, String functionalityIdentifier, FunctionalityLockStatus functionalityLockStatus) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        String uuid = UUID.randomUUID().toString();
        try {
            jdbcTemplate.executeUpdate("INSERT INTO IDN_USER_FUNCTIONALITY_MAPPING (ID, USER_ID, TENANT_ID, FUNCTIONALITY_ID, IS_FUNCTIONALITY_LOCKED, FUNCTIONALITY_UNLOCK_TIME, FUNCTIONALITY_LOCK_REASON, FUNCTIONALITY_LOCK_REASON_CODE) VALUES (?,?,?,?,?,?,?,?)", preparedStatement -> {
                preparedStatement.setString(1, uuid);
                preparedStatement.setString(2, userId);
                preparedStatement.setInt(3, tenantId);
                preparedStatement.setString(4, functionalityIdentifier);
                preparedStatement.setBoolean(5, functionalityLockStatus.getLockStatus());
                preparedStatement.setLong(6, functionalityLockStatus.getUnlockTime());
                preparedStatement.setString(7, functionalityLockStatus.getLockReason());
                preparedStatement.setString(8, functionalityLockStatus.getLockReasonCode());
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while adding the functionality: %s, for user: %s, for tenant id: %d, having the parameters, functionality lock status: %b, functionality unlock time: %d, functionality lock reason code: %s, functionality lock reason: %s.", functionalityIdentifier, userId, tenantId, functionalityLockStatus.getLockStatus(), functionalityLockStatus.getUnlockTime(), functionalityLockStatus.getLockReasonCode(), functionalityLockStatus.getLockReason());
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    @Override
    public FunctionalityLockStatus getFunctionalityLockStatus(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementServerException {
        FunctionalityLockStatus functionalityLockStatus;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            functionalityLockStatus = (FunctionalityLockStatus)jdbcTemplate.fetchSingleRecord("SELECT IS_FUNCTIONALITY_LOCKED, FUNCTIONALITY_UNLOCK_TIME, FUNCTIONALITY_LOCK_REASON_CODE, FUNCTIONALITY_LOCK_REASON FROM IDN_USER_FUNCTIONALITY_MAPPING WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", (resultSet, i) -> new FunctionalityLockStatus(resultSet.getBoolean("IS_FUNCTIONALITY_LOCKED"), resultSet.getLong("FUNCTIONALITY_UNLOCK_TIME"), resultSet.getString("FUNCTIONALITY_LOCK_REASON_CODE"), resultSet.getString("FUNCTIONALITY_LOCK_REASON")), preparedStatement -> {
                preparedStatement.setString(1, userId);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, functionalityIdentifier);
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while retrieving functionality lock status from DB for functionality identifier: %s, user Id: %s and tenant Id: %d.", functionalityIdentifier, userId, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
        return functionalityLockStatus;
    }

    @Override
    public void updateLockStatusForUser(String userId, int tenantId, String functionalityIdentifier, FunctionalityLockStatus functionalityLockStatus) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("UPDATE IDN_USER_FUNCTIONALITY_MAPPING SET USER_ID=?, TENANT_ID=?, FUNCTIONALITY_ID=?, IS_FUNCTIONALITY_LOCKED=?, FUNCTIONALITY_UNLOCK_TIME=?, FUNCTIONALITY_LOCK_REASON=?, FUNCTIONALITY_LOCK_REASON_CODE=?  WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", preparedStatement -> {
                this.setPreparedStatementForFunctionality(userId, tenantId, functionalityIdentifier, functionalityLockStatus, preparedStatement);
                preparedStatement.setString(8, userId);
                preparedStatement.setInt(9, tenantId);
                preparedStatement.setString(10, functionalityIdentifier);
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while updating the functionality: %s for user Id: %s and tenant Id: %d.", functionalityIdentifier, userId, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    @Override
    public void deleteMappingForUser(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM IDN_USER_FUNCTIONALITY_MAPPING WHERE USER_ID=? AND TENANT_ID=? AND FUNCTIONALITY_ID=?", preparedStatement -> {
                preparedStatement.setString(1, userId);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, functionalityIdentifier);
            });
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while deleting functionality from DB for functionality Id: %s, user Id: %s and tenant Id: %d.", functionalityIdentifier, userId, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    @Override
    public void deleteAllMappingsForTenant(int tenantId) throws UserFunctionalityManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM IDN_USER_FUNCTIONALITY_MAPPING WHERE TENANT_ID=?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            String message = String.format("Error occurred while deleting mappings from DB for tenant Id: %d.", tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserFunctionalityManagementServerException(message, e);
        }
    }

    private void setPreparedStatementForFunctionality(String userId, int tenantId, String functionalityIdentifier, FunctionalityLockStatus functionalityLockStatus, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, userId);
        preparedStatement.setInt(2, tenantId);
        preparedStatement.setString(3, functionalityIdentifier);
        preparedStatement.setBoolean(4, functionalityLockStatus.getLockStatus());
        preparedStatement.setLong(5, functionalityLockStatus.getUnlockTime());
        preparedStatement.setString(6, functionalityLockStatus.getLockReason());
        preparedStatement.setString(7, functionalityLockStatus.getLockReasonCode());
    }
}

