/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.functionality.mgt;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityMgtConstants;
import org.wso2.carbon.identity.user.functionality.mgt.dao.UserFunctionalityManagerDAO;
import org.wso2.carbon.identity.user.functionality.mgt.dao.UserFunctionalityPropertyDAO;
import org.wso2.carbon.identity.user.functionality.mgt.dao.impl.UserFunctionalityManagerDAOImpl;
import org.wso2.carbon.identity.user.functionality.mgt.dao.impl.UserFunctionalityPropertyDAOImpl;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementClientException;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementException;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementServerException;
import org.wso2.carbon.identity.user.functionality.mgt.internal.UserFunctionalityManagerComponentDataHolder;
import org.wso2.carbon.identity.user.functionality.mgt.model.FunctionalityLockStatus;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UniqueIDUserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.service.RealmService;

public class UserFunctionalityManagerImpl
implements UserFunctionalityManager {
    private UserFunctionalityManagerDAO userFunctionalityManagerDAO = new UserFunctionalityManagerDAOImpl();
    private UserFunctionalityPropertyDAO userFunctionalityPropertyDAO = new UserFunctionalityPropertyDAOImpl();
    private static final Log log = LogFactory.getLog(UserFunctionalityManagerImpl.class);

    @Override
    public FunctionalityLockStatus getLockStatus(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        FunctionalityLockStatus functionalityLockStatus = this.userFunctionalityManagerDAO.getFunctionalityLockStatus(userId, tenantId, functionalityIdentifier);
        if (functionalityLockStatus == null) {
            return FunctionalityLockStatus.UNLOCKED_STATUS;
        }
        long unlockTime = functionalityLockStatus.getUnlockTime();
        if (unlockTime < System.currentTimeMillis()) {
            this.userFunctionalityManagerDAO.deleteMappingForUser(userId, tenantId, functionalityIdentifier);
            return FunctionalityLockStatus.UNLOCKED_STATUS;
        }
        return functionalityLockStatus;
    }

    @Override
    public Map<String, String> getProperties(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        return this.userFunctionalityPropertyDAO.getAllProperties(userId, tenantId, functionalityIdentifier);
    }

    @Override
    public void setProperties(String userId, int tenantId, String functionalityIdentifier, Map<String, String> functionalityLockProperties) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        Map<String, String> existingProperties = this.getProperties(userId, tenantId, functionalityIdentifier);
        if (MapUtils.isNotEmpty(functionalityLockProperties)) {
            this.addOrUpdateProperties(functionalityLockProperties, existingProperties, userId, tenantId, functionalityIdentifier);
        }
    }

    @Override
    public void lock(String userId, int tenantId, String functionalityIdentifier, long timeToLock, String functionalityLockReasonCode, String functionalityLockReason) throws UserFunctionalityManagementException {
        FunctionalityLockStatus functionalityLockStatus;
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        long unlockTime = Long.MAX_VALUE;
        if (timeToLock >= 0L) {
            unlockTime = System.currentTimeMillis() + timeToLock;
        }
        if ((functionalityLockStatus = this.userFunctionalityManagerDAO.getFunctionalityLockStatus(userId, tenantId, functionalityIdentifier)) != null) {
            boolean isFunctionalityLockedForUser = functionalityLockStatus.getLockStatus();
            long oldUnlockTime = functionalityLockStatus.getUnlockTime();
            if (!isFunctionalityLockedForUser) {
                FunctionalityLockStatus newFunctionalityLockStatus = new FunctionalityLockStatus(true, unlockTime, functionalityLockReasonCode, functionalityLockReason);
                this.userFunctionalityManagerDAO.updateLockStatusForUser(userId, tenantId, functionalityIdentifier, newFunctionalityLockStatus);
            } else if (oldUnlockTime < unlockTime) {
                functionalityLockStatus.setLockReasonCode(functionalityLockReasonCode);
                functionalityLockStatus.setLockReason(functionalityLockReason);
                functionalityLockStatus.setUnlockTime(unlockTime);
                this.userFunctionalityManagerDAO.updateLockStatusForUser(userId, tenantId, functionalityIdentifier, functionalityLockStatus);
            }
        } else {
            FunctionalityLockStatus newFunctionalityLockStatus = new FunctionalityLockStatus(true, unlockTime, functionalityLockReasonCode, functionalityLockReason);
            this.userFunctionalityManagerDAO.addFunctionalityLock(userId, tenantId, functionalityIdentifier, newFunctionalityLockStatus);
        }
    }

    @Override
    public void unlock(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        this.userFunctionalityManagerDAO.deleteMappingForUser(userId, tenantId, functionalityIdentifier);
    }

    @Override
    public void deleteAllPropertiesForUser(String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        this.userFunctionalityPropertyDAO.deleteAllPropertiesForUser(userId, tenantId, functionalityIdentifier);
    }

    @Override
    public void deletePropertiesForUser(String userId, int tenantId, String functionalityIdentifier, Set<String> propertiesToDelete) throws UserFunctionalityManagementException {
        if (!this.isPerUserFunctionalityLockingEnabled()) {
            throw new UnsupportedOperationException("Per-user functionality locking is not enabled.");
        }
        if (StringUtils.isEmpty((String)userId) || !this.isUserIdExists(userId, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot retrieve user from userId: " + userId));
            }
            throw this.buildUserNotFoundError();
        }
        this.userFunctionalityPropertyDAO.deletePropertiesForUser(userId, tenantId, functionalityIdentifier, propertiesToDelete);
    }

    @Override
    public void deleteAllMappingsForTenant(int tenantId) throws UserFunctionalityManagementServerException {
        this.userFunctionalityManagerDAO.deleteAllMappingsForTenant(tenantId);
    }

    @Override
    public void deleteAllPropertiesForTenant(int tenantId) throws UserFunctionalityManagementServerException {
        this.userFunctionalityPropertyDAO.deleteAllPropertiesForTenant(tenantId);
    }

    private void addOrUpdateProperties(Map<String, String> newProperties, Map<String, String> oldProperties, String userId, int tenantId, String functionalityIdentifier) throws UserFunctionalityManagementServerException {
        HashMap<String, String> propertiesToAdd = new HashMap<String, String>();
        HashMap<String, String> propertiesToUpdate = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(oldProperties)) {
            newProperties.forEach((k, v) -> {
                if (oldProperties.containsKey(k)) {
                    propertiesToUpdate.put((String)k, (String)v);
                } else {
                    propertiesToAdd.put((String)k, (String)v);
                }
            });
        } else {
            newProperties.forEach(propertiesToAdd::put);
        }
        if (MapUtils.isNotEmpty(propertiesToAdd)) {
            this.userFunctionalityPropertyDAO.addProperties(userId, tenantId, functionalityIdentifier, propertiesToAdd);
        }
        if (MapUtils.isNotEmpty(propertiesToUpdate)) {
            this.userFunctionalityPropertyDAO.updateProperties(userId, tenantId, functionalityIdentifier, propertiesToUpdate);
        }
    }

    private boolean isPerUserFunctionalityLockingEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"EnablePerUserFunctionalityLocking"));
    }

    private boolean isUserIdExists(String userId, int tenantId) throws UserFunctionalityManagementClientException, UserFunctionalityManagementServerException {
        try {
            UniqueIDUserStoreManager uniqueIdEnabledUserStoreManager = this.getUniqueIdEnabledUserStoreManager(UserFunctionalityManagerComponentDataHolder.getInstance().getRealmService(), IdentityTenantUtil.getTenantDomain((int)tenantId));
            boolean isUserExists = uniqueIdEnabledUserStoreManager.isExistingUserWithID(userId);
            return isUserExists;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            if (this.isUserNotExistingError(e, userId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot retrieve user from userId: " + userId), (Throwable)e);
                }
                throw this.buildUserNotFoundError();
            }
            throw new UserFunctionalityManagementServerException(UserFunctionalityMgtConstants.ErrorMessages.ERROR_OCCURRED_WHILE_RETRIEVING_USER.getCode(), UserFunctionalityMgtConstants.ErrorMessages.ERROR_OCCURRED_WHILE_RETRIEVING_USER.getDescription());
        }
    }

    private UniqueIDUserStoreManager getUniqueIdEnabledUserStoreManager(RealmService realmService, String tenantDomain) throws org.wso2.carbon.user.api.UserStoreException, UserFunctionalityManagementClientException {
        UserStoreManager userStoreManager = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)tenantDomain)).getUserStoreManager();
        if (!(userStoreManager instanceof UniqueIDUserStoreManager)) {
            if (log.isDebugEnabled()) {
                String msg = "Provided user store manager does not support unique user IDs in the tenant domain" + tenantDomain;
                log.debug((Object)msg);
            }
            throw this.buildUserNotFoundError();
        }
        return (UniqueIDUserStoreManager)userStoreManager;
    }

    private boolean isUserNotExistingError(org.wso2.carbon.user.api.UserStoreException e, String userId) {
        if (log.isDebugEnabled()) {
            String msg = "Provided user corresponding to the userid" + userId + "does not exist";
            log.debug((Object)msg);
        }
        return e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_NON_EXISTING_USER.getCode().equals(((UserStoreException)e).getErrorCode());
    }

    private UserFunctionalityManagementClientException buildUserNotFoundError() {
        return new UserFunctionalityManagementClientException(UserFunctionalityMgtConstants.ErrorMessages.USER_NOT_FOUND.getCode(), UserFunctionalityMgtConstants.ErrorMessages.USER_NOT_FOUND.getDescription());
    }
}

