/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.admin.internal.Exception.BrokerManagerAdminException;
import org.wso2.carbon.andes.admin.internal.Message;
import org.wso2.carbon.andes.admin.internal.Queue;
import org.wso2.carbon.andes.admin.internal.QueueRolePermission;
import org.wso2.carbon.andes.admin.internal.Subscription;
import org.wso2.carbon.andes.admin.util.AndesBrokerManagerAdminServiceDSHolder;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.core.AndesException;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.QueueManagerService;
import org.wso2.carbon.andes.core.SubscriptionManagerException;
import org.wso2.carbon.andes.core.SubscriptionManagerService;
import org.wso2.carbon.andes.core.internal.util.Utils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.authorization.TreeNode;

public class AndesAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(AndesAdminService.class);
    private static final String UI_EXECUTE = "ui.execute";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_ADD_QUEUE = "/permission/admin/manage/queue/add";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_DELETE_QUEUE = "/permission/admin/manage/queue/delete";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_PURGE_QUEUE = "/permission/admin/manage/queue/purge";
    private static final String PERMISSION_ADMIN_MANAGE_BROWSE_QUEUE = "/permission/admin/manage/queue/browse";
    private static final String PERMISSION_ADMIN_MANAGE_BROWSE_DLC = "/permission/admin/manage/dlc/browse";
    private static final String PERMISSION_ADMIN_MANAGE_DLC_DELETE_MESSAGE = "/permission/admin/manage/dlc/delete";
    private static final String PERMISSION_ADMIN_MANAGE_DLC_RESTORE_MESSAGE = "/permission/admin/manage/dlc/restore";
    private static final String PERMISSION_ADMIN_MANAGE_DLC_REROUTE_MESSAGE = "/permission/admin/manage/dlc/reroute";
    private static final String PERMISSION_ADMIN_MANAGE_QUEUE_SUBSCRIPTION_CLOSE = "/permission/admin/manage/subscriptions/queue-close";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_SUBSCRIPTION_CLOSE = "/permission/admin/manage/subscriptions/topic-close";

    public Queue getQueueByName(String queueName) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        Queue queue = null;
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            if (null != queueManagerService.getQueueByName(queueName)) {
                queue = new Queue(queueManagerService.getQueueByName(queueName));
            }
        }
        catch (QueueManagerException e) {
            log.error((Object)"Problem in getting queues from back end", (Throwable)e);
            throw new BrokerManagerAdminException("Problem in getting queues from back-end", (Exception)((Object)e));
        }
        return queue;
    }

    public Queue getDLCQueue() throws BrokerManagerAdminException {
        Queue queue;
        try {
            String tenantDomain = Utils.getTenantDomain();
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queue = new Queue(queueManagerService.getDLCQueue(tenantDomain));
        }
        catch (QueueManagerException e) {
            log.error((Object)"Problem in getting queues from back end", (Throwable)e);
            throw new BrokerManagerAdminException("Problem in getting queues from back-end", (Exception)((Object)e));
        }
        return queue;
    }

    public Queue[] getAllQueues() throws BrokerManagerAdminException {
        Queue[] queuesDTO;
        ArrayList<Queue> allQueues = new ArrayList<Queue>();
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            List queues = queueManagerService.getAllQueues();
            queuesDTO = new Queue[queues.size()];
            for (org.wso2.carbon.andes.core.types.Queue queue : queues) {
                Queue queueDTO = new Queue();
                queueDTO.setQueueName(queue.getQueueName());
                queueDTO.setMessageCount(queue.getMessageCount());
                queueDTO.setCreatedTime(queue.getCreatedTime());
                queueDTO.setUpdatedTime(queue.getUpdatedTime());
                allQueues.add(queueDTO);
            }
            CustomQueueComparator comparator = new CustomQueueComparator();
            Collections.sort(allQueues, Collections.reverseOrder(comparator));
            allQueues.toArray(queuesDTO);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return queuesDTO;
    }

    public Set<String> getNamesOfAllDurableQueues() throws BrokerManagerAdminException {
        Set namesOfDurableQueues;
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            namesOfDurableQueues = queueManagerService.getNamesOfAllDurableQueues();
        }
        catch (QueueManagerException e) {
            log.error((Object)"Error while retrieving names of durable queues ", (Throwable)e);
            throw new BrokerManagerAdminException("Error while retrieving names of durable queues", (Exception)((Object)e));
        }
        return namesOfDurableQueues;
    }

    public long getMessageCount(String destinationName, String msgPattern) throws BrokerManagerAdminException {
        destinationName = this.setNameToLowerCase(destinationName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            long messageCount = queueManagerService.getMessageCount(destinationName, msgPattern);
            return messageCount;
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving message count by queue manager service", (Throwable)e);
            throw new BrokerManagerAdminException("Error while retrieving message count by queue manager service", e);
        }
    }

    public void deleteQueue(String queueName) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.deleteQueue(queueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public void deleteTopicFromRegistry(String topicName, String subscriptionId) throws BrokerManagerAdminException {
        topicName = this.setNameToLowerCase(topicName);
        subscriptionId = this.setNameToLowerCase(subscriptionId);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.deleteTopicFromRegistry(topicName, subscriptionId);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public long restoreSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String destinationQueueName) throws BrokerManagerAdminException {
        destinationQueueName = this.setNameToLowerCase(destinationQueueName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            return queueManagerService.restoreSelectedMessagesFromDeadLetterChannel(messageIDs, destinationQueueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public long rerouteSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String newDestinationQueueName, String destinationQueueName) throws BrokerManagerAdminException {
        newDestinationQueueName = this.setNameToLowerCase(newDestinationQueueName);
        destinationQueueName = this.setNameToLowerCase(destinationQueueName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            return queueManagerService.rerouteSelectedMessagesFromDeadLetterChannel(messageIDs, newDestinationQueueName, destinationQueueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public void deleteMessagesFromDeadLetterQueue(long[] messageIDs, String destinationQueueName) throws BrokerManagerAdminException {
        destinationQueueName = this.setNameToLowerCase(destinationQueueName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.deleteMessagesFromDeadLetterQueue(messageIDs, destinationQueueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public void purgeMessagesOfQueue(String queueName) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.purgeMessagesOfQueue(queueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public void closeSubscription(boolean isDurable, String subscriptionID, String subscribedQueueOrTopicName, String protocolType, String destinationType, String subscriberQueueName) throws BrokerManagerAdminException {
        subscriptionID = this.setNameToLowerCase(subscriptionID);
        subscribedQueueOrTopicName = this.setNameToLowerCase(subscribedQueueOrTopicName);
        subscriberQueueName = this.setNameToLowerCase(subscriberQueueName);
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            subscriptionManagerService.closeSubscription(subscriptionID, subscribedQueueOrTopicName, protocolType, destinationType);
            if (!isDurable) {
                QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
                queueManagerService.deleteTopicFromRegistry(subscribedQueueOrTopicName, subscriberQueueName);
            }
        }
        catch (QueueManagerException | SubscriptionManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
    }

    public Subscription[] getAllSubscriptions() throws BrokerManagerAdminException {
        Subscription[] subscriptionsDTO;
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = subscriptionManagerService.getAllSubscriptions();
            subscriptionsDTO = new Subscription[subscriptions.size()];
            for (org.wso2.carbon.andes.core.types.Subscription sub : subscriptions) {
                Subscription subscriptionDTO = new Subscription();
                subscriptionDTO.setSubscriptionIdentifier(sub.getSubscriptionIdentifier());
                subscriptionDTO.setSubscribedQueueOrTopicName(sub.getSubscribedQueueOrTopicName());
                subscriptionDTO.setSubscriberQueueBoundExchange(sub.getSubscriberQueueBoundExchange());
                subscriptionDTO.setSubscriberQueueName(sub.getSubscriberQueueName());
                subscriptionDTO.setDurable(sub.isDurable());
                subscriptionDTO.setActive(sub.isActive());
                subscriptionDTO.setNumberOfMessagesRemainingForSubscriber(sub.getNumberOfMessagesRemainingForSubscriber());
                subscriptionDTO.setConnectedNodeAddress(sub.getConnectedNodeAddress());
                subscriptionDTO.setProtocolType(sub.getProtocolType());
                subscriptionDTO.setDestinationType(sub.getDestinationType());
                subscriptionDTO.setOriginHostAddress(sub.getOriginHostAddress());
                allSubscriptions.add(subscriptionDTO);
            }
            CustomSubscriptionComparator comparator = new CustomSubscriptionComparator();
            Collections.sort(allSubscriptions, Collections.reverseOrder(comparator));
            allSubscriptions.toArray(subscriptionsDTO);
        }
        catch (SubscriptionManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return subscriptionsDTO;
    }

    public Subscription[] getSubscriptions(String isDurable, String isActive, String protocolType, String destinationType) throws BrokerManagerAdminException {
        Subscription[] subscriptionsDTO;
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = subscriptionManagerService.getSubscriptions(isDurable, isActive, protocolType, destinationType);
            subscriptionsDTO = new Subscription[subscriptions.size()];
            for (org.wso2.carbon.andes.core.types.Subscription sub : subscriptions) {
                Subscription subscriptionDTO = new Subscription();
                subscriptionDTO.setSubscriptionIdentifier(sub.getSubscriptionIdentifier());
                subscriptionDTO.setSubscribedQueueOrTopicName(sub.getSubscribedQueueOrTopicName());
                subscriptionDTO.setSubscriberQueueBoundExchange(sub.getSubscriberQueueBoundExchange());
                subscriptionDTO.setSubscriberQueueName(sub.getSubscriberQueueName());
                subscriptionDTO.setDurable(sub.isDurable());
                subscriptionDTO.setActive(sub.isActive());
                subscriptionDTO.setNumberOfMessagesRemainingForSubscriber(sub.getNumberOfMessagesRemainingForSubscriber());
                subscriptionDTO.setConnectedNodeAddress(sub.getConnectedNodeAddress());
                subscriptionDTO.setProtocolType(sub.getProtocolType());
                subscriptionDTO.setDestinationType(sub.getDestinationType());
                subscriptionDTO.setOriginHostAddress(sub.getOriginHostAddress());
                allSubscriptions.add(subscriptionDTO);
            }
            CustomSubscriptionComparator comparator = new CustomSubscriptionComparator();
            Collections.sort(allSubscriptions, Collections.reverseOrder(comparator));
            allSubscriptions.toArray(subscriptionsDTO);
        }
        catch (SubscriptionManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return subscriptionsDTO;
    }

    public Subscription[] getFilteredSubscriptions(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId, int pageNumber, int subscriptionCountPerPage) throws BrokerManagerAdminException {
        Subscription[] subscriptionsDTO;
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        filteredNamePattern = this.setNameToLowerCase(filteredNamePattern);
        identifierPattern = this.setNameToLowerCase(identifierPattern);
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = subscriptionManagerService.getFilteredSubscriptions(isDurable, isActive, protocolType, destinationType, filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId, pageNumber, subscriptionCountPerPage);
            subscriptionsDTO = new Subscription[subscriptions.size()];
            for (org.wso2.carbon.andes.core.types.Subscription sub : subscriptions) {
                Subscription subscriptionDTO = new Subscription();
                subscriptionDTO.setSubscriptionIdentifier(sub.getSubscriptionIdentifier());
                subscriptionDTO.setSubscribedQueueOrTopicName(sub.getSubscribedQueueOrTopicName());
                subscriptionDTO.setSubscriberQueueBoundExchange(sub.getSubscriberQueueBoundExchange());
                subscriptionDTO.setSubscriberQueueName(sub.getSubscriberQueueName());
                subscriptionDTO.setDurable(sub.isDurable());
                subscriptionDTO.setActive(sub.isActive());
                subscriptionDTO.setNumberOfMessagesRemainingForSubscriber(sub.getNumberOfMessagesRemainingForSubscriber());
                subscriptionDTO.setConnectedNodeAddress(sub.getConnectedNodeAddress());
                subscriptionDTO.setProtocolType(sub.getProtocolType());
                subscriptionDTO.setDestinationType(sub.getDestinationType());
                subscriptionDTO.setOriginHostAddress(sub.getOriginHostAddress());
                allSubscriptions.add(subscriptionDTO);
            }
            CustomSubscriptionComparator comparator = new CustomSubscriptionComparator();
            Collections.sort(allSubscriptions, Collections.reverseOrder(comparator));
            allSubscriptions.toArray(subscriptionsDTO);
        }
        catch (SubscriptionManagerException e) {
            String errorMessage = "An error occurred while retrieving subscriptions from backend " + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return subscriptionsDTO;
    }

    public int getTotalSubscriptionCountForSearchResult(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId) throws BrokerManagerAdminException {
        filteredNamePattern = this.setNameToLowerCase(filteredNamePattern);
        identifierPattern = this.setNameToLowerCase(identifierPattern);
        int subscriptionCountForSearchResult = 0;
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            subscriptionCountForSearchResult = subscriptionManagerService.getTotalSubscriptionCountForSearchResult(isDurable, isActive, protocolType, destinationType, filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId);
        }
        catch (SubscriptionManagerException e) {
            String errorMessage = "An error occurred while getting subscription count from backend " + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return subscriptionCountForSearchResult;
    }

    public long getNumberOfMessagesInDLCForQueue(String queueName) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        queueName = this.setNameToLowerCase(queueName);
        try {
            return queueManagerService.getNumberOfMessagesInDLCForQueue(queueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public Message[] getMessagesInDLCForQueue(String queueName, long nextMessageIdToRead, int maxMsgCount) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        ArrayList<Message> messageDTOList = new ArrayList<Message>();
        queueName = this.setNameToLowerCase(queueName);
        try {
            org.wso2.carbon.andes.core.types.Message[] messages;
            for (org.wso2.carbon.andes.core.types.Message message : messages = queueManagerService.getMessagesInDLCForQueue(queueName, nextMessageIdToRead, maxMsgCount)) {
                Message messageDTO = new Message();
                messageDTO.setMsgProperties(message.getMsgProperties());
                messageDTO.setContentType(message.getContentType());
                messageDTO.setMessageContent(message.getMessageContent());
                messageDTO.setJMSMessageId(message.getJMSMessageId());
                messageDTO.setJMSReDelivered(message.getJMSReDelivered());
                messageDTO.setJMSDeliveredMode("null");
                messageDTO.setJMSTimeStamp(message.getJMSTimeStamp());
                messageDTO.setDlcMsgDestination(message.getDlcMsgDestination());
                messageDTO.setAndesMsgMetadataId(message.getAndesMsgMetadataId());
                messageDTOList.add(messageDTO);
            }
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return messageDTOList.toArray(new Message[messageDTOList.size()]);
    }

    public void updatePermission(String queueName, QueueRolePermission[] queueRolePermissionsDTO) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            if (queueRolePermissionsDTO != null && queueRolePermissionsDTO.length > 0) {
                org.wso2.carbon.andes.core.types.QueueRolePermission[] rolePermissions = new org.wso2.carbon.andes.core.types.QueueRolePermission[queueRolePermissionsDTO.length];
                for (int i = 0; i < queueRolePermissionsDTO.length; ++i) {
                    rolePermissions[i] = queueRolePermissionsDTO[i].convert();
                }
                queueManagerService.updatePermission(queueName, rolePermissions);
            }
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public void addQueueAndAssignPermission(String queueName, QueueRolePermission[] queueRolePermissionsDTO) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        queueName = queueName.toLowerCase();
        try {
            if (null != queueRolePermissionsDTO && queueRolePermissionsDTO.length > 0) {
                org.wso2.carbon.andes.core.types.QueueRolePermission[] rolePermissions = new org.wso2.carbon.andes.core.types.QueueRolePermission[queueRolePermissionsDTO.length];
                for (int i = 0; i < queueRolePermissionsDTO.length; ++i) {
                    rolePermissions[i] = queueRolePermissionsDTO[i].convert();
                }
                queueManagerService.addQueueAndAssignPermission(queueName, rolePermissions);
            } else {
                queueManagerService.createQueue(queueName);
            }
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public String[] getUserRoles() throws BrokerManagerAdminException {
        String[] roles;
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            roles = queueManagerService.getBackendRoles();
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return roles;
    }

    public QueueRolePermission[] getQueueRolePermission(String queueName) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        queueName = this.setNameToLowerCase(queueName);
        ArrayList<QueueRolePermission> queueRolePermissionDTOList = new ArrayList<QueueRolePermission>();
        try {
            org.wso2.carbon.andes.core.types.QueueRolePermission[] queueRolePermission;
            for (org.wso2.carbon.andes.core.types.QueueRolePermission rolePermission : queueRolePermission = queueManagerService.getQueueRolePermission(queueName)) {
                QueueRolePermission queueRolePermissionDTO = new QueueRolePermission();
                queueRolePermissionDTO.setRoleName(rolePermission.getRoleName());
                queueRolePermissionDTO.setAllowedToConsume(rolePermission.isAllowedToConsume());
                queueRolePermissionDTO.setAllowedToPublish(rolePermission.isAllowedToPublish());
                queueRolePermissionDTOList.add(queueRolePermissionDTO);
            }
            return queueRolePermissionDTOList.toArray(new QueueRolePermission[queueRolePermissionDTOList.size()]);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public Message[] browseQueue(String queueName, long nextMessageIdToRead, int maxMsgCount) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        ArrayList<Message> messageDTOList = new ArrayList<Message>();
        queueName = this.setNameToLowerCase(queueName);
        try {
            org.wso2.carbon.andes.core.types.Message[] messages;
            for (org.wso2.carbon.andes.core.types.Message message : messages = queueManagerService.browseQueue(queueName, nextMessageIdToRead, maxMsgCount)) {
                Message messageDTO = new Message();
                messageDTO.setMsgProperties(message.getMsgProperties());
                messageDTO.setContentType(message.getContentType());
                messageDTO.setMessageContent(message.getMessageContent());
                messageDTO.setJMSMessageId(message.getJMSMessageId());
                messageDTO.setJMSCorrelationId(message.getJMSCorrelationId());
                messageDTO.setJMSType(message.getJMSType());
                messageDTO.setJMSReDelivered(message.getJMSReDelivered());
                messageDTO.setMsgProperties(message.getMsgProperties());
                messageDTO.setJMSTimeStamp(message.getJMSTimeStamp());
                messageDTO.setJMSExpiration(message.getJMSExpiration());
                messageDTO.setDlcMsgDestination(message.getDlcMsgDestination());
                messageDTO.setAndesMsgMetadataId(message.getAndesMsgMetadataId());
                messageDTOList.add(messageDTO);
            }
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return messageDTOList.toArray(new Message[messageDTOList.size()]);
    }

    public long getTotalMessagesInQueue(String queueName) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        queueName = this.setNameToLowerCase(queueName);
        try {
            return queueManagerService.getTotalMessagesInQueue(queueName);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    public boolean sendMessage(String queueName, String jmsType, String jmsCorrelationID, int numberOfMessages, String message, int deliveryMode, int priority, long expireTime) throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        queueName = this.setNameToLowerCase(queueName);
        try {
            return queueManagerService.sendMessage(queueName, this.getCurrentLoggedInUser(), this.getAccessKey(), jmsType, jmsCorrelationID, numberOfMessages, message, deliveryMode, priority, expireTime);
        }
        catch (QueueManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
    }

    private String getAccessKey() {
        return AndesBrokerManagerAdminServiceDSHolder.getInstance().getAccessKey();
    }

    public int getMessageCountForSubscriber(String subscriptionID, boolean durable, String protocolType, String destinationType) throws BrokerManagerAdminException {
        int remainingMessages = 0;
        subscriptionID = this.setNameToLowerCase(subscriptionID);
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = durable ? subscriptionManagerService.getSubscriptions("true", "*", protocolType, destinationType) : subscriptionManagerService.getSubscriptions("false", "*", protocolType, destinationType);
            for (org.wso2.carbon.andes.core.types.Subscription subscription : subscriptions) {
                if (!subscription.getSubscriptionIdentifier().equals(subscriptionID)) continue;
                remainingMessages = subscription.getNumberOfMessagesRemainingForSubscriber();
                break;
            }
        }
        catch (SubscriptionManagerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)("Admin service exception while getting message for subscriber " + subscriptionID), (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return remainingMessages;
    }

    public long getPendingMessageCount(String queueName) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            return subscriptionManagerService.getPendingMessageCount(queueName);
        }
        catch (Exception e) {
            log.error((Object)"Error while calculating the pending message count for storage queue", (Throwable)e);
            throw new BrokerManagerAdminException("Error while calculate the pending message count for storage queue");
        }
    }

    public void dumpMessageStatus() throws BrokerManagerAdminException {
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            queueManagerService.dumpMessageStatus();
        }
        catch (AndesException e) {
            log.error((Object)"Error while dumping message status to file ", (Throwable)e);
            throw new BrokerManagerAdminException("Error while dumping message status to file");
        }
    }

    public boolean checkCurrentUserHasPublishPermission(String queueName) throws BrokerManagerAdminException {
        queueName = this.setNameToLowerCase(queueName);
        return this.checkUserHasPublishPermission(queueName, this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasPublishPermission(String queueName, String userName) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        queueName = this.setNameToLowerCase(queueName);
        String queueID = CommonsUtil.getQueueID((String)queueName);
        try {
            if (Utils.isAdmin((String)userName)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(userName, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasAddQueuePermission() throws BrokerManagerAdminException {
        return this.checkUserHasAddQueuePermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasAddQueuePermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_ADD_QUEUE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasBrowseQueuePermission() throws BrokerManagerAdminException {
        return this.checkUserHasBrowseQueuePermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasBrowseQueuePermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_BROWSE_QUEUE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasDeleteQueuePermission() throws BrokerManagerAdminException {
        return this.checkUserHasDeleteQueuePermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasDeleteQueuePermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_DELETE_QUEUE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasPurgeQueuePermission() throws BrokerManagerAdminException {
        return this.checkUserHasPurgeQueuePermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasPurgeQueuePermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_PURGE_QUEUE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasBrowseMessagesInDLCPermission() throws BrokerManagerAdminException {
        return this.checkUserHasBrowseMessagesInDLCPermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasBrowseMessagesInDLCPermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_BROWSE_DLC, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasDeleteMessagesInDLCPermission() throws BrokerManagerAdminException {
        return this.checkUserHasDeleteMessagesInDLCPermission(this.getCurrentLoggedInUser());
    }

    public boolean checkUserHasDeleteMessagesInDLCPermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_DLC_DELETE_MESSAGE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasRestoreMessagesInDLCPermission() throws BrokerManagerAdminException {
        return this.checkUserHasRestoreMessagesInDLCPermission(CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasRestoreMessagesInDLCPermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_DLC_RESTORE_MESSAGE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasRerouteMessagesInDLCPermission() throws BrokerManagerAdminException {
        return this.checkUserHasRerouteMessagesInDLCPermission(CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasRerouteMessagesInDLCPermission(String username) throws BrokerManagerAdminException {
        boolean hasPermission = false;
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_DLC_REROUTE_MESSAGE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasQueueSubscriptionClosePermission() throws BrokerManagerAdminException {
        boolean hasPermission = false;
        String username = this.getCurrentLoggedInUser();
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_QUEUE_SUBSCRIPTION_CLOSE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    public boolean checkCurrentUserHasTopicSubscriptionClosePermission() throws BrokerManagerAdminException {
        boolean hasPermission = false;
        String username = this.getCurrentLoggedInUser();
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_SUBSCRIPTION_CLOSE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    private String getCurrentLoggedInUser() {
        return CarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    public Message[] getMessageMetadataInDeadLetterChannel(String targetQueue, long startMessageId, int pageLimit) throws BrokerManagerAdminException {
        targetQueue = this.setNameToLowerCase(targetQueue);
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        ArrayList<Message> messageDTOList = new ArrayList<Message>();
        try {
            org.wso2.carbon.andes.core.types.Message[] messages;
            for (org.wso2.carbon.andes.core.types.Message message : messages = queueManagerService.getMessageMetadataInDLC(targetQueue, startMessageId, pageLimit)) {
                Message messageDTO = new Message();
                messageDTO.setMsgProperties(message.getMsgProperties());
                messageDTO.setContentType(message.getContentType());
                messageDTO.setMessageContent(message.getMessageContent());
                messageDTO.setJMSMessageId(message.getJMSMessageId());
                messageDTO.setJMSReDelivered(message.getJMSReDelivered());
                messageDTO.setJMSDeliveredMode("null");
                messageDTO.setJMSTimeStamp(message.getJMSTimeStamp());
                messageDTO.setDlcMsgDestination(message.getDlcMsgDestination());
                messageDTO.setAndesMsgMetadataId(message.getAndesMsgMetadataId());
                messageDTOList.add(messageDTO);
            }
        }
        catch (QueueManagerException e) {
            String errorMessage = "Error occurred while listing messages in DLC for queue : " + targetQueue;
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        return messageDTOList.toArray(new Message[messageDTOList.size()]);
    }

    public String rerouteAllMessagesFromDeadLetterChannelForQueue(String sourceQueue, String targetQueue, int internalBatchSize) throws BrokerManagerAdminException {
        int movedMessageCount;
        sourceQueue = this.setNameToLowerCase(sourceQueue);
        targetQueue = this.setNameToLowerCase(targetQueue);
        QueueManagerService queueManagerService = AndesBrokerManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            movedMessageCount = queueManagerService.rerouteMessagesFromDeadLetterChannelForQueue(sourceQueue, targetQueue, internalBatchSize);
        }
        catch (QueueManagerException e) {
            String errorMessage = "Error occurred while rerouting all messages from sourceQueue : " + sourceQueue + " to targetQueue : " + targetQueue;
            log.error((Object)errorMessage, (Throwable)e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)((Object)e));
        }
        if (-1 < movedMessageCount) {
            return "Messages were successfully restored to the target queue : " + targetQueue + ". movedMessageCount : " + movedMessageCount;
        }
        return "An error occured while restoring messages to the target queue : " + targetQueue + ". movedMessageCount : " + movedMessageCount;
    }

    private String setNameToLowerCase(String queue) {
        return queue.toLowerCase();
    }

    public class CustomSubscriptionComparator
    implements Comparator<Subscription> {
        @Override
        public int compare(Subscription sub1, Subscription sub2) {
            return sub1.getNumberOfMessagesRemainingForSubscriber() - sub2.getNumberOfMessagesRemainingForSubscriber();
        }
    }

    public class CustomQueueComparator
    implements Comparator<Queue> {
        @Override
        public int compare(Queue queue1, Queue queue2) {
            long comparedValue = queue1.getMessageCount() - queue2.getMessageCount();
            int returnValue = 0;
            if (comparedValue < 0L) {
                returnValue = -1;
            } else if (comparedValue > 0L) {
                returnValue = 1;
            }
            return returnValue;
        }
    }
}

