/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementClientException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementServerException;
import org.wso2.carbon.identity.role.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.mgt.core.util.IDResolver;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;

public class UserIDResolver
implements IDResolver {
    private Log log = LogFactory.getLog(UserIDResolver.class);

    @Override
    public String getNameByID(String id, String tenantDomain) throws IdentityRoleManagementException {
        String userName = this.resolveUserNameFromUserID(id);
        if (userName == null) {
            String errorMessage = "A user doesn't exist with id: " + id + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return userName;
    }

    public List<String> getNamesByIDs(List<String> idList, String tenantDomain) throws IdentityRoleManagementException {
        ArrayList<String> usersList = new ArrayList<String>();
        for (String id : idList) {
            usersList.add(this.getNameByID(id, tenantDomain));
        }
        return usersList;
    }

    @Override
    public String getIDByName(String name, String tenantDomain) throws IdentityRoleManagementException {
        String id = this.resolveIDFromUserName(name);
        if (id == null) {
            String errorMessage = "A user doesn't exist with name: " + name + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return id;
    }

    public List<String> getIDsByNames(List<String> namesList, String tenantDomain) throws IdentityRoleManagementException {
        ArrayList<String> usersIDList = new ArrayList<String>();
        for (String name : namesList) {
            usersIDList.add(this.getIDByName(name, tenantDomain));
        }
        return usersIDList;
    }

    private String resolveUserNameFromUserID(String userID) throws IdentityRoleManagementException {
        try {
            UserStoreManager userStoreManager = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            try {
                if (userStoreManager instanceof AbstractUserStoreManager) {
                    return ((AbstractUserStoreManager)userStoreManager).getUserNameFromUserID(userID);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Provided user store manager for the userID: " + userID + ", is not an instance of the AbstractUserStore manager"));
                }
                throw new IdentityRoleManagementClientException(RoleConstants.Error.OPERATION_NOT_SUPPORTED.getCode(), "Unable to get the username of the userID: " + userID + ".");
            }
            catch (UserStoreException e) {
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error occurred while resolving username for the userID: " + userID, e);
            }
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error occurred while retrieving the userstore manager to resolve username for the userID: " + userID, e);
        }
    }

    private String resolveIDFromUserName(String userName) throws IdentityRoleManagementException {
        try {
            UserStoreManager userStoreManager = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            try {
                if (userStoreManager instanceof AbstractUserStoreManager) {
                    return ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Provided user store manager for the userName: " + userName + ", is not an instance of the AbstractUserStore manager"));
                }
                throw new IdentityRoleManagementClientException(RoleConstants.Error.OPERATION_NOT_SUPPORTED.getCode(), "Unable to get the username of the userName: " + userName + ".");
            }
            catch (UserStoreException e) {
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error occurred while resolving username for the userName: " + userName, e);
            }
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error occurred while retrieving the userstore manager to resolve username for the userName: " + userName, e);
        }
    }
}

