/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementClientException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.mgt.core.dao.GroupDAO;
import org.wso2.carbon.identity.role.mgt.core.dao.RoleMgtDAOFactory;
import org.wso2.carbon.identity.role.mgt.core.util.IDResolver;

public class GroupIDResolver
implements IDResolver {
    private Log log = LogFactory.getLog(GroupIDResolver.class);

    @Override
    public String getNameByID(String id, String tenantDomain) throws IdentityRoleManagementException {
        GroupDAO groupDAO = RoleMgtDAOFactory.getInstance().getGroupDAO();
        String groupName = groupDAO.getGroupNameByID(id, tenantDomain);
        if (groupName == null) {
            String errorMessage = "A group doesn't exist with id: " + id + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return groupName;
    }

    public Map<String, String> getNamesByIDs(List<String> idList, String tenantDomain) throws IdentityRoleManagementException {
        GroupDAO groupDAO = RoleMgtDAOFactory.getInstance().getGroupDAO();
        return groupDAO.getGroupNamesByIDs(idList, tenantDomain);
    }

    @Override
    public String getIDByName(String name, String tenantDomain) throws IdentityRoleManagementException {
        GroupDAO groupDAO = RoleMgtDAOFactory.getInstance().getGroupDAO();
        String groupName = groupDAO.getGroupIDByName(name, tenantDomain);
        if (groupName == null) {
            String errorMessage = "A group doesn't exist with name: " + name + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return groupName;
    }

    public Map<String, String> getIDsByNames(List<String> namesList, String tenantDomain) throws IdentityRoleManagementException {
        GroupDAO groupDAO = RoleMgtDAOFactory.getInstance().getGroupDAO();
        return groupDAO.getGroupIDsByNames(namesList, tenantDomain);
    }
}

