/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.internal;

import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.role.mgt.core.GroupBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementClientException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.Role;
import org.wso2.carbon.identity.role.mgt.core.RoleBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.mgt.core.RoleManagementService;
import org.wso2.carbon.identity.role.mgt.core.UserBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.dao.RoleDAO;
import org.wso2.carbon.identity.role.mgt.core.dao.RoleMgtDAOFactory;

public class RoleManagementServiceImpl
implements RoleManagementService {
    private static final Log log = LogFactory.getLog(RoleManagementServiceImpl.class);
    private RoleDAO roleDAO = RoleMgtDAOFactory.getInstance().getRoleDAO();

    @Override
    public RoleBasicInfo addRole(String roleName, List<String> userList, List<String> groupList, List<String> permissions, String tenantDomain) throws IdentityRoleManagementException {
        if (StringUtils.startsWithIgnoreCase((String)roleName, (String)"system_")) {
            String errorMessage = String.format("Invalid role name: %s. Role names with the prefix: %s, is not allowed to be created from externally in the system.", roleName, "system_");
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return this.roleDAO.addRole(roleName, userList, groupList, permissions, tenantDomain);
    }

    @Override
    public List<RoleBasicInfo> getRoles(Integer limit, Integer offset, String sortBy, String sortOrder, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getRoles(limit, offset, sortBy, sortOrder, tenantDomain);
    }

    @Override
    public List<RoleBasicInfo> getRoles(String filter, Integer limit, Integer offset, String sortBy, String sortOrder, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getRoles(filter, limit, offset, sortBy, sortOrder, tenantDomain);
    }

    @Override
    public Role getRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getRole(roleID, tenantDomain);
    }

    @Override
    public RoleBasicInfo updateRoleName(String roleID, String newRoleName, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.updateRoleName(roleID, newRoleName, tenantDomain);
    }

    @Override
    public void deleteRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        this.roleDAO.deleteRole(roleID, tenantDomain);
    }

    @Override
    public List<UserBasicInfo> getUserListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getUserListOfRole(roleID, tenantDomain);
    }

    @Override
    public RoleBasicInfo updateUserListOfRole(String roleID, List<String> newUserIDList, List<String> deletedUserIDList, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.updateUserListOfRole(roleID, newUserIDList, deletedUserIDList, tenantDomain);
    }

    @Override
    public List<GroupBasicInfo> getGroupListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getGroupListOfRole(roleID, tenantDomain);
    }

    @Override
    public RoleBasicInfo updateGroupListOfRole(String roleID, List<String> newGroupIDList, List<String> deletedGroupIDList, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.updateGroupListOfRole(roleID, newGroupIDList, deletedGroupIDList, tenantDomain);
    }

    @Override
    public List<String> getPermissionListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.getPermissionListOfRole(roleID, tenantDomain);
    }

    @Override
    public RoleBasicInfo setPermissionsForRole(String roleID, List<String> permissions, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.setPermissionsForRole(roleID, permissions, tenantDomain);
    }

    @Override
    public boolean isExistingRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        return this.roleDAO.isExistingRoleID(roleID, tenantDomain);
    }

    @Override
    public boolean isExistingRoleName(String roleName, String tenantDomain) throws IdentityRoleManagementException, NotImplementedException {
        return this.roleDAO.isExistingRoleName(roleName, tenantDomain);
    }
}

