/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.role.mgt.core.RoleManagementService;
import org.wso2.carbon.identity.role.mgt.core.internal.RoleManagementServiceComponentHolder;
import org.wso2.carbon.identity.role.mgt.core.internal.RoleManagementServiceImpl;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.role.mgt.core.internal.RoleManagementServiceComponent", immediate=true)
public class RoleManagementServiceComponent {
    private static Log log = LogFactory.getLog(RoleManagementServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(RoleManagementService.class, (Object)new RoleManagementServiceImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Role management service is activated.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating Role management service.", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Role management service is deactivated.");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service.");
        }
        RoleManagementServiceComponentHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service.");
        }
        RoleManagementServiceComponentHolder.getInstance().setRealmService(null);
    }
}

