/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.database.utils.jdbc.NamedPreparedStatement;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.role.mgt.core.GroupBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementClientException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementServerException;
import org.wso2.carbon.identity.role.mgt.core.Role;
import org.wso2.carbon.identity.role.mgt.core.RoleBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.mgt.core.UserBasicInfo;
import org.wso2.carbon.identity.role.mgt.core.dao.RoleDAO;
import org.wso2.carbon.identity.role.mgt.core.internal.RoleManagementServiceComponentHolder;
import org.wso2.carbon.identity.role.mgt.core.util.GroupIDResolver;
import org.wso2.carbon.identity.role.mgt.core.util.UserIDResolver;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.common.UserRolesCache;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.UserRealmProxy;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class RoleDAOImpl
implements RoleDAO {
    private Log log = LogFactory.getLog(RoleDAOImpl.class);
    private GroupIDResolver groupIDResolver = new GroupIDResolver();
    private UserIDResolver userIDResolver = new UserIDResolver();

    @Override
    public RoleBasicInfo addRole(String roleName, List<String> userList, List<String> groupList, List<String> permissions, String tenantDomain) throws IdentityRoleManagementException {
        String roleID;
        block38: {
            String primaryDomainName;
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating the role: " + roleName + " in the tenantDomain: " + tenantDomain));
            }
            if ((primaryDomainName = IdentityUtil.getPrimaryDomainName()) != null) {
                primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
            }
            if (!this.isExistingRoleName(roleName = this.removeInternalDomain(roleName), tenantDomain)) {
                try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
                    try {
                        try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "INSERT INTO UM_HYBRID_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (:UM_ROLE_NAME;, :UM_TENANT_ID;)", "UM_ID");){
                            statement.setString("UM_ROLE_NAME", roleName);
                            statement.setInt("UM_TENANT_ID", tenantId);
                            statement.executeUpdate();
                        }
                        String databaseProductName = connection.getMetaData().getDatabaseProductName();
                        if (CollectionUtils.isNotEmpty(userList)) {
                            List<String> userNamesList = this.getUserNamesByIDs(userList, tenantDomain);
                            String addUsersSQL = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (:UM_USER_NAME;,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), :UM_TENANT_ID;, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;))";
                            if ("Microsoft SQL Server".equals(databaseProductName)) {
                                addUsersSQL = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (:UM_USER_NAME;),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), (:UM_TENANT_ID;), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)";
                            }
                            this.processBatchUpdateForUsers(roleName, userNamesList, tenantId, primaryDomainName, connection, addUsersSQL);
                            for (String username : userNamesList) {
                                this.clearUserRolesCache(username, tenantId);
                            }
                        }
                        if (CollectionUtils.isNotEmpty(groupList)) {
                            Map<String, String> groupIdsToNames = this.getGroupNamesByIDs(groupList, tenantDomain);
                            ArrayList<String> groupNamesList = new ArrayList<String>(groupIdsToNames.values());
                            String addGroupsSQL = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (:UM_GROUP_NAME;,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), :UM_TENANT_ID;, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;))";
                            if ("Microsoft SQL Server".equals(databaseProductName)) {
                                addGroupsSQL = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (:UM_GROUP_NAME;),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), (:UM_TENANT_ID;), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)";
                            }
                            this.processBatchUpdateForGroups(roleName, groupNamesList, tenantId, primaryDomainName, connection, addGroupsSQL);
                        }
                        roleID = this.addRoleID(roleName, tenantDomain);
                        if (CollectionUtils.isNotEmpty(permissions)) {
                            this.setPermissionsForRole(roleID, permissions, tenantDomain);
                        }
                        IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
                        break block38;
                    }
                    catch (SQLException | IdentityRoleManagementException e) {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        String errorMessage = "Error while creating the role: %s in the tenantDomain: %s";
                        throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
                    }
                }
                catch (SQLException e) {
                    String errorMessage = "Error while creating the role: %s in the tenantDomain: %s";
                    throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
                }
            }
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_ALREADY_EXISTS.getCode(), "Role already exist for the role name: " + roleName);
        }
        return new RoleBasicInfo(roleID, roleName);
    }

    protected String addRoleID(String roleName, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String id = UUID.randomUUID().toString();
        roleName = this.appendInternalDomain(roleName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding the roleID: " + id + " for the role: " + roleName + " in the tenantDomain: " + tenantDomain));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "INSERT INTO IDN_SCIM_GROUP (TENANT_ID, ROLE_NAME, ATTR_NAME, ATTR_VALUE) VALUES (:TENANT_ID;, :ROLE_NAME;, :ATTR_NAME;, :ATTR_VALUE;)");){
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ROLE_NAME", roleName);
                statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
                statement.setString("ATTR_VALUE", id);
                statement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMessage = "Error while adding the the roleID: %s for the role: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, id, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while adding the the roleID: %s for the role: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, id, roleName, tenantDomain), e);
        }
        return id;
    }

    private String removeInternalDomain(String roleName) {
        if ("Internal".equalsIgnoreCase(IdentityUtil.extractDomainFromName((String)roleName))) {
            return UserCoreUtil.removeDomainFromName((String)roleName);
        }
        return roleName;
    }

    @Override
    public Role getRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        Role role = new Role();
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        role.setId(roleID);
        role.setName(roleName);
        role.setTenantDomain(tenantDomain);
        role.setUsers(this.getUserListOfRole(roleID, tenantDomain));
        role.setGroups(this.getGroupListOfRole(roleID, tenantDomain));
        role.setPermissions(this.getPermissionListOfRole(roleID, tenantDomain));
        return role;
    }

    @Override
    public List<RoleBasicInfo> getRoles(Integer limit, Integer offset, String sortBy, String sortOrder, String tenantDomain) throws IdentityRoleManagementException {
        List<RoleBasicInfo> roles;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        limit = this.validateLimit(limit);
        offset = this.validateOffset(offset);
        this.validateAttributesForSorting(sortBy, sortOrder);
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)false);){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, this.getDBTypeSpecificRolesRetrievalQuery(databaseProductName), "UM_ID");){
                statement.setInt("UM_TENANT_ID", tenantId);
                roles = this.processListRolesQuery(limit, offset, statement, tenantDomain);
            }
        }
        catch (SQLException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while listing roles in tenantDomain: " + tenantDomain, e);
        }
        return Collections.unmodifiableList(roles);
    }

    @Override
    public List<RoleBasicInfo> getRoles(String filter, Integer limit, Integer offset, String sortBy, String sortOrder, String tenantDomain) throws IdentityRoleManagementException {
        List<RoleBasicInfo> roles;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isBlank((String)filter) || "*".equals(filter)) {
            return this.getRoles(limit, offset, sortBy, sortOrder, tenantDomain);
        }
        String filterResolvedForSQL = this.resolveSQLFilter(filter);
        limit = this.validateLimit(limit);
        offset = this.validateOffset(offset);
        this.validateAttributesForSorting(sortBy, sortOrder);
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)false);){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, this.getDBTypeSpecificRolesRetrievalQueryByRoleName(databaseProductName), "UM_ID");){
                statement.setInt("UM_TENANT_ID", tenantId);
                statement.setString("UM_ROLE_NAME", filterResolvedForSQL);
                roles = this.processListRolesQuery(limit, offset, statement, tenantDomain);
            }
        }
        catch (SQLException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while listing roles in tenantDomain: " + tenantDomain, e);
        }
        return Collections.unmodifiableList(roles);
    }

    private List<RoleBasicInfo> processListRolesQuery(int limit, int offset, NamedPreparedStatement statement, String tenantDomain) throws SQLException, IdentityRoleManagementException {
        statement.setInt("OFFSET", offset);
        statement.setInt("LIMIT", limit);
        statement.setInt("ZERO_BASED_START_INDEX", offset);
        statement.setInt("ONE_BASED_START_INDEX", offset + 1);
        statement.setInt("END_INDEX", offset + limit);
        return this.buildRolesList(statement, tenantDomain);
    }

    private List<RoleBasicInfo> buildRolesList(NamedPreparedStatement statement, String tenantDomain) throws SQLException, IdentityRoleManagementException {
        ArrayList<RoleBasicInfo> roles = new ArrayList<RoleBasicInfo>();
        ArrayList<String> roleNames = new ArrayList<String>();
        ResultSet resultSet = statement.executeQuery();
        Object object = null;
        try {
            while (resultSet.next()) {
                String roleName2 = resultSet.getString(1);
                roleNames.add(this.appendInternalDomain(roleName2));
            }
        }
        catch (Throwable roleName2) {
            object = roleName2;
            throw roleName2;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable roleName2) {
                        ((Throwable)object).addSuppressed(roleName2);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        Map<String, String> roleNamesToIDs = this.getRoleIDsByNames(roleNames, tenantDomain);
        roleNames.removeAll(new ArrayList<String>(roleNamesToIDs.keySet()));
        for (String roleName2 : roleNames) {
            roleNamesToIDs.put(roleName2, this.addRoleID(roleName2, tenantDomain));
        }
        roleNamesToIDs.forEach((roleName, roleID) -> roles.add(new RoleBasicInfo((String)roleID, this.removeInternalDomain((String)roleName))));
        return roles;
    }

    private String appendInternalDomain(String roleName) {
        if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            return "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + roleName;
        }
        return roleName;
    }

    private String resolveSQLFilter(String filter) {
        String sqlfilter = "%";
        if (StringUtils.isNotBlank((String)filter)) {
            sqlfilter = filter.trim().replace("*", "%").replace("?", "_");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Input filter: " + filter + " resolved for SQL filter: " + sqlfilter));
        }
        return sqlfilter;
    }

    private String getDBTypeSpecificRolesRetrievalQueryByRoleName(String databaseProductName) throws IdentityRoleManagementException {
        if ("MySQL".equals(databaseProductName) || "MariaDB".equals(databaseProductName) || "H2".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_ROLE_NAME LIKE :UM_ROLE_NAME; ORDER BY UM_ID DESC LIMIT :OFFSET;, :LIMIT;";
        }
        if ("Oracle".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM (SELECT UM_ROLE_NAME, rownum AS rnum FROM (SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC) WHERE UM_ROLE_NAME LIKE :UM_ROLE_NAME; AND rownum <= :END_INDEX;) WHERE rnum > :ZERO_BASED_START_INDEX;";
        }
        if ("Microsoft SQL Server".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_ROLE_NAME LIKE :UM_ROLE_NAME; ORDER BY UM_ID DESC OFFSET :OFFSET; ROWS FETCH NEXT :LIMIT; ROWS ONLY";
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_ROLE_NAME LIKE :UM_ROLE_NAME; ORDER BY UM_ID DESC LIMIT :LIMIT; OFFSET :OFFSET;";
        }
        if (databaseProductName != null && databaseProductName.contains("DB2")) {
            return "SELECT UM_ROLE_NAME FROM (SELECT ROW_NUMBER() OVER(ORDER BY UM_ID DESC) AS rn,UM_HYBRID_ROLE.* FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_ROLE_NAME LIKE :UM_ROLE_NAME;)WHERE rn BETWEEN :ONE_BASED_START_INDEX; AND :END_INDEX;";
        }
        if ("INFORMIX".equals(databaseProductName)) {
            return "SELECT SKIP :OFFSET; FIRST :LIMIT; UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_ROLE_NAME LIKE :UM_ROLE_NAME; ORDER BY UM_ID DESC";
        }
        throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while listing roles from DB. Database driver for " + databaseProductName + "could not be identified or not supported.");
    }

    private String getDBTypeSpecificRolesRetrievalQuery(String databaseProductName) throws IdentityRoleManagementException {
        if ("MySQL".equals(databaseProductName) || "MariaDB".equals(databaseProductName) || "H2".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC LIMIT :OFFSET;, :LIMIT;";
        }
        if ("Oracle".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM (SELECT UM_ROLE_NAME, rownum AS rnum FROM (SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC) WHERE rownum <= :END_INDEX;) WHERE rnum > :ZERO_BASED_START_INDEX;";
        }
        if ("Microsoft SQL Server".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC OFFSET :OFFSET; ROWS FETCH NEXT :LIMIT; ROWS ONLY";
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            return "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC LIMIT :LIMIT; OFFSET :OFFSET;";
        }
        if (databaseProductName != null && databaseProductName.contains("DB2")) {
            return "SELECT UM_ROLE_NAME FROM (SELECT ROW_NUMBER() OVER(ORDER BY UM_ID DESC) AS rn,UM_HYBRID_ROLE.* FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID;)WHERE rn BETWEEN :ONE_BASED_START_INDEX; AND :END_INDEX;";
        }
        if ("INFORMIX".equals(databaseProductName)) {
            return "SELECT SKIP :OFFSET; FIRST :LIMIT; UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=:UM_TENANT_ID; ORDER BY UM_ID DESC";
        }
        throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while listing roles from DB. Database driver for " + databaseProductName + "could not be identified or not supported.");
    }

    private int validateOffset(Integer offset) throws IdentityRoleManagementClientException {
        if (offset == null) {
            offset = 0;
        } else if (offset > 0) {
            offset = offset - 1;
        } else if (offset < 0) {
            String errorMessage = "Invalid offset requested. Offset value should be zero or greater than zero. offSet: " + offset;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_OFFSET.getCode(), errorMessage);
        }
        return offset;
    }

    private int validateLimit(Integer limit) throws IdentityRoleManagementClientException {
        int maximumItemsPerPage = IdentityUtil.getMaximumItemPerPage();
        if (limit == null) {
            limit = IdentityUtil.getDefaultItemsPerPage();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Given limit is null. Therefore assigning the default limit: " + limit));
            }
        } else {
            if (limit < 0) {
                String errorMessage = "Invalid limit requested. Limit value should be greater than or equal to zero. limit: " + limit;
                throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_LIMIT.getCode(), errorMessage);
            }
            if (limit > maximumItemsPerPage) {
                limit = maximumItemsPerPage;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Given limit exceed the maximum limit. Therefore assigning the maximum limit: " + maximumItemsPerPage));
                }
            }
        }
        return limit;
    }

    private void validateAttributesForSorting(String sortBy, String sortOrder) throws IdentityRoleManagementClientException {
        if (StringUtils.isNotBlank((String)sortBy) || StringUtils.isNotBlank((String)sortOrder)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.SORTING_NOT_IMPLEMENTED.getCode(), "Sorting not supported.");
        }
    }

    @Override
    public RoleBasicInfo updateUserListOfRole(String roleID, List<String> newUserIDList, List<String> deletedUserIDList, String tenantDomain) throws IdentityRoleManagementException {
        if (!this.isExistingRoleID(roleID, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), "Role id: " + roleID + " does not exist in the system.");
        }
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        if (CollectionUtils.isEmpty(newUserIDList) && CollectionUtils.isEmpty(deletedUserIDList)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"User lists are empty.");
            }
            return new RoleBasicInfo(roleID, roleName);
        }
        String primaryDomainName = IdentityUtil.getPrimaryDomainName();
        if (primaryDomainName != null) {
            primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
        }
        List<String> newUserNamesList = this.getUserNamesByIDs(newUserIDList, tenantDomain);
        List<String> deletedUserNamesList = this.getUserNamesByIDs(deletedUserIDList, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try {
                String addUsersSQL = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (:UM_USER_NAME;,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), :UM_TENANT_ID;, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;))";
                String databaseProductName = connection.getMetaData().getDatabaseProductName();
                if ("Microsoft SQL Server".equals(databaseProductName)) {
                    addUsersSQL = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (:UM_USER_NAME;),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), (:UM_TENANT_ID;), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)";
                }
                this.processBatchUpdateForUsers(roleName, newUserNamesList, tenantId, primaryDomainName, connection, addUsersSQL);
                this.processBatchUpdateForUsers(roleName, deletedUserNamesList, tenantId, primaryDomainName, connection, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=:UM_USER_NAME; AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;) AND UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)");
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String errorMessage = "Error while updating users to the role: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while updating users to the role: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
        if (CollectionUtils.isNotEmpty(deletedUserNamesList)) {
            for (String username : deletedUserNamesList) {
                this.clearUserRolesCache(username, tenantId);
            }
        }
        if (CollectionUtils.isNotEmpty(newUserNamesList)) {
            for (String username : newUserNamesList) {
                this.clearUserRolesCache(username, tenantId);
            }
        }
        return new RoleBasicInfo(roleID, roleName);
    }

    private void processBatchUpdateForUsers(String roleName, List<String> userNamesList, int tenantId, String primaryDomainName, Connection connection, String removeUserFromRoleSql) throws SQLException {
        try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, removeUserFromRoleSql, "UM_ID");){
            for (String userName : userNamesList) {
                String domainName = UserCoreUtil.extractDomainFromName((String)(userName = UserCoreUtil.addDomainToName((String)userName, (String)primaryDomainName)));
                if (domainName != null) {
                    domainName = domainName.toUpperCase(Locale.ENGLISH);
                }
                String nameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
                statement.setString("UM_USER_NAME", nameWithoutDomain);
                statement.setString("UM_ROLE_NAME", roleName);
                statement.setInt("UM_TENANT_ID", tenantId);
                statement.setString("UM_DOMAIN_NAME", domainName);
                statement.addBatch();
            }
            statement.executeBatch();
        }
    }

    @Override
    public RoleBasicInfo updateGroupListOfRole(String roleID, List<String> newGroupIDList, List<String> deletedGroupIDList, String tenantDomain) throws IdentityRoleManagementException {
        if (!this.isExistingRoleID(roleID, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), "Role id: " + roleID + " does not exist in the system.");
        }
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        if (CollectionUtils.isEmpty(newGroupIDList) && CollectionUtils.isEmpty(deletedGroupIDList)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Group lists are empty.");
            }
            return new RoleBasicInfo(roleID, roleName);
        }
        String primaryDomainName = IdentityUtil.getPrimaryDomainName();
        if (primaryDomainName != null) {
            primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
        }
        Map<String, String> newGroupIdsToNames = this.getGroupNamesByIDs(newGroupIDList, tenantDomain);
        ArrayList<String> newGroupNamesList = new ArrayList<String>(newGroupIdsToNames.values());
        Map<String, String> deletedGroupIdsToNames = this.getGroupNamesByIDs(deletedGroupIDList, tenantDomain);
        ArrayList<String> deletedGroupNamesList = new ArrayList<String>(deletedGroupIdsToNames.values());
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try {
                String addGroupsSQL = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (:UM_GROUP_NAME;,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), :UM_TENANT_ID;, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;))";
                String databaseProductName = connection.getMetaData().getDatabaseProductName();
                if ("Microsoft SQL Server".equals(databaseProductName)) {
                    addGroupsSQL = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (:UM_GROUP_NAME;),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;), (:UM_TENANT_ID;), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)";
                }
                this.processBatchUpdateForGroups(roleName, newGroupNamesList, tenantId, primaryDomainName, connection, addGroupsSQL);
                this.processBatchUpdateForGroups(roleName, deletedGroupNamesList, tenantId, primaryDomainName, connection, "DELETE FROM UM_HYBRID_GROUP_ROLE WHERE UM_GROUP_NAME=:UM_GROUP_NAME; AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;) AND UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)");
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String errorMessage = "Error while updating groups to the role: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while updating groups to the role: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
        this.clearUserRolesCacheByTenant(tenantId);
        return new RoleBasicInfo(roleID, roleName);
    }

    private void processBatchUpdateForGroups(String roleName, List<String> groupNamesList, int tenantId, String primaryDomainName, Connection connection, String sql) throws SQLException {
        try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, sql, "UM_ID");){
            for (String groupName : groupNamesList) {
                String domainName = UserCoreUtil.extractDomainFromName((String)(groupName = UserCoreUtil.addDomainToName((String)groupName, (String)primaryDomainName)));
                if (domainName != null) {
                    domainName = domainName.toUpperCase(Locale.ENGLISH);
                }
                String nameWithoutDomain = UserCoreUtil.removeDomainFromName((String)groupName);
                statement.setString("UM_GROUP_NAME", nameWithoutDomain);
                statement.setString("UM_ROLE_NAME", roleName);
                statement.setInt("UM_TENANT_ID", tenantId);
                statement.setString("UM_DOMAIN_NAME", domainName);
                statement.addBatch();
            }
            statement.executeBatch();
        }
    }

    @Override
    public RoleBasicInfo updateRoleName(String roleID, String newRoleName, String tenantDomain) throws IdentityRoleManagementException {
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (!this.isExistingRoleID(roleID, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), "Role id: " + roleID + " does not exist in the system.");
        }
        if (this.isExistingRoleName(newRoleName, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_ALREADY_EXISTS.getCode(), "Role name: " + newRoleName + " is already there in the system. Please pick another role name.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating the roleName: " + roleName + " to :" + newRoleName + " in the tenantDomain: " + tenantDomain));
        }
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try {
                try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "UPDATE UM_HYBRID_ROLE SET UM_ROLE_NAME=:NEW_UM_ROLE_NAME; WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;", "UM_ID");){
                    statement.setString("NEW_UM_ROLE_NAME", newRoleName);
                    statement.setString("UM_ROLE_NAME", roleName);
                    statement.setInt("UM_TENANT_ID", tenantId);
                    statement.executeUpdate();
                }
                this.updateSCIMRoleName(roleName, newRoleName, tenantDomain);
                if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                    roleName = UserCoreUtil.addDomainToName((String)roleName, (String)"Internal");
                }
                if (!newRoleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                    newRoleName = UserCoreUtil.addDomainToName((String)newRoleName, (String)"Internal");
                }
                try {
                    UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
                    userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
                }
                catch (UserStoreException e) {
                    throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while getting the authorizationManager.", e);
                }
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException | IdentityRoleManagementException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String message = "Error while updating the role name: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(message, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String message = "Error while updating the role name: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(message, roleName, tenantDomain), e);
        }
        this.clearUserRolesCacheByTenant(tenantId);
        return new RoleBasicInfo(roleID, newRoleName);
    }

    protected void updateSCIMRoleName(String roleName, String newRoleName, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        roleName = this.appendInternalDomain(roleName);
        newRoleName = this.appendInternalDomain(newRoleName);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "UPDATE IDN_SCIM_GROUP SET ROLE_NAME=:NEW_ROLE_NAME; WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME;");){
                statement.setString("NEW_ROLE_NAME", newRoleName);
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ROLE_NAME", roleName);
                statement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMessage = "Error while updating the the roleName: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while updating the the roleName: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
    }

    @Override
    public void deleteRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        UserRealm userRealm;
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try {
            userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            if (UserCoreUtil.isEveryoneRole((String)roleName, (RealmConfiguration)userRealm.getRealmConfiguration())) {
                throw new IdentityRoleManagementClientException(RoleConstants.Error.OPERATION_FORBIDDEN.getCode(), "Invalid operation. Role: " + roleName + " Cannot be deleted.");
            }
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while getting the realmConfiguration.", e);
        }
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try {
                try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "DELETE FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;", "UM_ID");){
                    statement.setString("UM_ROLE_NAME", roleName);
                    statement.setInt("UM_TENANT_ID", tenantId);
                    statement.executeUpdate();
                }
                this.deleteSCIMRole(roleName, tenantDomain);
                if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                    roleName = UserCoreUtil.addDomainToName((String)roleName, (String)"Internal");
                }
                try {
                    userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
                }
                catch (UserStoreException e) {
                    throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while getting the authorizationManager.", e);
                }
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException | IdentityRoleManagementException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String message = "Error while deleting the role name: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(message, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String message = "Error while deleting the role name: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(message, roleName, tenantDomain), e);
        }
        this.clearUserRolesCacheByTenant(tenantId);
    }

    protected void deleteSCIMRole(String roleName, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        roleName = this.appendInternalDomain(roleName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting the role: " + roleName + " for the role: " + roleName + " in the tenantDomain: " + tenantDomain));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "DELETE FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME;");){
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ROLE_NAME", roleName);
                statement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMessage = "Error while deleting the the role: %s for the role: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, roleName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while deleting the the role: %s for the role: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, roleName, tenantDomain), e);
        }
    }

    @Override
    public boolean isExistingRoleName(String roleName, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        boolean isExist = false;
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT COUNT(UM_ID) FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME =:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;", "UM_ID");){
            statement.setString("UM_ROLE_NAME", this.removeInternalDomain(roleName));
            statement.setInt("UM_TENANT_ID", tenantId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    isExist = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while checking is existing role for role name: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Is roleName: " + roleName + " Exist: " + isExist + " in the tenantDomain: " + tenantDomain));
        }
        return isExist;
    }

    @Override
    public boolean isExistingRoleID(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        boolean isExist = false;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT COUNT(ID) FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ATTR_NAME=:ATTR_NAME; AND ATTR_VALUE=:ATTR_VALUE;");){
            statement.setInt("TENANT_ID", tenantId);
            statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
            statement.setString("ATTR_VALUE", roleID);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    isExist = resultSet.getInt(1) > 0;
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while checking is existing role for role id: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleID, tenantDomain), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Is roleID: " + roleID + " Exist: " + isExist + " in the tenantDomain: " + tenantDomain));
        }
        return isExist;
    }

    @Override
    public List<UserBasicInfo> getUserListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        if (!this.isExistingRoleID(roleID, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), "Role id: " + roleID + " does not exist in the system.");
        }
        ArrayList<UserBasicInfo> userList = new ArrayList<UserBasicInfo>();
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        try {
            UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            if (UserCoreUtil.isEveryoneRole((String)roleName, (RealmConfiguration)userRealm.getRealmConfiguration())) {
                List users = ((AbstractUserStoreManager)userRealm.getUserStoreManager()).listUsersWithID("*", -1);
                for (User user : users) {
                    userList.add(new UserBasicInfo(user.getUserID(), user.getDomainQualifiedUsername()));
                }
            }
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while getting the realmConfiguration.", e);
        }
        List<String> disabledDomainName = this.getDisabledDomainNames();
        try {
            Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)false);
            Object object = null;
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT UM_USER_NAME, UM_DOMAIN_NAME FROM UM_HYBRID_USER_ROLE, UM_DOMAIN WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;) AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=:UM_TENANT_ID; AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID", "UM_ID");){
                statement.setString("UM_ROLE_NAME", roleName);
                statement.setInt("UM_TENANT_ID", tenantId);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        String name = resultSet.getString(1);
                        String domain = resultSet.getString(2);
                        if (disabledDomainName.contains(domain)) continue;
                        if (StringUtils.isNotEmpty((String)domain)) {
                            name = UserCoreUtil.addDomainToName((String)name, (String)domain);
                        }
                        userList.add(new UserBasicInfo(this.getUserIDByName(name, tenantDomain), name));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while while getting the user list of role for role name: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
        return userList;
    }

    protected String getUserIDByName(String name, String tenantDomain) throws IdentityRoleManagementException {
        return this.userIDResolver.getIDByName(name, tenantDomain);
    }

    @Override
    public List<GroupBasicInfo> getGroupListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        if (!this.isExistingRoleID(roleID, tenantDomain)) {
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), "Role id: " + roleID + " does not exist in the system.");
        }
        String roleName = this.getRoleNameByID(roleID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        ArrayList<GroupBasicInfo> groupList = new ArrayList<GroupBasicInfo>();
        ArrayList<String> groupNames = new ArrayList<String>();
        List<String> disabledDomainName = this.getDisabledDomainNames();
        String primaryDomainName = IdentityUtil.getPrimaryDomainName();
        if (primaryDomainName != null) {
            primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
        }
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT UM_GROUP_NAME, UM_DOMAIN_NAME FROM UM_HYBRID_GROUP_ROLE, UM_DOMAIN WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=:UM_ROLE_NAME; AND UM_TENANT_ID=:UM_TENANT_ID;) AND UM_HYBRID_GROUP_ROLE.UM_TENANT_ID=:UM_TENANT_ID; AND UM_HYBRID_GROUP_ROLE.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID", "UM_ID");){
            statement.setString("UM_ROLE_NAME", roleName);
            statement.setInt("UM_TENANT_ID", tenantId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString(1);
                    String domain = resultSet.getString(2);
                    if (disabledDomainName.contains(domain)) continue;
                    name = !StringUtils.equals((String)primaryDomainName, (String)domain) ? UserCoreUtil.addDomainToName((String)name, (String)domain) : primaryDomainName + UserCoreConstants.DOMAIN_SEPARATOR + name;
                    groupNames.add(name);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while while getting the group list of role for role name: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, roleName, tenantDomain), e);
        }
        Map<String, String> groupNamesToIDs = this.getGroupIDsByNames(groupNames, tenantDomain);
        groupNamesToIDs.forEach((groupName, groupID) -> groupList.add(new GroupBasicInfo((String)groupID, (String)groupName)));
        return groupList;
    }

    protected Map<String, String> getGroupIDsByNames(List<String> names, String tenantDomain) throws IdentityRoleManagementException {
        return this.groupIDResolver.getIDsByNames(names, tenantDomain);
    }

    private List<String> getDisabledDomainNames() throws IdentityRoleManagementException {
        RealmConfiguration secondaryRealmConfiguration;
        try {
            if (CarbonContext.getThreadLocalCarbonContext().getUserRealm() == null || CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration() == null) {
                return new ArrayList<String>();
            }
            secondaryRealmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getSecondaryRealmConfig();
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "Error while retrieving user store configurations", e);
        }
        ArrayList<String> disableDomainName = new ArrayList<String>();
        if (secondaryRealmConfiguration != null) {
            do {
                if (!Boolean.parseBoolean(secondaryRealmConfiguration.getUserStoreProperty("Disabled"))) continue;
                String domainName = secondaryRealmConfiguration.getUserStoreProperty("DomainName");
                disableDomainName.add(domainName.toUpperCase(Locale.ENGLISH));
            } while ((secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) != null);
        }
        return disableDomainName;
    }

    @Override
    public List<String> getPermissionListOfRole(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String roleName = this.appendInternalDomain(this.getRoleNameByID(roleID, tenantDomain));
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenantDomain);
            carbonContext.setTenantId(tenantId);
            List<String> list = this.getSelectedPermissions(this.getUserAdminProxy().getRolePermissions(roleName, tenantId));
            return list;
        }
        catch (UserAdminException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "An error occurred when retrieving permissions of role : " + roleID, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public RoleBasicInfo setPermissionsForRole(String roleID, List<String> permissions, String tenantDomain) throws IdentityRoleManagementException {
        String roleName = this.appendInternalDomain(this.getRoleNameByID(roleID, tenantDomain));
        if (permissions == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Permissions list is null. Therefore not proceeding further.");
            }
            return new RoleBasicInfo(roleID, roleName);
        }
        try {
            this.getUserAdminProxy().setRoleUIPermission(roleName, permissions.toArray(new String[0]));
            this.clearUserRolesCacheByTenant(IdentityTenantUtil.getTenantId((String)tenantDomain));
            return new RoleBasicInfo(roleID, roleName);
        }
        catch (UserAdminException e) {
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), "An error occurred when setting permissions for the role: " + roleName, e);
        }
    }

    @Override
    public void deleteUser(String userID, String tenantDomain) throws IdentityRoleManagementException {
        String userName = this.getUserNameByID(userID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String primaryDomainName = IdentityUtil.getPrimaryDomainName();
        if (primaryDomainName != null) {
            primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
        }
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=:UM_USER_NAME; AND UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)", "UM_ID");){
                userName = UserCoreUtil.addDomainToName((String)userName, (String)primaryDomainName);
                String domainName = UserCoreUtil.extractDomainFromName((String)userName);
                if (domainName != null) {
                    domainName = domainName.toUpperCase(Locale.ENGLISH);
                }
                String nameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
                statement.setString("UM_USER_NAME", nameWithoutDomain);
                statement.setInt("UM_TENANT_ID", tenantId);
                statement.setString("UM_DOMAIN_NAME", domainName);
                statement.executeUpdate();
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String errorMessage = "Error while removing the user: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, userName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while removing the user: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, userName, tenantDomain), e);
        }
        this.clearUserRolesCache(userName, tenantId);
    }

    protected String getUserNameByID(String id, String tenantDomain) throws IdentityRoleManagementException {
        return this.userIDResolver.getNameByID(id, tenantDomain);
    }

    protected List<String> getUserNamesByIDs(List<String> userIDs, String tenantDomain) throws IdentityRoleManagementException {
        return this.userIDResolver.getNamesByIDs(userIDs, tenantDomain);
    }

    @Override
    public void deleteGroup(String groupID, String tenantDomain) throws IdentityRoleManagementException {
        String groupName = this.getGroupNameByID(groupID, tenantDomain);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String primaryDomainName = IdentityUtil.getPrimaryDomainName();
        if (primaryDomainName != null) {
            primaryDomainName = primaryDomainName.toUpperCase(Locale.ENGLISH);
        }
        try (Connection connection = IdentityDatabaseUtil.getUserDBConnection((boolean)true);){
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, "DELETE FROM UM_HYBRID_GROUP_ROLE WHERE UM_GROUP_NAME=:UM_GROUP_NAME; AND UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=:UM_TENANT_ID; AND UM_DOMAIN_NAME=:UM_DOMAIN_NAME;)", "UM_ID");){
                groupName = UserCoreUtil.addDomainToName((String)groupName, (String)primaryDomainName);
                String domainName = UserCoreUtil.extractDomainFromName((String)groupName);
                if (domainName != null) {
                    domainName = domainName.toUpperCase(Locale.ENGLISH);
                }
                String nameWithoutDomain = UserCoreUtil.removeDomainFromName((String)groupName);
                statement.setString("UM_GROUP_NAME", nameWithoutDomain);
                statement.setInt("UM_TENANT_ID", tenantId);
                statement.setString("UM_DOMAIN_NAME", domainName);
                statement.executeUpdate();
                IdentityDatabaseUtil.commitUserDBTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackUserDBTransaction((Connection)connection);
                String errorMessage = "Error while removing the group: %s in the tenantDomain: %s";
                throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, groupName, tenantDomain), e);
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while removing the group: %s in the tenantDomain: %s";
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), String.format(errorMessage, groupName, tenantDomain), e);
        }
        this.clearUserRolesCacheByTenant(tenantId);
    }

    protected String getGroupNameByID(String id, String tenantDomain) throws IdentityRoleManagementException {
        return this.groupIDResolver.getNameByID(id, tenantDomain);
    }

    protected Map<String, String> getGroupNamesByIDs(List<String> groupIDs, String tenantDomain) throws IdentityRoleManagementException {
        return this.groupIDResolver.getNamesByIDs(groupIDs, tenantDomain);
    }

    @Override
    public String getRoleIDByName(String roleName, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String roleID = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ATTR_VALUE FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME; AND ATTR_NAME=:ATTR_NAME;");){
            statement.setInt("TENANT_ID", tenantId);
            statement.setString("ROLE_NAME", roleName);
            statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (++count > 1) {
                        String errorMessage = "Invalid scenario. Multiple roles found for the given role name: " + roleName + " and tenantDomain: " + tenantDomain;
                        throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                    }
                    roleID = resultSet.getString(1);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the role ID for the given role name: " + roleName + " and tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        if (roleID == null) {
            String errorMessage = "A role doesn't exist with name: " + roleName + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
        }
        return roleID;
    }

    protected Map<String, String> getRoleIDsByNames(List<String> roleNames, String tenantDomain) throws IdentityRoleManagementException {
        Map<String, String> roleNamesToIDs;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            roleNamesToIDs = this.batchProcessRoleNames(roleNames, tenantDomain, connection);
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the role ID for the given group names in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        return roleNamesToIDs;
    }

    private Map<String, String> batchProcessRoleNames(List<String> roleNames, String tenantDomain, Connection connection) throws SQLException, IdentityRoleManagementException {
        HashMap<String, String> roleNamesToIDs = new HashMap<String, String>();
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        for (String roleName : roleNames) {
            NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ATTR_VALUE FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME; AND ATTR_NAME=:ATTR_NAME;");
            Throwable throwable = null;
            try {
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ROLE_NAME", roleName);
                statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
                int count = 0;
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable2 = null;
                try {
                    while (resultSet.next()) {
                        if (++count > 1) {
                            String errorMessage = "Invalid scenario. Multiple roles found for the given role name: " + roleName + " and tenantDomain: " + tenantDomain;
                            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                        }
                        String roleID = resultSet.getString(1);
                        roleNamesToIDs.put(roleName, roleID);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return roleNamesToIDs;
    }

    @Override
    public String getRoleNameByID(String roleID, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String roleName = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ROLE_NAME FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ATTR_NAME=:ATTR_NAME; AND ATTR_VALUE=:ATTR_VALUE;");){
            statement.setInt("TENANT_ID", tenantId);
            statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
            statement.setString("ATTR_VALUE", roleID);
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (++count > 1) {
                        String message = "Invalid scenario. Multiple roles found for the given role ID: " + roleID + " and tenantDomain: " + tenantDomain;
                        this.log.warn((Object)message);
                    }
                    roleName = resultSet.getString(1);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the role name for the given role ID: " + roleID + " and tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        if (roleName == null) {
            String errorMessage = "A role doesn't exist with id: " + roleID + " in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementClientException(RoleConstants.Error.ROLE_NOT_FOUND.getCode(), errorMessage);
        }
        return this.removeInternalDomain(roleName);
    }

    private UserRealmProxy getUserAdminProxy() {
        UserRealm realm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        return new UserRealmProxy((org.wso2.carbon.user.core.UserRealm)realm);
    }

    private List<String> getSelectedPermissions(UIPermissionNode node) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (node.isSelected()) {
            permissions.add(node.getResourcePath());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Permission: " + node.getDisplayName() + " and resourcePath: " + node.getResourcePath() + " added to the permission map."));
            }
        } else {
            Object[] childNodes = node.getNodeList();
            if (ArrayUtils.isNotEmpty((Object[])childNodes)) {
                for (Object childNode : childNodes) {
                    permissions.addAll(this.getSelectedPermissions((UIPermissionNode)childNode));
                }
            }
        }
        return permissions;
    }

    private void clearUserRolesCacheByTenant(int tenantId) {
        UserRolesCache.getInstance().clearCacheByTenant(tenantId);
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByTenant(tenantId);
    }

    private void clearUserRolesCache(String usernameWithDomain, int tenantId) {
        String userStoreDomain = IdentityUtil.extractDomainFromName((String)usernameWithDomain);
        if (this.isUserRoleCacheEnabled(tenantId, userStoreDomain)) {
            UserRolesCache.getInstance().clearCacheEntry(this.getCacheIdentifier(tenantId, userStoreDomain), tenantId, usernameWithDomain);
        }
        AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
        authorizationCache.clearCacheByUser(tenantId, usernameWithDomain);
    }

    private boolean isUserRoleCacheEnabled(int tenantId, String userStoreDomain) {
        return Boolean.parseBoolean(this.getUserStoreProperty("UserRolesCacheEnabled", tenantId, userStoreDomain));
    }

    private String getCacheIdentifier(int tenantId, String userStoreDomain) {
        String userCoreCacheIdentifier = this.getUserStoreProperty("UserCoreCacheIdentifier", tenantId, userStoreDomain);
        if (StringUtils.isNotBlank((String)userCoreCacheIdentifier)) {
            return userCoreCacheIdentifier;
        }
        return "defaultCacheDomain";
    }

    private String getUserStoreProperty(String property, int tenantId, String userStoreDomain) {
        RealmService realmService = RoleManagementServiceComponentHolder.getInstance().getRealmService();
        String propValue = null;
        if (realmService != null) {
            try {
                if (IdentityUtil.getPrimaryDomainName().equals(userStoreDomain)) {
                    propValue = realmService.getTenantUserRealm(tenantId).getRealmConfiguration().getUserStoreProperty(property);
                } else {
                    UserStoreManager userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                    if (userStoreManager instanceof AbstractUserStoreManager) {
                        propValue = ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(userStoreDomain).getRealmConfiguration().getUserStoreProperty(property);
                    }
                }
            }
            catch (UserStoreException e) {
                this.log.error((Object)String.format("Error while retrieving property %s for userstore %s in tenantId %s. Returning null.", property, userStoreDomain, tenantId), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Userstore property %s is set to %s for userstore %s in tenantId %s", property, propValue, userStoreDomain, tenantId));
        }
        return propValue;
    }
}

