/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.role.mgt.core.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.database.utils.jdbc.NamedPreparedStatement;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementClientException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementServerException;
import org.wso2.carbon.identity.role.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.mgt.core.dao.GroupDAO;

public class GroupDAOImpl
implements GroupDAO {
    @Override
    public String getGroupNameByID(String id, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String groupName = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ROLE_NAME FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ATTR_NAME=:ATTR_NAME; AND ATTR_VALUE=:ATTR_VALUE;");){
            statement.setInt("TENANT_ID", tenantId);
            statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
            statement.setString("ATTR_VALUE", id);
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (++count > 1) {
                        String errorMessage = "Invalid scenario. Multiple groups found for the given group ID: " + id + " and tenantDomain: " + tenantDomain;
                        throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                    }
                    groupName = resultSet.getString(1);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the group name for the given group ID: " + id + " and tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        return groupName;
    }

    @Override
    public Map<String, String> getGroupNamesByIDs(List<String> ids, String tenantDomain) throws IdentityRoleManagementException {
        Map<String, String> groupIdsToNames;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            groupIdsToNames = this.batchProcessGroupIDs(ids, tenantDomain, connection);
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the group name for the given group Ids in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        return groupIdsToNames;
    }

    private Map<String, String> batchProcessGroupIDs(List<String> ids, String tenantDomain, Connection connection) throws SQLException, IdentityRoleManagementException {
        HashMap<String, String> groupIdsToNames = new HashMap<String, String>();
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        for (String id : ids) {
            NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ROLE_NAME FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ATTR_NAME=:ATTR_NAME; AND ATTR_VALUE=:ATTR_VALUE;");
            Throwable throwable = null;
            try {
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
                statement.setString("ATTR_VALUE", id);
                int count = 0;
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable2 = null;
                try {
                    while (resultSet.next()) {
                        if (++count > 1) {
                            String errorMessage = "Invalid scenario. Multiple groups found for the given group ID: " + id + " and tenantDomain: " + tenantDomain;
                            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                        }
                        String groupName = resultSet.getString(1);
                        groupIdsToNames.put(id, groupName);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return groupIdsToNames;
    }

    @Override
    public String getGroupIDByName(String name, String tenantDomain) throws IdentityRoleManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String groupID = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ATTR_VALUE FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME; AND ATTR_NAME=:ATTR_NAME;");){
            statement.setInt("TENANT_ID", tenantId);
            statement.setString("ROLE_NAME", name);
            statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (++count > 1) {
                        String errorMessage = "Invalid scenario. Multiple groups found for the given group name: " + name + " and tenantDomain: " + tenantDomain;
                        throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                    }
                    groupID = resultSet.getString(1);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the group ID for the given group name: " + name + " and tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        return groupID;
    }

    @Override
    public Map<String, String> getGroupIDsByNames(List<String> names, String tenantDomain) throws IdentityRoleManagementException {
        Map<String, String> groupNamesToIDs;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            groupNamesToIDs = this.batchProcessGroupNames(names, tenantDomain, connection);
        }
        catch (SQLException e) {
            String errorMessage = "Error while resolving the group ID for the given group names in the tenantDomain: " + tenantDomain;
            throw new IdentityRoleManagementServerException(RoleConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), errorMessage, e);
        }
        return groupNamesToIDs;
    }

    private Map<String, String> batchProcessGroupNames(List<String> names, String tenantDomain, Connection connection) throws SQLException, IdentityRoleManagementException {
        HashMap<String, String> groupNamesToIDs = new HashMap<String, String>();
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        for (String name : names) {
            NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ATTR_VALUE FROM IDN_SCIM_GROUP WHERE TENANT_ID=:TENANT_ID; AND ROLE_NAME=:ROLE_NAME; AND ATTR_NAME=:ATTR_NAME;");
            Throwable throwable = null;
            try {
                statement.setInt("TENANT_ID", tenantId);
                statement.setString("ROLE_NAME", name);
                statement.setString("ATTR_NAME", "urn:ietf:params:scim:schemas:core:2.0:id");
                int count = 0;
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable2 = null;
                try {
                    while (resultSet.next()) {
                        if (++count > 1) {
                            String errorMessage = "Invalid scenario. Multiple groups found for the given group name: " + name + " and tenantDomain: " + tenantDomain;
                            throw new IdentityRoleManagementClientException(RoleConstants.Error.INVALID_REQUEST.getCode(), errorMessage);
                        }
                        String groupID = resultSet.getString(1);
                        groupNamesToIDs.put(name, groupID);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return groupNamesToIDs;
    }
}

