/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.util;

import java.io.File;
import java.security.SecureRandom;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.wso2.carbon.analytics.message.tracer.handler.data.TracingInfo;
import org.wso2.carbon.context.CarbonContext;

public class HandlerUtils {
    private static final Log LOG = LogFactory.getLog(HandlerUtils.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    private HandlerUtils() {
    }

    public static String getUniqueId() {
        SecureRandom secRandom = new SecureRandom();
        return String.valueOf(System.nanoTime()) + Math.round(secRandom.nextFloat() * 1.2345679E8f);
    }

    public static void logTracingInfo(TracingInfo tracingInfo) {
        LOG.info((Object)("Massage Info: Transaction id=" + tracingInfo.getActivityId() + "  Message direction=" + tracingInfo.getMessageDirection() + "  Server name=" + tracingInfo.getHost() + "  Timestamp=" + tracingInfo.getTimestamp() + "  Service name=" + tracingInfo.getServiceName() + "  Operation Name=" + tracingInfo.getOperationName()));
    }

    public static Document convertToDocument(File file) throws Exception {
        DocumentBuilderFactory fac = HandlerUtils.getSecuredDocumentBuilder();
        try {
            return fac.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            throw new Exception("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static String getUserNameIN(MessageContext messageContext) {
        String basicAuthHeaderValue;
        String[] basicAuth;
        String basicAuthHeader;
        HttpSession session;
        String userName = "";
        if (messageContext == null) {
            return userName;
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null && (session = request.getSession(false)) != null) {
            String tenantDomain = (String)session.getAttribute("tenantDomain");
            userName = (String)session.getAttribute("wso2carbon.admin.logged.in");
            if (userName != null && tenantDomain != null && !"carbon.super".equalsIgnoreCase(tenantDomain)) {
                userName = userName + tenantDomain;
            }
        }
        if (userName != null && !userName.isEmpty()) {
            return userName;
        }
        Object transportHeaders = messageContext.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null && (basicAuthHeader = (String)((Map)transportHeaders).get("Authorization")) != null && !basicAuthHeader.isEmpty() && (basicAuth = (basicAuthHeaderValue = new String(Base64.decodeBase64((byte[])basicAuthHeader.replace("Basic", "").trim().getBytes()))).split(":")).length >= 2) {
            userName = basicAuth[0];
            return userName;
        }
        if ("AuthenticationAdmin".equalsIgnoreCase(messageContext.getAxisService().getName()) && "in".equalsIgnoreCase(messageContext.getAxisMessage().getDirection()) && "login".equalsIgnoreCase(messageContext.getAxisOperation().getName().getLocalPart())) {
            try {
                OMElement responsePayload = messageContext.getEnvelope().getBody().getFirstElement();
                if (responsePayload != null) {
                    userName = responsePayload.getFirstChildWithName(new QName(responsePayload.getNamespace().getNamespaceURI(), "username", responsePayload.getNamespace().getPrefix())).getText();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while trying to get the user name form authentication request", (Throwable)e);
            }
            return userName;
        }
        return "";
    }

    public static String getUserNameOUT(MessageContext messageContext) {
        String basicAuthHeaderValue;
        String[] basicAuth;
        String basicAuthHeader;
        String userName = "";
        if (messageContext == null) {
            return userName;
        }
        userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (userName != null && !userName.isEmpty()) {
            return userName;
        }
        Object transportHeaders = messageContext.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null && (basicAuthHeader = (String)((Map)transportHeaders).get("Authorization")) != null && !basicAuthHeader.isEmpty() && (basicAuth = (basicAuthHeaderValue = new String(Base64.decodeBase64((byte[])basicAuthHeader.replace("Basic", "").trim().getBytes()))).split(":")).length >= 2) {
            userName = basicAuth[0];
            return userName;
        }
        return "";
    }
}

