/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.util;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.analytics.message.tracer.handler.data.TracingInfo;
import org.wso2.carbon.analytics.message.tracer.handler.internal.MessageTracerServiceComponent;
import org.wso2.carbon.base.ServerConfiguration;

public class AgentUtil {
    private static final String NAME = "Name";
    public static final String TRANSPORT_HEADER = "transport-header-";
    private static String serverName = null;

    public static String getServerName() {
        String[] properties;
        if (serverName == null && (properties = ServerConfiguration.getInstance().getProperties(NAME)) != null && properties.length > 0) {
            serverName = properties[0];
        }
        return serverName;
    }

    public static boolean allowedServices(String serverName) {
        return "__SynapseService".equals(serverName) || MessageTracerServiceComponent.getMessageTracerConfiguration().getMessageTracingEnabledAdminServices().contains(serverName);
    }

    public static void setTransportHeaders(TracingInfo tracingInfo, Map<String, Object> properties) {
        if (tracingInfo != null && properties != null) {
            HashMap<String, String> transportHeaders = new HashMap<String, String>(properties.size());
            for (Map.Entry<String, Object> headerEntry : properties.entrySet()) {
                if (headerEntry.getValue() == null) continue;
                transportHeaders.put(TRANSPORT_HEADER + headerEntry.getKey(), headerEntry.getValue().toString());
            }
            if (tracingInfo.getAdditionalValues() != null) {
                tracingInfo.getAdditionalValues().putAll(transportHeaders);
            } else {
                tracingInfo.setAdditionalValues(transportHeaders);
            }
        }
    }
}

