/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.stream;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;

public class StreamDefCreator {
    private static final String SERVER_NAME = "server";
    private static final String ACTIVITY_ID = "activity_id";
    private static final String ACTIVITY_STATUS = "status";
    private static final String streamName = "DAS_MESSAGE_TRACE";
    private static final String version = "1.0.0";
    private static final String nickName = "MessageTracerAgent";
    private static final String description = "Publish Message Tracing Event";

    private StreamDefCreator() {
    }

    public static StreamDefinition getStreamDef() throws MalformedStreamDefinitionException {
        StreamDefinition streamDefinition = new StreamDefinition(streamName, version);
        streamDefinition.setDescription(description);
        streamDefinition.setNickName(nickName);
        streamDefinition.setMetaData(StreamDefCreator.getMetaDefinitions());
        streamDefinition.setPayloadData(StreamDefCreator.getPayloadDefinition());
        streamDefinition.setCorrelationData(StreamDefCreator.getCorrelationDefinition());
        return streamDefinition;
    }

    private static List<Attribute> getMetaDefinitions() {
        ArrayList<Attribute> metaList = new ArrayList<Attribute>(3);
        metaList.add(new Attribute("request_url", AttributeType.STRING));
        metaList.add(new Attribute("host", AttributeType.STRING));
        metaList.add(new Attribute(SERVER_NAME, AttributeType.STRING));
        return metaList;
    }

    private static List<Attribute> getPayloadDefinition() {
        ArrayList<Attribute> payloadList = new ArrayList<Attribute>(8);
        payloadList.add(new Attribute("service_name", AttributeType.STRING));
        payloadList.add(new Attribute("operation_name", AttributeType.STRING));
        payloadList.add(new Attribute("message_direction", AttributeType.STRING));
        payloadList.add(new Attribute("soap_body", AttributeType.STRING));
        payloadList.add(new Attribute("soap_header", AttributeType.STRING));
        payloadList.add(new Attribute("timestamp", AttributeType.LONG));
        payloadList.add(new Attribute(ACTIVITY_STATUS, AttributeType.STRING));
        payloadList.add(new Attribute("username", AttributeType.STRING));
        return payloadList;
    }

    private static List<Attribute> getCorrelationDefinition() {
        ArrayList<Attribute> correlationList = new ArrayList<Attribute>(1);
        correlationList.add(new Attribute(ACTIVITY_ID, AttributeType.STRING));
        return correlationList;
    }
}

