/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.publish;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.data.TracingInfo;
import org.wso2.carbon.analytics.message.tracer.handler.stream.StreamDefCreator;
import org.wso2.carbon.analytics.message.tracer.handler.util.ServiceHolder;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class Publisher {
    private static final Log LOG = LogFactory.getLog(Publisher.class);

    public void publish(TracingInfo tracingInfo) {
        EventStreamService eventStreamService;
        StreamDefinition streamDef;
        List<Object> correlationData = Publisher.getCorrelationData(tracingInfo);
        List<Object> metaData = Publisher.getMetaData(tracingInfo);
        List<Object> payLoadData = Publisher.getEventData(tracingInfo);
        Map<String, String> arbitraryData = tracingInfo.getAdditionalValues();
        try {
            streamDef = StreamDefCreator.getStreamDef();
        }
        catch (MalformedStreamDefinitionException e) {
            LOG.error((Object)("Unable to create stream: " + e.getMessage()), (Throwable)e);
            return;
        }
        if (streamDef != null && (eventStreamService = ServiceHolder.getEventStreamService()) != null) {
            try {
                eventStreamService.addEventStreamDefinition(streamDef);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Added stream definition to event publisher service.");
                }
            }
            catch (EventStreamConfigurationException e) {
                LOG.error((Object)("Error in adding stream definition to service:" + e.getMessage()), (Throwable)e);
            }
            Event tracingEvent = new Event();
            tracingEvent.setStreamId(streamDef.getStreamId());
            tracingEvent.setCorrelationData(correlationData.toArray());
            tracingEvent.setMetaData(metaData.toArray());
            tracingEvent.setPayloadData(payLoadData.toArray());
            tracingEvent.setArbitraryDataMap(arbitraryData);
            eventStreamService.publish(tracingEvent);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Successfully published event");
            }
        }
    }

    public static List<Object> getCorrelationData(TracingInfo tracingInfo) {
        ArrayList<Object> correlationData = new ArrayList<Object>(1);
        correlationData.add(tracingInfo.getActivityId());
        return correlationData;
    }

    public static List<Object> getMetaData(TracingInfo tracingInfo) {
        ArrayList<Object> metaData = new ArrayList<Object>(7);
        metaData.add(tracingInfo.getRequestUrl());
        metaData.add(tracingInfo.getHost());
        metaData.add(tracingInfo.getServer());
        return metaData;
    }

    public static List<Object> getEventData(TracingInfo tracingInfo) {
        ArrayList<Object> payloadData = new ArrayList<Object>(8);
        payloadData.add(tracingInfo.getServiceName());
        payloadData.add(tracingInfo.getOperationName());
        payloadData.add(tracingInfo.getMessageDirection());
        payloadData.add(tracingInfo.getPayload());
        payloadData.add(tracingInfo.getHeader());
        payloadData.add(tracingInfo.getTimestamp());
        payloadData.add(tracingInfo.getStatus());
        payloadData.add(tracingInfo.getUserName());
        return payloadData;
    }
}

