/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.publish;

import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.publish.MessageTracerStatMessage;
import org.wso2.carbon.analytics.message.tracer.handler.util.ServiceHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ClusterNotifier {
    private static final Log LOG = LogFactory.getLog(ClusterNotifier.class);
    private int tenantId;

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void notifyClusterMessageTraceChange() {
        ConfigurationContextService configCtxService;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Notifying cluster message trace updates.");
        }
        if ((configCtxService = ServiceHolder.getConfigurationContextService()) == null) {
            LOG.error((Object)"ConfigurationContextService is empty.");
            return;
        }
        ConfigurationContext configCtx = configCtxService.getServerConfigContext();
        ClusteringAgent agent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clustering Agent: " + agent));
        }
        if (agent != null) {
            MessageTracerStatMessage msg = new MessageTracerStatMessage();
            msg.setTenantId(this.getTenantId());
            try {
                agent.sendMessage((ClusteringMessage)msg, true);
            }
            catch (ClusteringFault e) {
                LOG.error((Object)("Unable to send cluster message :" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

