/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.modules;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.conf.EventingConfigData;
import org.wso2.carbon.analytics.message.tracer.handler.data.TracingInfo;
import org.wso2.carbon.analytics.message.tracer.handler.publish.Publisher;
import org.wso2.carbon.analytics.message.tracer.handler.util.AgentUtil;
import org.wso2.carbon.analytics.message.tracer.handler.util.HandlerUtils;
import org.wso2.carbon.analytics.message.tracer.handler.util.PublisherUtil;
import org.wso2.carbon.analytics.message.tracer.handler.util.TenantEventConfigData;
import org.wso2.carbon.core.util.SystemFilter;

public class ActivityOutHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(ActivityOutHandler.class);
    private static final String HTTP_SC = "HTTP_SC";
    private Publisher publisher;

    public void init(HandlerDescription handlerdesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initiate message tracer handler");
        }
        super.init(handlerdesc);
        this.publisher = new Publisher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        Map<Integer, EventingConfigData> tenantSpecificEventConfig;
        EventingConfigData eventingConfigData;
        MessageContext inMessageContext = null;
        int tenantID = PublisherUtil.getTenantId(messageContext);
        if (tenantID == -1) {
            inMessageContext = messageContext.getOperationContext().getMessageContext("In");
            if (inMessageContext == null) return Handler.InvocationResponse.CONTINUE;
            Object tId = inMessageContext.getProperty("tenantId");
            if (tId == null) return Handler.InvocationResponse.CONTINUE;
            tenantID = Integer.parseInt(tId.toString());
        }
        if ((eventingConfigData = (tenantSpecificEventConfig = TenantEventConfigData.getTenantSpecificEventingConfigData()).get(tenantID)) == null || !eventingConfigData.isMessageTracingEnable()) return Handler.InvocationResponse.CONTINUE;
        AxisService service = messageContext.getAxisService();
        if (service == null || SystemFilter.isFilteredOutService((AxisServiceGroup)service.getAxisServiceGroup()) && !AgentUtil.allowedServices(service.getName()) || service.isClientSide()) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (messageContext.getMessageID() == null) {
            messageContext.setMessageID(HandlerUtils.getUniqueId());
        }
        if (inMessageContext == null) {
            inMessageContext = messageContext.getOperationContext().getMessageContext("In");
        }
        String activityID = this.getActivityId(messageContext, inMessageContext);
        TracingInfo tracingInfo = this.getTracingInfo(messageContext, activityID);
        Map transportHeadersMap = (Map)messageContext.getProperty("TRANSPORT_HEADERS");
        AgentUtil.setTransportHeaders(tracingInfo, transportHeadersMap);
        try {
            boolean isEmptyBody;
            if (eventingConfigData.isDumpBodyEnable() && !(isEmptyBody = this.isEmptyBody(transportHeadersMap))) {
                this.setPayloadAndHeader(messageContext, tracingInfo);
            }
            tracingInfo.setStatus(this.getStatus(messageContext));
            if (eventingConfigData.isPublishToBAMEnable()) {
                this.publisher.publish(tracingInfo);
            }
            if (!eventingConfigData.isLoggingEnable()) return Handler.InvocationResponse.CONTINUE;
            HandlerUtils.logTracingInfo(tracingInfo);
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (OMException e) {
            LOG.error((Object)("Unable to get SOAP details " + e.getMessage()), (Throwable)e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setPayloadAndHeader(MessageContext messageContext, TracingInfo tracingInfo) throws AxisFault {
        SOAPHeader header;
        this.buildSoapMessage(messageContext);
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        SOAPBody body = soapEnvelope.getBody();
        if (body != null) {
            tracingInfo.setPayload(body.toString());
        }
        if ((header = soapEnvelope.getHeader()) != null) {
            tracingInfo.setHeader(header.toString());
        }
    }

    private String getStatus(MessageContext messageContext) {
        String status = "success";
        if (2 == messageContext.getFLOW()) {
            int statusCode;
            Object httpSC = messageContext.getProperty(HTTP_SC);
            status = httpSC != null ? ((statusCode = Integer.parseInt(httpSC.toString())) == 200 || statusCode == 202 ? "success" : "fault") : "success";
        } else if (4 == messageContext.getFLOW()) {
            status = "fault";
        }
        return status;
    }

    private boolean isEmptyBody(Map<String, Object> transportHeadersMap) {
        Object contentLength;
        boolean isEmptyBody = false;
        if (transportHeadersMap != null && (contentLength = transportHeadersMap.get("Content-Length")) != null && Integer.parseInt(contentLength.toString()) == 0) {
            isEmptyBody = true;
        }
        return isEmptyBody;
    }

    private String getActivityId(MessageContext messageContext, MessageContext inMessageContext) {
        String activityID = HandlerUtils.getUniqueId();
        Object transportHeaders = messageContext.getProperty("TRANSPORT_HEADERS");
        Object inTransportHeaders = null;
        if (inMessageContext != null) {
            inTransportHeaders = inMessageContext.getProperty("TRANSPORT_HEADERS");
        }
        if (transportHeaders != null) {
            String aid = (String)((Map)transportHeaders).get("activityID");
            if (aid == null || aid.equals("")) {
                String inID;
                if (inTransportHeaders != null && (inID = (String)((Map)inTransportHeaders).get("activityID")) != null && !inID.equals("")) {
                    activityID = inID;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"OUT using IN's AID, transport header present");
                    }
                }
                ((Map)messageContext.getProperty("TRANSPORT_HEADERS")).put("activityID", activityID);
            } else {
                activityID = aid;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OUT using new AID :" + aid));
                }
            }
        } else {
            String inID;
            if (inTransportHeaders != null && (inID = (String)((Map)inTransportHeaders).get("activityID")) != null && !inID.equals("")) {
                activityID = inID;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"OUT using IN's AID, transport header absent");
                }
            }
            HashMap<String, String> headers = new HashMap<String, String>(1);
            headers.put("activityID", activityID);
            messageContext.setProperty("TRANSPORT_HEADERS", headers);
        }
        return activityID;
    }

    private void buildSoapMessage(MessageContext messageContext) throws AxisFault {
        try {
            Class<?> cls = Class.forName("org.apache.synapse.transport.passthru.util.RelayUtils");
            Class[] paramClasses = new Class[]{MessageContext.class, Boolean.TYPE};
            Method method = cls.getMethod("buildMessage", paramClasses);
            method.invoke(null, messageContext, false);
        }
        catch (ClassNotFoundException ignore) {
            LOG.warn((Object)ignore);
        }
        catch (Exception e) {
            throw new AxisFault("Error in building input message: " + e.getMessage(), (Throwable)e);
        }
    }

    private TracingInfo getTracingInfo(MessageContext messageContext, String activityID) {
        TracingInfo tracingInfo = new TracingInfo();
        tracingInfo.setActivityId(activityID);
        tracingInfo.setServer(AgentUtil.getServerName());
        tracingInfo.setMessageDirection("OUT");
        tracingInfo.setUserName(HandlerUtils.getUserNameOUT(messageContext));
        tracingInfo.setHost(PublisherUtil.getHostAddress());
        tracingInfo.setServiceName(messageContext.getAxisService().getName());
        tracingInfo.setOperationName(messageContext.getAxisOperation().getName().getLocalPart());
        tracingInfo.setTimestamp(System.currentTimeMillis());
        return tracingInfo;
    }
}

