/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.modules;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.conf.EventingConfigData;
import org.wso2.carbon.analytics.message.tracer.handler.data.TracingInfo;
import org.wso2.carbon.analytics.message.tracer.handler.publish.Publisher;
import org.wso2.carbon.analytics.message.tracer.handler.util.AgentUtil;
import org.wso2.carbon.analytics.message.tracer.handler.util.HandlerUtils;
import org.wso2.carbon.analytics.message.tracer.handler.util.PublisherUtil;
import org.wso2.carbon.analytics.message.tracer.handler.util.TenantEventConfigData;
import org.wso2.carbon.core.util.SystemFilter;

public class ActivityInHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(ActivityInHandler.class);
    private Publisher publisher;

    public void init(HandlerDescription handlerdesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initiate message tracer handler");
        }
        super.init(handlerdesc);
        this.publisher = new Publisher();
    }

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        int tenantID = PublisherUtil.getTenantId(messageContext);
        Map<Integer, EventingConfigData> tenantSpecificEventConfig = TenantEventConfigData.getTenantSpecificEventingConfigData();
        EventingConfigData eventingConfigData = tenantSpecificEventConfig.get(tenantID);
        if (eventingConfigData != null && eventingConfigData.isMessageTracingEnable()) {
            AxisService service;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Message tracing enabled.");
            }
            if ((service = messageContext.getAxisService()) == null || SystemFilter.isFilteredOutService((AxisServiceGroup)service.getAxisServiceGroup()) && !AgentUtil.allowedServices(service.getName()) || service.isClientSide()) {
                return Handler.InvocationResponse.CONTINUE;
            }
            String activityUUID = this.getActivityUUID(messageContext);
            messageContext.setProperty("tenantId", (Object)tenantID);
            TracingInfo tracingInfo = this.getTracingInfo(messageContext, activityUUID);
            AgentUtil.setTransportHeaders(tracingInfo, (Map)messageContext.getProperty("TRANSPORT_HEADERS"));
            try {
                if (eventingConfigData.isDumpBodyEnable()) {
                    SOAPHeader header;
                    this.buildSoapMessage(messageContext);
                    SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
                    this.setMustUnderstandHeader(soapEnvelope);
                    SOAPBody body = soapEnvelope.getBody();
                    if (body != null) {
                        tracingInfo.setPayload(body.toString());
                    }
                    if ((header = soapEnvelope.getHeader()) != null) {
                        tracingInfo.setHeader(header.toString());
                    }
                }
                if (1 == messageContext.getFLOW()) {
                    tracingInfo.setStatus("success");
                } else if (3 == messageContext.getFLOW()) {
                    tracingInfo.setStatus("fault");
                }
                if (eventingConfigData.isPublishToBAMEnable()) {
                    this.publisher.publish(tracingInfo);
                }
                if (eventingConfigData.isLoggingEnable()) {
                    HandlerUtils.logTracingInfo(tracingInfo);
                }
            }
            catch (OMException e) {
                LOG.error((Object)("Unable to get SOAP details " + e.getMessage()), (Throwable)e);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setMustUnderstandHeader(SOAPEnvelope soapEnvelope) {
        if (soapEnvelope.getHeader() != null) {
            Iterator headerBlocks = soapEnvelope.getHeader().getHeadersToProcess(null);
            while (headerBlocks.hasNext()) {
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
                if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand()) continue;
                headerBlock.setProcessed();
            }
        }
    }

    private void buildSoapMessage(MessageContext messageContext) throws AxisFault {
        try {
            Class<?> cls = Class.forName("org.apache.synapse.transport.passthru.util.RelayUtils");
            Class[] paramClasses = new Class[]{MessageContext.class, Boolean.TYPE};
            Method method = cls.getMethod("buildMessage", paramClasses);
            method.invoke(null, messageContext, false);
        }
        catch (ClassNotFoundException ignore) {
            LOG.warn((Object)ignore);
        }
        catch (Exception e) {
            throw new AxisFault("Error in building input message: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getActivityUUID(MessageContext messageContext) {
        String activityUUID = HandlerUtils.getUniqueId();
        Object transportHeaders = messageContext.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null) {
            String aid = (String)((Map)transportHeaders).get("activityID");
            if (aid != null) {
                if (aid.equals("")) {
                    ((Map)messageContext.getProperty("TRANSPORT_HEADERS")).put("activityID", activityUUID);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Propagated AID was empty, IN generating new AID");
                    }
                } else {
                    activityUUID = aid;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"IN using propagated AID");
                    }
                }
            } else {
                ((Map)transportHeaders).put("activityID", activityUUID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Propagated AID was null, IN generating new AID");
                }
            }
        } else {
            TreeMap<String, String> headers = new TreeMap<String, String>();
            headers.put("activityID", activityUUID);
            messageContext.setProperty("TRANSPORT_HEADERS", headers);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Transport headers absent, IN generating new AID");
            }
        }
        return activityUUID;
    }

    private TracingInfo getTracingInfo(MessageContext messageContext, String activityUUID) {
        TracingInfo tracingInfo = new TracingInfo();
        tracingInfo.setActivityId(activityUUID);
        tracingInfo.setServer(AgentUtil.getServerName());
        tracingInfo.setMessageDirection("IN");
        tracingInfo.setHost(PublisherUtil.getHostAddress());
        tracingInfo.setServiceName(messageContext.getAxisService().getName());
        tracingInfo.setOperationName(messageContext.getAxisOperation().getName().getLocalPart());
        tracingInfo.setRequestUrl(String.valueOf(messageContext.getProperty("TransportInURL")));
        tracingInfo.setUserName(HandlerUtils.getUserNameIN(messageContext));
        tracingInfo.setTimestamp(System.currentTimeMillis());
        return tracingInfo;
    }
}

