/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.analytics.message.tracer.handler.conf.EventingConfigData;
import org.wso2.carbon.analytics.message.tracer.handler.conf.MessageTracerConfiguration;
import org.wso2.carbon.analytics.message.tracer.handler.conf.MessageTracerConfigurationManager;
import org.wso2.carbon.analytics.message.tracer.handler.conf.RegistryPersistenceManager;
import org.wso2.carbon.analytics.message.tracer.handler.internal.MessageTracerAxis2ConfigurationContextObserver;
import org.wso2.carbon.analytics.message.tracer.handler.util.ServiceHolder;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.analytics.message.tracer.handler", immediate=true)
public class MessageTracerServiceComponent {
    private static final Log LOG = LogFactory.getLog(MessageTracerServiceComponent.class);
    private ConfigurationContext configurationContext;
    private static MessageTracerConfiguration msgTracerConfiguration;

    @Activate
    protected void activate(ComponentContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"BAM message tracer handler bundle is activated");
        }
        try {
            msgTracerConfiguration = MessageTracerConfigurationManager.getMessageTracerConfiguration();
            this.configurationContext.getAxisConfiguration().engageModule("wso2analyticsmessagetracerservice");
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new MessageTracerAxis2ConfigurationContextObserver(), null);
            new RegistryPersistenceManager().load(CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String messageTracingEnabled = msgTracerConfiguration.getMessageTracingEnabled();
            if (StringUtils.isNotEmpty((String)messageTracingEnabled)) {
                EventingConfigData eventingConfigData = new RegistryPersistenceManager().getEventingConfigData();
                eventingConfigData.setMessageTracingEnable(Boolean.parseBoolean(messageTracingEnabled));
                new RegistryPersistenceManager().update(eventingConfigData);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to activate BAM message tracer handler bundle", (Throwable)e);
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, bind="setConfigurationContextService", unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContext = configurationContextService.getServerConfigContext();
        ServiceHolder.setConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContext = null;
        ServiceHolder.setConfigurationContextService(null);
    }

    @Reference(name="org.wso2.carbon.registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, bind="setRegistryService", unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(null);
    }

    @Reference(name="org.wso2.carbon.event.stream.core.EventStreamService", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, bind="setEventStreamService", unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setEventStreamService(null);
    }

    public static MessageTracerConfiguration getMessageTracerConfiguration() {
        return msgTracerConfiguration;
    }
}

