/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.internal;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.conf.EventingConfigData;
import org.wso2.carbon.analytics.message.tracer.handler.conf.RegistryPersistenceManager;
import org.wso2.carbon.analytics.message.tracer.handler.util.TenantEventConfigData;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class MessageTracerAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log LOG = LogFactory.getLog(MessageTracerAxis2ConfigurationContextObserver.class);

    public void createdConfigurationContext(ConfigurationContext configContext) {
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        this.setEventingConfigDataSpecificForTenant(tenantId);
        AxisModule messageTraceModule = axisConfiguration.getModule("wso2analyticsmessagetracerservice");
        if (messageTraceModule != null) {
            try {
                axisConfiguration.engageModule("wso2analyticsmessagetracerservice");
            }
            catch (AxisFault e) {
                LOG.error((Object)("Cannot engage BAM MessageTracer module for the tenant :" + tenantId), (Throwable)e);
            }
        }
    }

    private void setEventingConfigDataSpecificForTenant(int tenantId) {
        Map<Integer, EventingConfigData> eventingConfigDataMap = TenantEventConfigData.getTenantSpecificEventingConfigData();
        RegistryPersistenceManager persistenceManager = new RegistryPersistenceManager();
        EventingConfigData eventingConfigData = persistenceManager.getEventingConfigData();
        eventingConfigDataMap.put(tenantId, eventingConfigData);
    }

    public void terminatedConfigurationContext(ConfigurationContext configCtx) {
    }

    public void terminatingConfigurationContext(ConfigurationContext configCtx) {
    }
}

