/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.conf;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.message.tracer.handler.conf.EventingConfigData;
import org.wso2.carbon.analytics.message.tracer.handler.publish.ClusterNotifier;
import org.wso2.carbon.analytics.message.tracer.handler.util.ServiceHolder;
import org.wso2.carbon.analytics.message.tracer.handler.util.TenantEventConfigData;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryPersistenceManager {
    private static final Log LOG = LogFactory.getLog(RegistryPersistenceManager.class);

    public EventingConfigData load(int tenantId) {
        EventingConfigData eventingConfigData;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Loading config info from registry.");
            }
            eventingConfigData = new EventingConfigData();
            eventingConfigData.setMessageTracingEnable(false);
            eventingConfigData.setDumpBodyEnable(false);
            eventingConfigData.setLoggingEnable(false);
            eventingConfigData.setPublishToBAMEnable(false);
            try {
                String enableTrace = this.getConfigurationProperty(tenantId, "EnableMessageTrace");
                String enablePublishToBAM = this.getConfigurationProperty(tenantId, "EnablePublishToBAM");
                String dumpBody = this.getConfigurationProperty(tenantId, "EnableDumpMessageBody");
                String enableLogging = this.getConfigurationProperty(tenantId, "EnableLogging");
                if (enableTrace != null) {
                    eventingConfigData.setMessageTracingEnable(Boolean.valueOf(enableTrace));
                    if (dumpBody != null) {
                        eventingConfigData.setDumpBodyEnable(Boolean.valueOf(dumpBody));
                    }
                    if (enableLogging != null) {
                        eventingConfigData.setLoggingEnable(Boolean.valueOf(enableLogging));
                    }
                    if (enablePublishToBAM != null) {
                        eventingConfigData.setPublishToBAMEnable(Boolean.valueOf(enablePublishToBAM));
                    }
                    Map<Integer, EventingConfigData> tenantEventConfigData = TenantEventConfigData.getTenantSpecificEventingConfigData();
                    tenantEventConfigData.put(tenantId, eventingConfigData);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Registry values are empty. Setting default values.");
                    }
                    this.update(eventingConfigData);
                }
            }
            catch (Exception ignored) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)ignored);
            }
        }
        return eventingConfigData;
    }

    private void updateConfigurationProperty(int tenantId, String propertyName, Object value) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.analytics.message.tracer.handler/tracing/" + propertyName;
        UserRegistry registry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
        if (!registry.resourceExists(resourcePath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resource " + propertyName + "available."));
            }
            Resource resource = registry.newResource();
            resource.addProperty(propertyName, String.valueOf(value));
            registry.put(resourcePath, resource);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resource " + propertyName + "creating."));
            }
            Resource resource = registry.get(resourcePath);
            resource.setProperty(propertyName, String.valueOf(value));
            registry.put(resourcePath, resource);
        }
    }

    public void update(EventingConfigData eventingConfigData) throws RegistryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Updating config ino.");
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<Integer, EventingConfigData> tenantEventConfigData = TenantEventConfigData.getTenantSpecificEventingConfigData();
        tenantEventConfigData.put(tenantId, eventingConfigData);
        this.updateConfigurationProperty(tenantId, "EnableMessageTrace", eventingConfigData.isMessageTracingEnable());
        this.updateConfigurationProperty(tenantId, "EnableDumpMessageBody", eventingConfigData.isDumpBodyEnable());
        this.updateConfigurationProperty(tenantId, "EnableLogging", eventingConfigData.isLoggingEnable());
        this.updateConfigurationProperty(tenantId, "EnablePublishToBAM", eventingConfigData.isPublishToBAMEnable());
        ClusterNotifier notifier = new ClusterNotifier();
        notifier.setTenantId(tenantId);
        notifier.notifyClusterMessageTraceChange();
    }

    private String getConfigurationProperty(int tenantId, String propertyName) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.analytics.message.tracer.handler/tracing/" + propertyName;
        UserRegistry registry = ServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
        String value = null;
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            value = resource.getProperty(propertyName);
        }
        return value;
    }

    public EventingConfigData getEventingConfigData() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        return this.load(tenantId);
    }
}

