/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.message.tracer.handler.conf;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.analytics.message.tracer.handler.conf.MessageTracerConfiguration;
import org.wso2.carbon.analytics.message.tracer.handler.exception.MessageTracerHandlerException;
import org.wso2.carbon.analytics.message.tracer.handler.util.HandlerUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class MessageTracerConfigurationManager {
    private static final String MSG_TRACER_FILE = "message-tracer-config.xml";
    private static MessageTracerConfiguration configuration;
    private static final String CONFIG_FILE_PATH;

    private MessageTracerConfigurationManager() {
    }

    public static MessageTracerConfiguration getMessageTracerConfiguration() throws Exception {
        try {
            File msgTracerConfigFile = new File(CONFIG_FILE_PATH);
            if (!msgTracerConfigFile.exists()) {
                throw new FileNotFoundException("Message tracer configuration file message-tracer-config.xml not found.");
            }
            Document doc = HandlerUtils.convertToDocument(msgTracerConfigFile);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{MessageTracerConfiguration.class});
            configuration = (MessageTracerConfiguration)ctx.createUnmarshaller().unmarshal((Node)doc);
        }
        catch (Exception e) {
            throw new MessageTracerHandlerException("Error in initializing message tracer configuration: " + e.getMessage(), e);
        }
        return configuration;
    }

    static {
        CONFIG_FILE_PATH = CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator + MSG_TRACER_FILE;
    }
}

