/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public final class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean includeAttributes = false;

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return new Processor(this.segment, this.getIncludeAttributes()).toString();
    }

    public TextExtractor setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    private static final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean includeAttributes;

        public Processor(Segment segment, boolean includeAttributes) {
            this.segment = segment;
            this.source = segment.source;
            this.includeAttributes = includeAttributes;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.segment.length());
            int textBegin = this.segment.begin;
            Iterator i = this.segment.findAllTags().iterator();
            while (i.hasNext()) {
                Tag tag = (Tag)i.next();
                int textEnd = tag.begin;
                if (textEnd < textBegin) continue;
                while (textBegin < textEnd) {
                    sb.append(this.source.charAt(textBegin++));
                }
                if (tag.getTagType() == StartTagType.NORMAL) {
                    EndTag endTag;
                    if ((tag.name == "script" || tag.name == "style") && (endTag = this.source.findNextEndTag(tag.end, tag.name, EndTagType.NORMAL)) != null) {
                        textBegin = endTag.end;
                        while (i.hasNext() && i.next() != endTag) {
                        }
                        continue;
                    }
                    if (this.includeAttributes) {
                        Attribute summaryAttribute;
                        Attribute labelAttribute;
                        Attribute altAttribute;
                        StartTag startTag = (StartTag)tag;
                        Attribute titleAttribute = startTag.getAttributes().get("title");
                        if (titleAttribute != null) {
                            sb.append(' ').append((Object)titleAttribute.getValueSegment()).append(' ');
                        }
                        if ((altAttribute = startTag.getAttributes().get("alt")) != null) {
                            sb.append(' ').append((Object)altAttribute.getValueSegment()).append(' ');
                        }
                        if ((labelAttribute = startTag.getAttributes().get("label")) != null) {
                            sb.append(' ').append((Object)labelAttribute.getValueSegment()).append(' ');
                        }
                        if ((summaryAttribute = startTag.getAttributes().get("summary")) != null) {
                            sb.append(' ').append((Object)summaryAttribute.getValueSegment()).append(' ');
                        }
                    }
                }
                if (tag.getName() == "br" || !HTMLElements.getInlineLevelElementNames().contains(tag.getName())) {
                    sb.append(' ');
                }
                textBegin = tag.end;
            }
            while (textBegin < this.segment.end) {
                sb.append(this.source.charAt(textBegin++));
            }
            String decodedText = CharacterReference.decodeCollapseWhiteSpace(sb);
            return decodedText;
        }
    }
}

