/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.OutputDocument;

public final class ParseText
implements CharSequence {
    private final char[] text;
    public static final int NO_BREAK = -1;

    ParseText(CharSequence charSequence) {
        this.text = new char[charSequence.length()];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = Character.toLowerCase(charSequence.charAt(i));
        }
    }

    ParseText(OutputDocument outputDocument) {
        this(outputDocument.toString());
    }

    public boolean containsAt(String str, int pos) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == this.text[pos + i]) continue;
            return false;
        }
        return true;
    }

    public char charAt(int index) {
        return this.text[index];
    }

    public int indexOf(char searchChar, int fromIndex) {
        return this.indexOf(searchChar, fromIndex, -1);
    }

    public int indexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > this.text.length ? this.text.length : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            if (this.text[i] == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(char searchChar, int fromIndex) {
        return this.lastIndexOf(searchChar, fromIndex, -1);
    }

    public int lastIndexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int n = i = fromIndex > this.text.length ? this.text.length : fromIndex;
        while (i > breakAtIndex) {
            if (this.text[i] == searchChar) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(String searchString, int fromIndex) {
        return searchString.length() == 1 ? this.indexOf(searchString.charAt(0), fromIndex, -1) : this.indexOf(searchString.toCharArray(), fromIndex, -1);
    }

    public int indexOf(char[] searchCharArray, int fromIndex) {
        return this.indexOf(searchCharArray, fromIndex, -1);
    }

    public int indexOf(String searchString, int fromIndex, int breakAtIndex) {
        return searchString.length() == 1 ? this.indexOf(searchString.charAt(0), fromIndex, breakAtIndex) : this.indexOf(searchString.toCharArray(), fromIndex, breakAtIndex);
    }

    public int indexOf(char[] searchCharArray, int fromIndex, int breakAtIndex) {
        int i;
        if (searchCharArray.length == 0) {
            return fromIndex;
        }
        char firstChar = searchCharArray[0];
        int lastPossibleBreakAtIndex = this.text.length - searchCharArray.length + 1;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > lastPossibleBreakAtIndex ? lastPossibleBreakAtIndex : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            block5: {
                if (this.text[i] == firstChar) {
                    for (int j = 1; j < searchCharArray.length; ++j) {
                        if (searchCharArray[j] == this.text[j + i]) {
                            continue;
                        }
                        break block5;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(String searchString, int fromIndex) {
        return searchString.length() == 1 ? this.lastIndexOf(searchString.charAt(0), fromIndex, -1) : this.lastIndexOf(searchString.toCharArray(), fromIndex, -1);
    }

    public int lastIndexOf(char[] searchCharArray, int fromIndex) {
        return this.lastIndexOf(searchCharArray, fromIndex, -1);
    }

    public int lastIndexOf(String searchString, int fromIndex, int breakAtIndex) {
        return searchString.length() == 1 ? this.lastIndexOf(searchString.charAt(0), fromIndex, breakAtIndex) : this.lastIndexOf(searchString.toCharArray(), fromIndex, breakAtIndex);
    }

    public int lastIndexOf(char[] searchCharArray, int fromIndex, int breakAtIndex) {
        if (searchCharArray.length == 0) {
            return fromIndex;
        }
        int rightIndex = this.text.length - searchCharArray.length;
        if (breakAtIndex > rightIndex) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int lastCharIndex = searchCharArray.length - 1;
        char lastChar = searchCharArray[lastCharIndex];
        int actualBreakAtPos = breakAtIndex + lastCharIndex;
        block0: for (int i = fromIndex + lastCharIndex; i > actualBreakAtPos; --i) {
            if (this.text[i] != lastChar) continue;
            int startIndex = i - lastCharIndex;
            for (int j = lastCharIndex - 1; j >= 0; --j) {
                if (searchCharArray[j] != this.text[j + startIndex]) continue block0;
            }
            return startIndex;
        }
        return -1;
    }

    public int length() {
        return this.text.length;
    }

    public String substring(int beginIndex, int endIndex) {
        return new String(this.text, beginIndex, endIndex - beginIndex);
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String toString() {
        return new String(this.text);
    }
}

