/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Logger;
import au.id.jericho.lib.html.LoggerProvider;
import org.slf4j.LoggerFactory;

final class LoggerProviderSLF4J
implements LoggerProvider {
    public static final LoggerProvider INSTANCE = new LoggerProviderSLF4J();

    private LoggerProviderSLF4J() {
    }

    public Logger getLogger(String name) {
        return new SLF4JLogger(LoggerFactory.getLogger((String)name));
    }

    private static class SLF4JLogger
    implements Logger {
        private final org.slf4j.Logger slf4jLogger;

        public SLF4JLogger(org.slf4j.Logger slf4jLogger) {
            this.slf4jLogger = slf4jLogger;
        }

        public void error(String message) {
            this.slf4jLogger.error(message);
        }

        public void warn(String message) {
            this.slf4jLogger.warn(message);
        }

        public void info(String message) {
            this.slf4jLogger.info(message);
        }

        public void debug(String message) {
            this.slf4jLogger.debug(message);
        }

        public boolean isErrorEnabled() {
            return this.slf4jLogger.isErrorEnabled();
        }

        public boolean isWarnEnabled() {
            return this.slf4jLogger.isWarnEnabled();
        }

        public boolean isInfoEnabled() {
            return this.slf4jLogger.isInfoEnabled();
        }

        public boolean isDebugEnabled() {
            return this.slf4jLogger.isDebugEnabled();
        }
    }
}

