/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControlOutputStyle;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class FormControl
extends Segment {
    FormControlType formControlType;
    String name;
    ElementContainer elementContainer;
    FormControlOutputStyle outputStyle = FormControlOutputStyle.NORMAL;
    private static final String CHECKBOX_NULL_DEFAULT_VALUE = "on";
    private static Comparator COMPARATOR = new PositionComparator();

    static FormControl construct(Element element) {
        String tagName = element.getStartTag().getName();
        if (tagName == "input") {
            String typeAttributeValue = element.getAttributes().getRawValue("type");
            if (typeAttributeValue == null) {
                return new InputFormControl(element, FormControlType.TEXT);
            }
            FormControlType formControlType = FormControlType.getFromInputElementType(typeAttributeValue.toLowerCase());
            if (formControlType == null) {
                if (element.source.logger.isInfoEnabled()) {
                    element.source.logger.info(element.source.getRowColumnVector(element.begin).appendTo(new StringBuffer(200)).append(": INPUT control with unrecognised type \"").append(typeAttributeValue).append("\" assumed to be type \"text\"").toString());
                }
                formControlType = FormControlType.TEXT;
            }
            if (formControlType == FormControlType.TEXT) {
                return new InputFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.CHECKBOX || formControlType == FormControlType.RADIO) {
                return new RadioCheckboxFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.SUBMIT) {
                return new SubmitFormControl(element, formControlType);
            }
            if (formControlType == FormControlType.IMAGE) {
                return new ImageSubmitFormControl(element);
            }
            return new InputFormControl(element, formControlType);
        }
        if (tagName == "select") {
            return new SelectFormControl(element);
        }
        if (tagName == "textarea") {
            return new TextAreaFormControl(element);
        }
        if (tagName == "button") {
            return "submit".equalsIgnoreCase(element.getAttributes().getRawValue("type")) ? new SubmitFormControl(element, FormControlType.BUTTON) : null;
        }
        return null;
    }

    private FormControl(Element element, FormControlType formControlType, boolean loadPredefinedValue) {
        super(element.source, element.begin, element.end);
        this.elementContainer = new ElementContainer(element, loadPredefinedValue);
        this.formControlType = formControlType;
        this.name = element.getAttributes().getValue("name");
        this.verifyName();
    }

    public final FormControlType getFormControlType() {
        return this.formControlType;
    }

    public final String getName() {
        return this.name;
    }

    public final Element getElement() {
        return this.elementContainer.element;
    }

    public Iterator getOptionElementIterator() {
        throw new UnsupportedOperationException("Only SELECT controls contain OPTION elements");
    }

    public FormControlOutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(FormControlOutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    public final Map getAttributesMap() {
        return this.elementContainer.getAttributesMap();
    }

    public final boolean isDisabled() {
        return this.elementContainer.getBooleanAttribute("disabled");
    }

    public final void setDisabled(boolean disabled) {
        this.elementContainer.setBooleanAttribute("disabled", disabled);
    }

    public boolean isChecked() {
        throw new UnsupportedOperationException("This property is only relevant for CHECKBOX and RADIO controls");
    }

    public String getPredefinedValue() {
        return this.elementContainer.predefinedValue;
    }

    public Collection getPredefinedValues() {
        return this.getPredefinedValue() != null ? Collections.singleton(this.getPredefinedValue()) : Collections.EMPTY_SET;
    }

    public Collection getValues() {
        HashSet values = new HashSet();
        this.addValuesTo(values);
        return values;
    }

    public final void clearValues() {
        this.setValue(null);
    }

    public abstract boolean setValue(CharSequence var1);

    public boolean addValue(CharSequence value) {
        return this.setValue(value);
    }

    abstract void addValuesTo(Collection var1);

    abstract void addToFormFields(FormFields var1);

    abstract void replaceInOutputDocument(OutputDocument var1);

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.formControlType).append(" name=\"").append(this.name).append('\"');
        if (this.elementContainer.predefinedValue != null) {
            sb.append(" PredefinedValue=\"").append(this.elementContainer.predefinedValue).append('\"');
        }
        sb.append(" - ").append(this.getElement().getDebugInfo());
        return sb.toString();
    }

    final String getDisplayValueHTML(CharSequence text, boolean whiteSpaceFormatting) {
        StringBuffer sb = new StringBuffer((text == null ? 0 : text.length() * 2) + 50);
        sb.append('<').append(FormControlOutputStyle.ConfigDisplayValue.ElementName);
        Iterator i = FormControlOutputStyle.ConfigDisplayValue.AttributeNames.iterator();
        while (i.hasNext()) {
            String attributeName = i.next().toString();
            CharSequence attributeValue = this.elementContainer.getAttributeValue(attributeName);
            if (attributeValue == null) continue;
            Attribute.appendHTML(sb, (CharSequence)attributeName, attributeValue);
        }
        sb.append('>');
        if (text == null || text.length() == 0) {
            sb.append(FormControlOutputStyle.ConfigDisplayValue.EmptyHTML);
        } else {
            CharacterReference.appendEncode(sb, text, whiteSpaceFormatting);
        }
        sb.append("</").append(FormControlOutputStyle.ConfigDisplayValue.ElementName).append('>');
        return sb.toString();
    }

    final void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
        this.elementContainer.replaceAttributesInOutputDocumentIfModified(outputDocument);
    }

    static List findAll(Segment segment) {
        ArrayList list = new ArrayList();
        FormControl.findAll(segment, list, "input");
        FormControl.findAll(segment, list, "textarea");
        FormControl.findAll(segment, list, "select");
        FormControl.findAll(segment, list, "button");
        Collections.sort(list, COMPARATOR);
        return list;
    }

    private static void findAll(Segment segment, ArrayList list, String tagName) {
        Iterator i = segment.findAllElements(tagName).iterator();
        while (i.hasNext()) {
            FormControl formControl = ((Element)i.next()).getFormControl();
            if (formControl == null) continue;
            list.add(formControl);
        }
    }

    private static CharSequence getString(char ch, int length) {
        if (length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    private void verifyName() {
        String missingOrBlank;
        if (this.formControlType.isSubmit()) {
            return;
        }
        if (this.name == null) {
            missingOrBlank = "missing";
        } else {
            if (this.name.length() != 0) {
                return;
            }
            missingOrBlank = "blank";
        }
        Source source = this.getElement().source;
        if (source.logger.isInfoEnabled()) {
            source.logger.info(this.getElement().source.getRowColumnVector(this.getElement().begin).appendTo(new StringBuffer(200)).append(": compulsory \"name\" attribute of ").append(this.formControlType).append(" control is ").append(missingOrBlank).toString());
        }
    }

    private static final void addValueTo(Collection collection, CharSequence value) {
        collection.add(value != null ? value : "");
    }

    static final class ElementContainer {
        public final Element element;
        public Map attributesMap = null;
        public String predefinedValue;

        public ElementContainer(Element element, boolean loadPredefinedValue) {
            this.element = element;
            this.predefinedValue = loadPredefinedValue ? element.getAttributes().getValue("value") : null;
        }

        public Map getAttributesMap() {
            if (this.attributesMap == null) {
                this.attributesMap = this.element.getAttributes().getMap(true);
            }
            return this.attributesMap;
        }

        public boolean setSelected(CharSequence value, String selectedOrChecked, boolean allowMultipleValues) {
            if (value != null && this.predefinedValue.equals(((Object)value).toString())) {
                this.setBooleanAttribute(selectedOrChecked, true);
                return true;
            }
            if (!allowMultipleValues) {
                this.setBooleanAttribute(selectedOrChecked, false);
            }
            return false;
        }

        public CharSequence getAttributeValue(String attributeName) {
            if (this.attributesMap != null) {
                return (CharSequence)this.attributesMap.get(attributeName);
            }
            return this.element.getAttributes().getValue(attributeName);
        }

        public void setAttributeValue(String attributeName, CharSequence value) {
            if (value == null) {
                this.setBooleanAttribute(attributeName, false);
                return;
            }
            if (this.attributesMap != null) {
                this.attributesMap.put(attributeName, value);
                return;
            }
            String valueString = ((Object)value).toString();
            CharSequence existingValue = this.getAttributeValue(attributeName);
            if (existingValue != null && ((Object)existingValue).toString().equals(valueString)) {
                return;
            }
            this.getAttributesMap().put(attributeName, valueString);
        }

        public boolean getBooleanAttribute(String attributeName) {
            if (this.attributesMap != null) {
                return this.attributesMap.containsKey(attributeName);
            }
            return this.element.getAttributes().get(attributeName) != null;
        }

        public void setBooleanAttribute(String attributeName, boolean value) {
            boolean oldValue = this.getBooleanAttribute(attributeName);
            if (value == oldValue) {
                return;
            }
            if (value) {
                this.getAttributesMap().put(attributeName, attributeName);
            } else {
                this.getAttributesMap().remove(attributeName);
            }
        }

        public void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
            if (this.attributesMap != null) {
                outputDocument.replace(this.element.getAttributes(), this.attributesMap);
            }
        }
    }

    private static final class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int formControl2Begin;
            int formControl1Begin = ((FormControl)o1).getElement().getBegin();
            if (formControl1Begin < (formControl2Begin = ((FormControl)o2).getElement().getBegin())) {
                return -1;
            }
            if (formControl1Begin > formControl2Begin) {
                return 1;
            }
            return 0;
        }
    }

    static final class SelectFormControl
    extends FormControl {
        public ElementContainer[] optionElementContainers;

        public SelectFormControl(Element element) {
            super(element, element.getAttributes().get("multiple") != null ? FormControlType.SELECT_MULTIPLE : FormControlType.SELECT_SINGLE, false);
            List optionElements = element.findAllElements("option");
            this.optionElementContainers = new ElementContainer[optionElements.size()];
            int x = 0;
            Iterator i = optionElements.iterator();
            while (i.hasNext()) {
                ElementContainer optionElementContainer = new ElementContainer((Element)i.next(), true);
                if (optionElementContainer.predefinedValue == null) {
                    optionElementContainer.predefinedValue = CharacterReference.decodeCollapseWhiteSpace(optionElementContainer.element.getContent());
                }
                this.optionElementContainers[x++] = optionElementContainer;
            }
        }

        public String getPredefinedValue() {
            throw new UnsupportedOperationException("Use getPredefinedValues() method instead on SELECT controls");
        }

        public Collection getPredefinedValues() {
            ArrayList<String> arrayList = new ArrayList<String>(this.optionElementContainers.length);
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                arrayList.add(this.optionElementContainers[i].predefinedValue);
            }
            return arrayList;
        }

        public Iterator getOptionElementIterator() {
            return new OptionElementIterator();
        }

        public boolean setValue(CharSequence value) {
            return this.addValue(value, false);
        }

        public boolean addValue(CharSequence value) {
            return this.addValue(value, this.formControlType == FormControlType.SELECT_MULTIPLE);
        }

        private boolean addValue(CharSequence value, boolean allowMultipleValues) {
            boolean valueFound = false;
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].setSelected(value, "selected", allowMultipleValues)) continue;
                valueFound = true;
            }
            return valueFound;
        }

        void addValuesTo(Collection collection) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                FormControl.addValueTo(collection, this.optionElementContainers[i].predefinedValue);
            }
        }

        void addToFormFields(FormFields formFields) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                formFields.add(this, this.optionElementContainers[i].predefinedValue);
            }
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                StringBuffer sb = new StringBuffer(100);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                    Segment.appendCollapseWhiteSpace(sb, this.optionElementContainers[i].element.getContent());
                    sb.append(FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator);
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator.length());
                }
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(sb, false));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    this.optionElementContainers[i].replaceAttributesInOutputDocumentIfModified(outputDocument);
                }
            }
        }

        private final class OptionElementIterator
        implements Iterator {
            private int i = 0;

            private OptionElementIterator() {
            }

            public boolean hasNext() {
                return this.i < SelectFormControl.this.optionElementContainers.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectFormControl.this.optionElementContainers[this.i++].element;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class ImageSubmitFormControl
    extends SubmitFormControl {
        public ImageSubmitFormControl(Element element) {
            super(element, FormControlType.IMAGE);
        }

        void addToFormFields(FormFields formFields) {
            super.addToFormFields(formFields);
            formFields.addName(this, this.name + ".x");
            formFields.addName(this, this.name + ".y");
        }
    }

    static class SubmitFormControl
    extends FormControl {
        public SubmitFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
        }

        public boolean setValue(CharSequence value) {
            return false;
        }

        void addValuesTo(Collection collection) {
        }

        void addToFormFields(FormFields formFields) {
            if (this.getPredefinedValue() != null) {
                formFields.add(this);
            }
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class RadioCheckboxFormControl
    extends FormControl {
        public RadioCheckboxFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
            if (this.elementContainer.predefinedValue == null) {
                this.elementContainer.predefinedValue = FormControl.CHECKBOX_NULL_DEFAULT_VALUE;
                if (element.source.logger.isInfoEnabled()) {
                    element.source.logger.info(element.source.getRowColumnVector(element.begin).appendTo(new StringBuffer(200)).append(": compulsory \"value\" attribute of ").append(formControlType).append(" control \"").append(this.name).append("\" is missing, assuming the value \"").append(FormControl.CHECKBOX_NULL_DEFAULT_VALUE).append('\"').toString());
                }
            }
        }

        public boolean setValue(CharSequence value) {
            return this.elementContainer.setSelected(value, "checked", false);
        }

        public boolean addValue(CharSequence value) {
            return this.elementContainer.setSelected(value, "checked", this.formControlType == FormControlType.CHECKBOX);
        }

        void addValuesTo(Collection collection) {
            if (this.isChecked()) {
                FormControl.addValueTo(collection, this.getPredefinedValue());
            }
        }

        public boolean isChecked() {
            return this.elementContainer.getBooleanAttribute("checked");
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    String html;
                    String string = html = this.isChecked() ? FormControlOutputStyle.ConfigDisplayValue.CheckedHTML : FormControlOutputStyle.ConfigDisplayValue.UncheckedHTML;
                    if (html != null) {
                        outputDocument.replace(this.getElement(), html);
                        return;
                    }
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class TextAreaFormControl
    extends FormControl {
        public CharSequence value = UNCHANGED;
        private static final String UNCHANGED = new String();

        public TextAreaFormControl(Element element) {
            super(element, FormControlType.TEXTAREA, false);
        }

        public boolean setValue(CharSequence value) {
            this.value = value;
            return true;
        }

        void addValuesTo(Collection collection) {
            FormControl.addValueTo(collection, this.getValue());
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(this.getValue(), true));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                if (this.value != UNCHANGED) {
                    outputDocument.replace(this.getElement().getContent(), CharacterReference.encode(this.value));
                }
            }
        }

        private CharSequence getValue() {
            return this.value == UNCHANGED ? CharacterReference.decode(this.getElement().getContent()) : this.value;
        }
    }

    static final class InputFormControl
    extends FormControl {
        public InputFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, false);
        }

        public boolean setValue(CharSequence value) {
            this.elementContainer.setAttributeValue("value", value);
            return true;
        }

        void addValuesTo(Collection collection) {
            FormControl.addValueTo(collection, this.elementContainer.getAttributeValue("value"));
        }

        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                String output = null;
                if (this.formControlType != FormControlType.HIDDEN) {
                    CharSequence value = this.elementContainer.getAttributeValue("value");
                    if (this.formControlType == FormControlType.PASSWORD && value != null) {
                        value = FormControl.getString(FormControlOutputStyle.ConfigDisplayValue.PasswordChar, value.length());
                    }
                    output = this.getDisplayValueHTML(value, false);
                }
                outputDocument.replace(this.getElement(), output);
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }
}

