/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.workflow;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.SubscriptionWorkflowDTO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure1;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure3;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure5;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure7;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure9;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;

public class SubscriptionUpdateApprovalWorkflowExecutor
extends WorkflowExecutor {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        SubscriptionUpdateApprovalWorkflowExecutor.ajc$preClinit();
        log = LogFactory.getLog(SubscriptionUpdateApprovalWorkflowExecutor.class);
    }

    @Override
    public String getWorkflowType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionUpdateApprovalWorkflowExecutor.getWorkflowType_aroundBody0(this, joinPoint);
    }

    @Override
    public List<WorkflowDTO> getWorkflowDetails(String workflowStatus) throws WorkflowException {
        String string = workflowStatus;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionUpdateApprovalWorkflowExecutor.getWorkflowDetails_aroundBody2(this, string, joinPoint);
    }

    @Override
    public WorkflowResponse execute(WorkflowDTO workflowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO2 = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workflowDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO2, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionUpdateApprovalWorkflowExecutor.execute_aroundBody4(this, workflowDTO2, joinPoint);
    }

    @Override
    public WorkflowResponse complete(WorkflowDTO workflowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO2 = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)workflowDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO2, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionUpdateApprovalWorkflowExecutor.complete_aroundBody6(this, workflowDTO2, joinPoint);
    }

    @Override
    public void cleanUpPendingTask(String workflowExtRef) throws WorkflowException {
        String string = workflowExtRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscriptionUpdateApprovalWorkflowExecutor$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscriptionUpdateApprovalWorkflowExecutor.cleanUpPendingTask_aroundBody8(this, string, joinPoint);
    }

    static final /* synthetic */ String getWorkflowType_aroundBody0(SubscriptionUpdateApprovalWorkflowExecutor ajc$this, JoinPoint joinPoint) {
        return "AM_SUBSCRIPTION_UPDATE";
    }

    static final /* synthetic */ List getWorkflowDetails_aroundBody2(SubscriptionUpdateApprovalWorkflowExecutor ajc$this, String workflowStatus, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ WorkflowResponse execute_aroundBody4(SubscriptionUpdateApprovalWorkflowExecutor ajc$this, WorkflowDTO workflowDTO, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing Subscription Update Webservice Workflow.. ");
        }
        SubscriptionWorkflowDTO subsWorkflowDTO = (SubscriptionWorkflowDTO)workflowDTO;
        String message = "Approve API " + subsWorkflowDTO.getApiName() + " - " + subsWorkflowDTO.getApiVersion() + " subscription creation request from subscriber - " + subsWorkflowDTO.getSubscriber() + " for the application - " + subsWorkflowDTO.getApplicationName();
        workflowDTO.setWorkflowDescription(message);
        workflowDTO.setProperties("apiName", subsWorkflowDTO.getApiName());
        workflowDTO.setProperties("apiVersion", subsWorkflowDTO.getApiVersion());
        workflowDTO.setProperties("subscriber", subsWorkflowDTO.getSubscriber());
        workflowDTO.setProperties("applicationName", subsWorkflowDTO.getApplicationName());
        workflowDTO.setProperties("currentTier", subsWorkflowDTO.getTierName());
        workflowDTO.setProperties("requestedTier", subsWorkflowDTO.getRequestedTierName());
        super.execute(workflowDTO);
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ WorkflowResponse complete_aroundBody6(SubscriptionUpdateApprovalWorkflowExecutor ajc$this, WorkflowDTO workflowDTO, JoinPoint joinPoint) {
        workflowDTO.setUpdatedTime(System.currentTimeMillis());
        super.complete(workflowDTO);
        if (log.isDebugEnabled()) {
            String logMessage = "Subscription Update [Complete] Workflow Invoked. Workflow ID : " + workflowDTO.getExternalWorkflowReference() + " Workflow State : " + (Object)((Object)workflowDTO.getStatus());
            log.debug((Object)logMessage);
        }
        SubscriptionWorkflowDTO subscriptionWorkflowDTO = (SubscriptionWorkflowDTO)workflowDTO;
        if (WorkflowStatus.APPROVED.equals((Object)workflowDTO.getStatus())) {
            ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
            try {
                apiMgtDAO.updateSubscriptionStatusAndTier(Integer.parseInt(subscriptionWorkflowDTO.getWorkflowReference()), "UNBLOCKED");
            }
            catch (APIManagementException e) {
                log.error((Object)"Could not complete subscription update workflow", (Throwable)e);
                throw new WorkflowException("Could not complete subscription update workflow", e);
            }
        }
        if (WorkflowStatus.REJECTED.equals((Object)workflowDTO.getStatus())) {
            ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
            try {
                apiMgtDAO.updateSubscriptionStatus(Integer.parseInt(subscriptionWorkflowDTO.getWorkflowReference()), "UNBLOCKED");
            }
            catch (APIManagementException e) {
                log.error((Object)"Could not complete subscription update workflow", (Throwable)e);
                throw new WorkflowException("Could not complete subscription update workflow", e);
            }
        }
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ void cleanUpPendingTask_aroundBody8(SubscriptionUpdateApprovalWorkflowExecutor ajc$this, String workflowExtRef, JoinPoint joinPoint) {
        String errorMsg = null;
        super.cleanUpPendingTask(workflowExtRef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting cleanup task for SubscriptionUpdateApprovalWorkflowExecutor for :" + workflowExtRef));
        }
        try {
            ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
            apiMgtDAO.deleteWorkflowRequest(workflowExtRef);
        }
        catch (APIManagementException axisFault) {
            errorMsg = "Error sending out cancel pending subscription update approval process message. cause: " + axisFault.getMessage();
            throw new WorkflowException(errorMsg, axisFault);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SubscriptionUpdateApprovalWorkflowExecutor.java", SubscriptionUpdateApprovalWorkflowExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowType", "org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor", "", "", "", "java.lang.String"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowDetails", "org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor", "java.lang.String", "workflowStatus", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "java.util.List"), 44);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 54);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "complete", "org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 81);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cleanUpPendingTask", "org.wso2.carbon.apimgt.impl.workflow.SubscriptionUpdateApprovalWorkflowExecutor", "java.lang.String", "workflowExtRef", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "void"), 119);
    }
}

