/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.workflow;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.ApplicationRegistrationWorkflowDTO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure1;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure3;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure5;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure7;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;

public class ApplicationRegistrationApprovalWorkflowExecutor
extends AbstractApplicationRegistrationWorkflowExecutor {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ApplicationRegistrationApprovalWorkflowExecutor.ajc$preClinit();
        log = LogFactory.getLog(ApplicationRegistrationApprovalWorkflowExecutor.class);
    }

    @Override
    public WorkflowResponse execute(WorkflowDTO workflowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO2 = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)workflowDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO2, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationRegistrationApprovalWorkflowExecutor.execute_aroundBody0(this, workflowDTO2, joinPoint);
    }

    @Override
    public WorkflowResponse complete(WorkflowDTO workFlowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO = workFlowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)workflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationRegistrationApprovalWorkflowExecutor.complete_aroundBody2(this, workflowDTO, joinPoint);
    }

    @Override
    public List<WorkflowDTO> getWorkflowDetails(String workflowStatus) throws WorkflowException {
        String string = workflowStatus;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationRegistrationApprovalWorkflowExecutor.getWorkflowDetails_aroundBody4(this, string, joinPoint);
    }

    @Override
    public void cleanUpPendingTask(String workflowExtRef) throws WorkflowException {
        String string = workflowExtRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new ApplicationRegistrationApprovalWorkflowExecutor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        ApplicationRegistrationApprovalWorkflowExecutor.cleanUpPendingTask_aroundBody6(this, string, joinPoint);
    }

    static final /* synthetic */ WorkflowResponse execute_aroundBody0(ApplicationRegistrationApprovalWorkflowExecutor ajc$this, WorkflowDTO workflowDTO, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing Application registration Workflow..");
        }
        ApplicationRegistrationWorkflowDTO appRegDTO = (ApplicationRegistrationWorkflowDTO)workflowDTO;
        Application application = appRegDTO.getApplication();
        String message = "Approve request to create " + appRegDTO.getKeyType() + " keys for " + application.getName() + " from application creator - " + appRegDTO.getUserName() + " with throttling tier - " + application.getTier();
        workflowDTO.setWorkflowDescription(message);
        workflowDTO.setProperties("keyType", appRegDTO.getKeyType());
        workflowDTO.setProperties("applicationName", application.getName());
        workflowDTO.setProperties("userName", appRegDTO.getUserName());
        workflowDTO.setProperties("applicationTier", application.getTier());
        super.execute(workflowDTO);
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ WorkflowResponse complete_aroundBody2(ApplicationRegistrationApprovalWorkflowExecutor ajc$this, WorkflowDTO workFlowDTO, JoinPoint joinPoint) {
        workFlowDTO.setUpdatedTime(System.currentTimeMillis());
        super.complete(workFlowDTO);
        if (log.isDebugEnabled()) {
            String logMessage = "Application Registration [Complete] Workflow Invoked. Workflow ID : " + workFlowDTO.getExternalWorkflowReference() + " Workflow State : " + (Object)((Object)workFlowDTO.getStatus());
            log.debug((Object)logMessage);
        }
        if (WorkflowStatus.APPROVED.equals((Object)workFlowDTO.getStatus())) {
            try {
                ajc$this.generateKeysForApplication((ApplicationRegistrationWorkflowDTO)workFlowDTO);
            }
            catch (APIManagementException e) {
                String msg = "Error occurred when updating the status of the Application Registration process";
                log.error((Object)msg, (Throwable)e);
                throw new WorkflowException(msg, e);
            }
        }
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ List getWorkflowDetails_aroundBody4(ApplicationRegistrationApprovalWorkflowExecutor ajc$this, String workflowStatus, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ void cleanUpPendingTask_aroundBody6(ApplicationRegistrationApprovalWorkflowExecutor ajc$this, String workflowExtRef, JoinPoint joinPoint) {
        super.cleanUpPendingTask(workflowExtRef);
        String errorMsg = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting cleanup task for ApplicationRegistrationApprovalWorkflowExecutor for :" + workflowExtRef));
        }
        try {
            ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
            apiMgtDAO.deleteWorkflowRequest(workflowExtRef);
        }
        catch (APIManagementException axisFault) {
            errorMsg = "Error sending out cancel pending registration approval process message. Cause: " + axisFault.getMessage();
            throw new WorkflowException(errorMsg, axisFault);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationRegistrationApprovalWorkflowExecutor.java", ApplicationRegistrationApprovalWorkflowExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "complete", "org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workFlowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 68);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowDetails", "org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor", "java.lang.String", "workflowStatus", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "java.util.List"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cleanUpPendingTask", "org.wso2.carbon.apimgt.impl.workflow.ApplicationRegistrationApprovalWorkflowExecutor", "java.lang.String", "workflowExtRef", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "void"), 101);
    }
}

