/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.workflow;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.ApplicationWorkflowDTO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor$AjcClosure1;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor$AjcClosure3;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor$AjcClosure5;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor$AjcClosure7;
import org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor$AjcClosure9;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;

public class ApplicationCreationApprovalWorkflowExecutor
extends WorkflowExecutor {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        ApplicationCreationApprovalWorkflowExecutor.ajc$preClinit();
        log = LogFactory.getLog(ApplicationCreationApprovalWorkflowExecutor.class);
    }

    @Override
    public String getWorkflowType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApplicationCreationApprovalWorkflowExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationCreationApprovalWorkflowExecutor.getWorkflowType_aroundBody0(this, joinPoint);
    }

    @Override
    public WorkflowResponse execute(WorkflowDTO workflowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO2 = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)workflowDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO2, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new ApplicationCreationApprovalWorkflowExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationCreationApprovalWorkflowExecutor.execute_aroundBody2(this, workflowDTO2, joinPoint);
    }

    @Override
    public WorkflowResponse complete(WorkflowDTO workFlowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO = workFlowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new ApplicationCreationApprovalWorkflowExecutor$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationCreationApprovalWorkflowExecutor.complete_aroundBody4(this, workflowDTO, joinPoint);
    }

    @Override
    public List<WorkflowDTO> getWorkflowDetails(String workflowStatus) throws WorkflowException {
        String string = workflowStatus;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new ApplicationCreationApprovalWorkflowExecutor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApplicationCreationApprovalWorkflowExecutor.getWorkflowDetails_aroundBody6(this, string, joinPoint);
    }

    @Override
    public void cleanUpPendingTask(String workflowExtRef) throws WorkflowException {
        String string = workflowExtRef;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new ApplicationCreationApprovalWorkflowExecutor$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        ApplicationCreationApprovalWorkflowExecutor.cleanUpPendingTask_aroundBody8(this, string, joinPoint);
    }

    static final /* synthetic */ String getWorkflowType_aroundBody0(ApplicationCreationApprovalWorkflowExecutor ajc$this, JoinPoint joinPoint) {
        return "AM_APPLICATION_CREATION";
    }

    static final /* synthetic */ WorkflowResponse execute_aroundBody2(ApplicationCreationApprovalWorkflowExecutor ajc$this, WorkflowDTO workflowDTO, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing Application creation Workflow.");
        }
        ApplicationWorkflowDTO appWorkFlowDTO = (ApplicationWorkflowDTO)workflowDTO;
        Application application = appWorkFlowDTO.getApplication();
        String message = "Approve application " + application.getName() + " creation request from application creator -" + appWorkFlowDTO.getUserName() + " with throttling tier - " + application.getTier();
        workflowDTO.setWorkflowDescription(message);
        workflowDTO.setProperties("applicationName", application.getName());
        workflowDTO.setProperties("userName", appWorkFlowDTO.getUserName());
        workflowDTO.setProperties("applicationTier", application.getTier());
        super.execute(workflowDTO);
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ WorkflowResponse complete_aroundBody4(ApplicationCreationApprovalWorkflowExecutor ajc$this, WorkflowDTO workFlowDTO, JoinPoint joinPoint) {
        block11: {
            workFlowDTO.setUpdatedTime(System.currentTimeMillis());
            ApiMgtDAO dao = ApiMgtDAO.getInstance();
            try {
                if (dao.getApplicationById(Integer.parseInt(workFlowDTO.getWorkflowReference())) != null) {
                    super.complete(workFlowDTO);
                    if (log.isDebugEnabled()) {
                        String logMessage = "Application Creation [Complete] Workflow Invoked. Workflow ID : " + workFlowDTO.getExternalWorkflowReference() + " Workflow State : " + (Object)((Object)workFlowDTO.getStatus());
                        log.debug((Object)logMessage);
                    }
                    String status = null;
                    if (WorkflowStatus.CREATED.equals((Object)workFlowDTO.getStatus())) {
                        status = "CREATED";
                    } else if (WorkflowStatus.REJECTED.equals((Object)workFlowDTO.getStatus())) {
                        status = "REJECTED";
                    } else if (WorkflowStatus.APPROVED.equals((Object)workFlowDTO.getStatus())) {
                        status = "APPROVED";
                    }
                    try {
                        dao.updateApplicationStatus(Integer.parseInt(workFlowDTO.getWorkflowReference()), status);
                        break block11;
                    }
                    catch (APIManagementException e) {
                        String msg = "Error occurred when updating the status of the Application creation process";
                        log.error((Object)msg, (Throwable)e);
                        throw new WorkflowException(msg, e);
                    }
                }
                String msg = "Application does not exist";
                throw new WorkflowException(msg);
            }
            catch (APIManagementException e) {
                String msg = "Error occurred when retrieving the Application creation with workflow ID :" + workFlowDTO.getWorkflowReference();
                log.error((Object)msg, (Throwable)e);
                throw new WorkflowException(msg, e);
            }
        }
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ List getWorkflowDetails_aroundBody6(ApplicationCreationApprovalWorkflowExecutor ajc$this, String workflowStatus, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ void cleanUpPendingTask_aroundBody8(ApplicationCreationApprovalWorkflowExecutor ajc$this, String workflowExtRef, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting cleanup task for ApplicationCreationApprovalWorkflowExecutor for :" + workflowExtRef));
        }
        super.cleanUpPendingTask(workflowExtRef);
        try {
            ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
            apiMgtDAO.deleteWorkflowRequest(workflowExtRef);
        }
        catch (APIManagementException axisFault) {
            String errorMsg = "Error sending out cancel pending application approval process message. cause: " + axisFault.getMessage();
            throw new WorkflowException(errorMsg, axisFault);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationCreationApprovalWorkflowExecutor.java", ApplicationCreationApprovalWorkflowExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowType", "org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor", "", "", "", "java.lang.String"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "complete", "org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workFlowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 73);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowDetails", "org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor", "java.lang.String", "workflowStatus", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "java.util.List"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cleanUpPendingTask", "org.wso2.carbon.apimgt.impl.workflow.ApplicationCreationApprovalWorkflowExecutor", "java.lang.String", "workflowExtRef", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "void"), 127);
    }
}

