/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.workflow;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.api.dto.KeyManagerConfigurationDTO;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.KeyManager;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.ApplicationRegistrationWorkflowDTO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.ApplicationUtils;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor$AjcClosure1;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor$AjcClosure3;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor$AjcClosure5;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor$AjcClosure7;
import org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor$AjcClosure9;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;

public abstract class AbstractApplicationRegistrationWorkflowExecutor
extends WorkflowExecutor {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        AbstractApplicationRegistrationWorkflowExecutor.ajc$preClinit();
        log = LogFactory.getLog(AbstractApplicationRegistrationWorkflowExecutor.class);
    }

    @Override
    public String getWorkflowType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractApplicationRegistrationWorkflowExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractApplicationRegistrationWorkflowExecutor.getWorkflowType_aroundBody0(this, joinPoint);
    }

    @Override
    public WorkflowResponse execute(WorkflowDTO workFlowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO = workFlowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)workflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new AbstractApplicationRegistrationWorkflowExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractApplicationRegistrationWorkflowExecutor.execute_aroundBody2(this, workflowDTO, joinPoint);
    }

    @Override
    public WorkflowResponse complete(WorkflowDTO workFlowDTO) throws WorkflowException {
        WorkflowDTO workflowDTO = workFlowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, workflowDTO, joinPoint};
            return (WorkflowResponse)MethodTimeLogger.aspectOf().log(new AbstractApplicationRegistrationWorkflowExecutor$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractApplicationRegistrationWorkflowExecutor.complete_aroundBody4(this, workflowDTO, joinPoint);
    }

    protected void generateKeysForApplication(ApplicationRegistrationWorkflowDTO workflowDTO) throws APIManagementException {
        ApplicationRegistrationWorkflowDTO applicationRegistrationWorkflowDTO = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)applicationRegistrationWorkflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, applicationRegistrationWorkflowDTO, joinPoint};
            MethodTimeLogger.aspectOf().log(new AbstractApplicationRegistrationWorkflowExecutor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AbstractApplicationRegistrationWorkflowExecutor.generateKeysForApplication_aroundBody6(this, applicationRegistrationWorkflowDTO, joinPoint);
    }

    public static void dogenerateKeysForApplication(ApplicationRegistrationWorkflowDTO workflowDTO) throws APIManagementException {
        ApplicationRegistrationWorkflowDTO applicationRegistrationWorkflowDTO = workflowDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)applicationRegistrationWorkflowDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{applicationRegistrationWorkflowDTO, joinPoint};
            MethodTimeLogger.aspectOf().log(new AbstractApplicationRegistrationWorkflowExecutor$AjcClosure9(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        AbstractApplicationRegistrationWorkflowExecutor.dogenerateKeysForApplication_aroundBody8(applicationRegistrationWorkflowDTO, joinPoint);
    }

    static final /* synthetic */ String getWorkflowType_aroundBody0(AbstractApplicationRegistrationWorkflowExecutor ajc$this, JoinPoint joinPoint) {
        return "AM_APPLICATION_REGISTRATION_PRODUCTION";
    }

    static final /* synthetic */ WorkflowResponse execute_aroundBody2(AbstractApplicationRegistrationWorkflowExecutor ajc$this, WorkflowDTO workFlowDTO, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing AbstractApplicationRegistrationWorkflowExecutor...");
        }
        ApiMgtDAO dao = ApiMgtDAO.getInstance();
        try {
            if (!(workFlowDTO instanceof ApplicationRegistrationWorkflowDTO)) {
                String message = "Invalid workflow type found";
                log.error((Object)message);
                throw new WorkflowException(message);
            }
            ApplicationRegistrationWorkflowDTO appRegDTO = (ApplicationRegistrationWorkflowDTO)workFlowDTO;
            dao.createApplicationRegistrationEntry(appRegDTO, false);
            super.execute(workFlowDTO);
        }
        catch (APIManagementException e) {
            log.error((Object)"Error while creating Application Registration entry.", (Throwable)e);
            throw new WorkflowException("Error while creating Application Registration entry.", e);
        }
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ WorkflowResponse complete_aroundBody4(AbstractApplicationRegistrationWorkflowExecutor ajc$this, WorkflowDTO workFlowDTO, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completing AbstractApplicationRegistrationWorkflowExecutor...");
        }
        super.complete(workFlowDTO);
        ApiMgtDAO dao = ApiMgtDAO.getInstance();
        try {
            String status = null;
            if ("CREATED".equals(workFlowDTO.getStatus().toString())) {
                status = "CREATED";
            } else if ("REJECTED".equals(workFlowDTO.getStatus().toString())) {
                status = "REJECTED";
            } else if ("APPROVED".equals(workFlowDTO.getStatus().toString())) {
                status = "APPROVED";
            }
            if (!(workFlowDTO instanceof ApplicationRegistrationWorkflowDTO)) {
                String message = "Invalid workflow type found";
                log.error((Object)message);
                throw new WorkflowException(message);
            }
            ApplicationRegistrationWorkflowDTO regWorkFlowDTO = (ApplicationRegistrationWorkflowDTO)workFlowDTO;
            dao.populateAppRegistrationWorkflowDTO(regWorkFlowDTO);
            dao.updateApplicationRegistration(status, regWorkFlowDTO.getKeyType(), regWorkFlowDTO.getApplication().getId(), regWorkFlowDTO.getKeyManager());
        }
        catch (APIManagementException e) {
            log.error((Object)"Error while completing Application Registration entry.", (Throwable)e);
            throw new WorkflowException("Error while completing Application Registration entry.", e);
        }
        return new GeneralWorkflowResponse();
    }

    static final /* synthetic */ void generateKeysForApplication_aroundBody6(AbstractApplicationRegistrationWorkflowExecutor ajc$this, ApplicationRegistrationWorkflowDTO workflowDTO, JoinPoint joinPoint) {
        if (WorkflowStatus.APPROVED.equals((Object)workflowDTO.getStatus())) {
            AbstractApplicationRegistrationWorkflowExecutor.dogenerateKeysForApplication(workflowDTO);
        }
    }

    static final /* synthetic */ void dogenerateKeysForApplication_aroundBody8(ApplicationRegistrationWorkflowDTO workflowDTO, JoinPoint joinPoint) {
        log.debug((Object)"Registering Application and creating an Access Token... ");
        Application application = workflowDTO.getApplication();
        Subscriber subscriber = application.getSubscriber();
        ApiMgtDAO dao = ApiMgtDAO.getInstance();
        if (subscriber == null || workflowDTO.getAllowedDomains() == null) {
            dao.populateAppRegistrationWorkflowDTO(workflowDTO);
        }
        try {
            AccessTokenInfo tokenInfo;
            String keyManagerId = workflowDTO.getKeyManager();
            KeyManagerConfigurationDTO km = dao.getKeyManagerConfigurationByUUID(keyManagerId);
            String tenantDomain = km.getTenantDomain();
            String keyManagerName = km.getName();
            KeyManager keyManager = KeyManagerHolder.getKeyManagerInstance(tenantDomain, keyManagerName);
            if (keyManager == null) {
                throw new APIManagementException("Key Manager " + keyManagerName + " not configured");
            }
            workflowDTO.getAppInfoDTO().getOAuthApplicationInfo().setClientName(application.getName());
            workflowDTO.getAppInfoDTO().getOAuthApplicationInfo().putAllAppAttributes(application.getApplicationAttributes());
            OAuthApplicationInfo oAuthApplication = keyManager.createApplication(workflowDTO.getAppInfoDTO());
            ApplicationUtils.updateOAuthAppAssociation(application, workflowDTO.getKeyType(), oAuthApplication, keyManagerId);
            dao.updateApplicationRegistration("COMPLETED", workflowDTO.getKeyType(), workflowDTO.getApplication().getId(), keyManagerId);
            workflowDTO.setApplicationInfo(oAuthApplication);
            Object enableTokenGeneration = keyManager.getKeyManagerConfiguration().getParameter("enable_token_generation");
            if (enableTokenGeneration != null && ((Boolean)enableTokenGeneration).booleanValue() && oAuthApplication.getJsonString().contains("client_credentials")) {
                AccessTokenRequest tokenRequest = ApplicationUtils.createAccessTokenRequest(keyManager, oAuthApplication, null);
                tokenInfo = keyManager.getNewApplicationAccessToken(tokenRequest);
            } else {
                tokenInfo = new AccessTokenInfo();
                tokenInfo.setAccessToken("");
                tokenInfo.setValidityPeriod(0L);
                Object[] noScopes = new String[]{"N/A"};
                tokenInfo.setScope((String[])noScopes);
                oAuthApplication.addParameter("tokenScope", (Object)Arrays.toString(noScopes));
            }
            workflowDTO.setAccessTokenInfo(tokenInfo);
        }
        catch (Exception e) {
            APIUtil.handleException("Error occurred while executing SubscriberKeyMgtClient.", e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractApplicationRegistrationWorkflowExecutor.java", AbstractApplicationRegistrationWorkflowExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkflowType", "org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor", "", "", "", "java.lang.String"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workFlowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 51);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "complete", "org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.WorkflowDTO", "workFlowDTO", "org.wso2.carbon.apimgt.impl.workflow.WorkflowException", "org.wso2.carbon.apimgt.api.WorkflowResponse"), 76);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "generateKeysForApplication", "org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.ApplicationRegistrationWorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 118);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "dogenerateKeysForApplication", "org.wso2.carbon.apimgt.impl.workflow.AbstractApplicationRegistrationWorkflowExecutor", "org.wso2.carbon.apimgt.impl.dto.ApplicationRegistrationWorkflowDTO", "workflowDTO", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 125);
    }
}

