/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.SigningUtil$AjcClosure1;
import org.wso2.carbon.apimgt.impl.utils.SigningUtil$AjcClosure3;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class SigningUtil {
    private static final ConcurrentHashMap<Integer, Key> privateKeys;
    private static final ConcurrentHashMap<Integer, Certificate> publicCerts;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        SigningUtil.ajc$preClinit();
        privateKeys = new ConcurrentHashMap();
        publicCerts = new ConcurrentHashMap();
    }

    private SigningUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static PrivateKey getSigningKey(int tenantId) throws APIManagementException {
        int n = tenantId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
            return (PrivateKey)MethodTimeLogger.aspectOf().log(new SigningUtil$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return SigningUtil.getSigningKey_aroundBody0(n, joinPoint);
    }

    public static Certificate getPublicCertificate(int tenantId) throws APIManagementException {
        int n = tenantId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
            return (Certificate)MethodTimeLogger.aspectOf().log(new SigningUtil$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return SigningUtil.getPublicCertificate_aroundBody2(n, joinPoint);
    }

    static final /* synthetic */ PrivateKey getSigningKey_aroundBody0(int tenantId, JoinPoint joinPoint) {
        String tenantDomain = APIUtil.getTenantDomainFromTenantId(tenantId);
        try {
            Key privateKey;
            if (!privateKeys.containsKey(tenantId)) {
                APIUtil.loadTenantRegistry(tenantId);
                KeyStoreManager tenantKeyStoreManager = KeyStoreManager.getInstance((int)tenantId);
                if (!"carbon.super".equals(tenantDomain)) {
                    String ksName = tenantDomain.trim().replace('.', '-');
                    String jksName = String.valueOf(ksName) + ".jks";
                    privateKey = tenantKeyStoreManager.getPrivateKey(jksName, tenantDomain);
                } else {
                    privateKey = tenantKeyStoreManager.getDefaultPrivateKey();
                }
                if (privateKey != null) {
                    privateKeys.put(tenantId, privateKey);
                }
            } else {
                privateKey = privateKeys.get(tenantId);
            }
            if (privateKey == null) {
                throw new APIManagementException("Error while obtaining private key for tenant: " + tenantDomain);
            }
            return (PrivateKey)privateKey;
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while loading tenant registry for " + tenantDomain, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException("Error while obtaining private key for tenant: " + tenantDomain, (Throwable)e);
        }
    }

    static final /* synthetic */ Certificate getPublicCertificate_aroundBody2(int tenantId, JoinPoint joinPoint) {
        String tenantDomain = APIUtil.getTenantDomainFromTenantId(tenantId);
        try {
            Certificate publicCert;
            if (!publicCerts.containsKey(tenantId)) {
                APIUtil.loadTenantRegistry(tenantId);
                KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
                if (!"carbon.super".equals(tenantDomain)) {
                    String ksName = tenantDomain.trim().replace('.', '-');
                    String jksName = String.valueOf(ksName) + ".jks";
                    KeyStore keyStore = keyStoreManager.getKeyStore(jksName);
                    publicCert = keyStore.getCertificate(tenantDomain);
                } else {
                    publicCert = keyStoreManager.getDefaultPrimaryCertificate();
                }
                if (publicCert != null) {
                    publicCerts.put(tenantId, publicCert);
                }
            } else {
                publicCert = publicCerts.get(tenantId);
            }
            if (publicCert == null) {
                throw new APIManagementException("Error while obtaining public certificate from keystore for tenant: " + tenantDomain);
            }
            return publicCert;
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while loading tenant registry for " + tenantDomain, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException("Error while obtaining public certificate from keystore for tenant: " + tenantDomain, (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SigningUtil.java", SigningUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSigningKey", "org.wso2.carbon.apimgt.impl.utils.SigningUtil", "int", "tenantId", "org.wso2.carbon.apimgt.api.APIManagementException", "java.security.PrivateKey"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getPublicCertificate", "org.wso2.carbon.apimgt.impl.utils.SigningUtil", "int", "tenantId", "org.wso2.carbon.apimgt.api.APIManagementException", "java.security.cert.Certificate"), 94);
    }
}

