/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure1;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure11;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure13;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure15;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure17;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure19;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure3;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure5;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure7;
import org.wso2.carbon.apimgt.impl.utils.APIFileUtil$AjcClosure9;

public class APIFileUtil {
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    public static final String XSD_FILE_EXTENSION = "xsd";
    private static final Logger log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        APIFileUtil.ajc$preClinit();
        log = LoggerFactory.getLogger(APIFileUtil.class);
    }

    public static String extractUploadedArchive(InputStream uploadedApiArchiveInputStream, String importedDirectoryName, String apiArchiveLocation, String extractLocation) throws APIManagementException {
        InputStream inputStream = uploadedApiArchiveInputStream;
        String string = importedDirectoryName;
        String string2 = apiArchiveLocation;
        String string3 = extractLocation;
        Object[] objectArray = new Object[]{inputStream, string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{inputStream, string, string2, string3, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure1(objectArray2).linkClosureAndJoinPoint(65536));
        }
        return APIFileUtil.extractUploadedArchive_aroundBody0(inputStream, string, string2, string3, joinPoint);
    }

    public static void createDirectory(String path) throws APIManagementException {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.createDirectory_aroundBody2(string, joinPoint);
    }

    public static void deleteDirectory(String path) throws APIManagementException {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.deleteDirectory_aroundBody4(string, joinPoint);
    }

    public static void createArchiveFromInputStream(InputStream inputStream, String archivePath) throws APIManagementException {
        InputStream inputStream2 = inputStream;
        String string = archivePath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)inputStream2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{inputStream2, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.createArchiveFromInputStream_aroundBody6(inputStream2, string, joinPoint);
    }

    public static String extractArchive(String archiveFilePath, String destination) throws APIManagementException {
        String string = archiveFilePath;
        String string2 = destination;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure9(objectArray).linkClosureAndJoinPoint(65536));
        }
        return APIFileUtil.extractArchive_aroundBody8(string, string2, joinPoint);
    }

    private static void writeFileToDestination(ZipFile zip, ZipEntry entry, File destinationFile) throws IOException {
        ZipFile zipFile = zip;
        ZipEntry zipEntry = entry;
        File file = destinationFile;
        Object[] objectArray = new Object[]{zipFile, zipEntry, file};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{zipFile, zipEntry, file, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure11(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.writeFileToDestination_aroundBody10(zipFile, zipEntry, file, joinPoint);
    }

    public static void extractSingleWSDLFile(InputStream inputStream, String wsdlFileDir, String wsdlFilePath) {
        InputStream inputStream2 = inputStream;
        String string = wsdlFileDir;
        String string2 = wsdlFilePath;
        Object[] objectArray = new Object[]{inputStream2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{inputStream2, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure13(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.extractSingleWSDLFile_aroundBody12(inputStream2, string, string2, joinPoint);
    }

    public static Collection<File> searchFilesWithMatchingExtension(File folder, String extension) {
        File file = folder;
        String string = extension;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)file, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{file, string, joinPoint};
            return (Collection)MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure15(objectArray).linkClosureAndJoinPoint(65536));
        }
        return APIFileUtil.searchFilesWithMatchingExtension_aroundBody14(file, string, joinPoint);
    }

    public static void deleteParentDirectory(String filePath) {
        String string = filePath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure17(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        APIFileUtil.deleteParentDirectory_aroundBody16(string, joinPoint);
    }

    public static boolean hasFileContainsString(String path, String extension, String stringTosearch) {
        String string = path;
        String string2 = extension;
        String string3 = stringTosearch;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{string, string2, string3, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIFileUtil$AjcClosure19(objectArray2).linkClosureAndJoinPoint(65536)));
        }
        return APIFileUtil.hasFileContainsString_aroundBody18(string, string2, string3, joinPoint);
    }

    static final /* synthetic */ String extractUploadedArchive_aroundBody0(InputStream uploadedApiArchiveInputStream, String importedDirectoryName, String apiArchiveLocation, String extractLocation, JoinPoint joinPoint) {
        String archiveExtractLocation;
        try {
            APIFileUtil.createDirectory(extractLocation);
            APIFileUtil.createArchiveFromInputStream(uploadedApiArchiveInputStream, apiArchiveLocation);
            archiveExtractLocation = String.valueOf(extractLocation) + File.separator + importedDirectoryName;
            APIFileUtil.extractArchive(apiArchiveLocation, archiveExtractLocation);
        }
        catch (APIManagementException e) {
            APIFileUtil.deleteDirectory(extractLocation);
            String errorMsg = "Error in accessing uploaded API archive";
            log.error(errorMsg, (Throwable)e);
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
        return archiveExtractLocation;
    }

    static final /* synthetic */ void createDirectory_aroundBody2(String path, JoinPoint joinPoint) {
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            String msg = "Error in creating directory at: " + path;
            log.error(msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
    }

    static final /* synthetic */ void deleteDirectory_aroundBody4(String path, JoinPoint joinPoint) {
        try {
            FileUtils.deleteDirectory((File)new File(path));
        }
        catch (IOException e) {
            String errorMsg = "Error while deleting directory : " + path;
            log.error(errorMsg, (Throwable)e);
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
    }

    static final /* synthetic */ void createArchiveFromInputStream_aroundBody6(InputStream inputStream, String archivePath, JoinPoint joinPoint) {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileOutputStream outFileStream = new FileOutputStream(new File(archivePath));){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outFileStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String errorMsg = "Error in Creating archive from data.";
            log.error(errorMsg, (Throwable)e);
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
    }

    static final /* synthetic */ String extractArchive_aroundBody8(String archiveFilePath, String destination, JoinPoint joinPoint) {
        int bufferSize = 512;
        long sizeLimit = 0x6400000L;
        int maxEntryCount = 1024;
        String archiveName = null;
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(archiveFilePath);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            int entries = 0;
            long total = 0L;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String currentEntry = entry.getName();
                int index = 0;
                if (index == 0 && currentEntry.indexOf(47) != -1) {
                    archiveName = currentEntry.substring(0, currentEntry.indexOf(47));
                    --index;
                }
                File destinationFile = new File(destination, currentEntry);
                File destinationParent = destinationFile.getParentFile();
                String canonicalizedDestinationFilePath = destinationFile.getCanonicalPath();
                if (!canonicalizedDestinationFilePath.startsWith(new File(destination).getCanonicalPath())) {
                    String errorMessage = "Attempt to upload invalid zip archive with file at " + currentEntry + ". File path is outside target directory";
                    log.error(errorMessage);
                    throw new APIManagementException(errorMessage);
                }
                if (entry.isDirectory()) {
                    log.debug("Creating directory " + destinationFile.getAbsolutePath());
                    destinationFile.mkdir();
                    continue;
                }
                if (destinationParent.mkdirs()) {
                    log.debug("Creation of folder is successful. Directory Name : " + destinationParent.getName());
                }
                byte[] data = new byte[bufferSize];
                FileOutputStream fos = new FileOutputStream(destinationFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, bufferSize);
                while (total + (long)bufferSize <= sizeLimit && (count = zis.read(data, 0, bufferSize)) != -1) {
                    dest.write(data, 0, count);
                    total += (long)count;
                }
                dest.flush();
                dest.close();
                zis.closeEntry();
                if (++entries > maxEntryCount) {
                    throw new APIManagementException("Too many files to unzip.");
                }
                if (total + (long)bufferSize <= sizeLimit) continue;
                throw new APIManagementException("File being unzipped is too big.");
            }
            return archiveName;
        }
        catch (IOException e) {
            String errorMsg = "Failed to extract archive file: " + archiveFilePath + " to destination: " + destination;
            log.error(errorMsg, (Throwable)e);
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ void writeFileToDestination_aroundBody10(ZipFile zip, ZipEntry entry, File destinationFile, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            InputStream zipInputStream = zip.getInputStream(entry);
            try {
                block18: {
                    BufferedInputStream inputStream = new BufferedInputStream(zipInputStream);
                    try {
                        try (FileOutputStream outputStream = new FileOutputStream(destinationFile);){
                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        if (inputStream == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                if (zipInputStream == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (zipInputStream == null) throw throwable;
                zipInputStream.close();
                throw throwable;
            }
            zipInputStream.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    static final /* synthetic */ void extractSingleWSDLFile_aroundBody12(InputStream inputStream, String wsdlFileDir, String wsdlFilePath, JoinPoint joinPoint) {
        try {
            APIFileUtil.createDirectory(wsdlFileDir);
            APIFileUtil.createArchiveFromInputStream(inputStream, wsdlFilePath);
        }
        catch (APIManagementException e) {
            String errorMsg = "Failed to extract wsdl file: " + wsdlFilePath;
            log.error(errorMsg, (Throwable)e);
        }
    }

    static final /* synthetic */ Collection searchFilesWithMatchingExtension_aroundBody14(File folder, String extension, JoinPoint joinPoint) {
        return FileUtils.listFiles((File)folder, (String[])new String[]{extension}, (boolean)true);
    }

    static final /* synthetic */ void deleteParentDirectory_aroundBody16(String filePath, JoinPoint joinPoint) {
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            try {
                FileUtils.deleteDirectory((File)new File(filePath).getParentFile());
            }
            catch (IOException iOException) {
                log.warn("Failed to clean temporary files at : " + filePath + " Delete those files manually or it will be cleared after a server restart.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ boolean hasFileContainsString_aroundBody18(String path, String extension, String stringTosearch, JoinPoint joinPoint) {
        File folderToImport = new File(path);
        Collection<File> foundWSDLFiles = APIFileUtil.searchFilesWithMatchingExtension(folderToImport, extension);
        for (File file : foundWSDLFiles) {
            String absWSDLPath = file.getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug("Processing WSDL file: " + absWSDLPath);
            }
            try {
                Throwable throwable = null;
                Object var16_12 = null;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    try {
                        String inputLine = reader.readLine();
                        if (inputLine == null) continue;
                    }
                    finally {
                        if (reader == null) return true;
                        reader.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Error while validating WSDL files in path " + path, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIFileUtil.java", APIFileUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "extractUploadedArchive", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.io.InputStream:java.lang.String:java.lang.String:java.lang.String", "uploadedApiArchiveInputStream:importedDirectoryName:apiArchiveLocation:extractLocation", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDirectory", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.lang.String", "path", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 80);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "deleteDirectory", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.lang.String", "path", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createArchiveFromInputStream", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.io.InputStream:java.lang.String", "inputStream:archivePath", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 113);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "extractArchive", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.lang.String:java.lang.String", "archiveFilePath:destination", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 132);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "writeFileToDestination", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.util.zip.ZipFile:java.util.zip.ZipEntry:java.io.File", "zip:entry:destinationFile", "java.io.IOException", "void"), 204);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "extractSingleWSDLFile", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.io.InputStream:java.lang.String:java.lang.String", "inputStream:wsdlFileDir:wsdlFilePath", "", "void"), 220);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "searchFilesWithMatchingExtension", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.io.File:java.lang.String", "folder:extension", "", "java.util.Collection"), 237);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "deleteParentDirectory", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.lang.String", "filePath", "", "void"), 246);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "hasFileContainsString", "org.wso2.carbon.apimgt.impl.utils.APIFileUtil", "java.lang.String:java.lang.String:java.lang.String", "path:extension:stringTosearch", "", "boolean"), 266);
    }
}

