/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil$AjcClosure1;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil$AjcClosure3;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil$AjcClosure5;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil$AjcClosure7;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil$AjcClosure9;

public class APIDescriptionGenUtil {
    private static Log log;
    private static final String DESCRIPTION = "Allows [1] request(s) per minute.";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        APIDescriptionGenUtil.ajc$preClinit();
        log = LogFactory.getLog(APIDescriptionGenUtil.class);
    }

    public static String generateDescriptionFromPolicy(OMElement policy) throws APIManagementException {
        OMElement oMElement = policy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)oMElement);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oMElement, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIDescriptionGenUtil$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return APIDescriptionGenUtil.generateDescriptionFromPolicy_aroundBody0(oMElement, joinPoint);
    }

    public static long getAllowedRequestCount(OMElement policy) throws APIManagementException {
        OMElement oMElement = policy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)oMElement);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oMElement, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new APIDescriptionGenUtil$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536)));
        }
        return APIDescriptionGenUtil.getAllowedRequestCount_aroundBody2(oMElement, joinPoint);
    }

    public static Map<String, Object> getTierAttributes(OMElement policy) throws APIManagementException {
        OMElement oMElement = policy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)oMElement);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oMElement, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new APIDescriptionGenUtil$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
        }
        return APIDescriptionGenUtil.getTierAttributes_aroundBody4(oMElement, joinPoint);
    }

    public static long getAllowedCountPerMinute(OMElement policy) throws APIManagementException {
        OMElement oMElement = policy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)oMElement);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oMElement, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new APIDescriptionGenUtil$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536)));
        }
        return APIDescriptionGenUtil.getAllowedCountPerMinute_aroundBody6(oMElement, joinPoint);
    }

    public static long getTimeDuration(OMElement policy) throws APIManagementException {
        OMElement oMElement = policy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)oMElement);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oMElement, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new APIDescriptionGenUtil$AjcClosure9(objectArray).linkClosureAndJoinPoint(65536)));
        }
        return APIDescriptionGenUtil.getTimeDuration_aroundBody8(oMElement, joinPoint);
    }

    static final /* synthetic */ String generateDescriptionFromPolicy_aroundBody0(OMElement policy, JoinPoint joinPoint) {
        try {
            OMElement maxCount = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT);
            OMElement timeUnit = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_UNIT_TIME_ELEMENT);
            if (maxCount.getText().isEmpty() || timeUnit.getText().isEmpty()) {
                String msg = APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT + " or " + APIConstants.THROTTLE_UNIT_TIME_ELEMENT + " element data found empty in " + "the policy.";
                log.warn((Object)msg);
                throw new APIManagementException(msg);
            }
            long requestPerMinute = Long.parseLong(maxCount.getText().trim()) * 60000L / Long.parseLong(timeUnit.getText().trim());
            if (requestPerMinute >= 1L) {
                return DESCRIPTION.replaceAll("\\[1\\]", Long.toString(requestPerMinute));
            }
            return DESCRIPTION;
        }
        catch (NullPointerException npe) {
            String msg = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.error((Object)msg, (Throwable)npe);
            throw new APIManagementException(msg, (Throwable)npe);
        }
    }

    static final /* synthetic */ long getAllowedRequestCount_aroundBody2(OMElement policy, JoinPoint joinPoint) {
        try {
            OMElement maxCount = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT);
            if (maxCount.getText().isEmpty()) {
                String message = String.valueOf(APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT.getLocalPart()) + " element data not found empty in the policy.";
                log.warn((Object)message);
                throw new APIManagementException(message);
            }
            return Long.parseLong(maxCount.getText().trim());
        }
        catch (OMException e) {
            String errorMessage = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIManagementException(String.valueOf(errorMessage) + e.getMessage());
        }
        catch (NumberFormatException e) {
            log.error((Object)"Error in retrieving request count in tier xml.", (Throwable)e);
            throw new APIManagementException("Error in retrieving request count in tier xml." + e.getMessage());
        }
    }

    static final /* synthetic */ Map getTierAttributes_aroundBody4(OMElement policy, JoinPoint joinPoint) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        OMElement attributes = null;
        try {
            OMElement tier = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT);
            if (tier != null) {
                attributes = tier.getFirstChildWithName(APIConstants.THROTTLE_ATTRIBUTES_ELEMENT);
            }
            if (attributes == null) {
                return attributesMap;
            }
            Iterator childElements = attributes.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                String displayName = element.getAttributeValue(new QName("displayName"));
                String localName = element.getLocalName();
                String attrName = displayName != null ? displayName : localName;
                String attrValue = element.getText();
                attributesMap.put(attrName, attrValue);
            }
        }
        catch (NullPointerException e) {
            String errorMessage = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIManagementException(String.valueOf(errorMessage) + e.getMessage());
        }
        return attributesMap;
    }

    static final /* synthetic */ long getAllowedCountPerMinute_aroundBody6(OMElement policy, JoinPoint joinPoint) {
        try {
            OMElement maxCount = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT);
            OMElement timeUnit = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_UNIT_TIME_ELEMENT);
            if (maxCount.getText().isEmpty() || timeUnit.getText().isEmpty()) {
                String errorMessage = APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT + "or" + APIConstants.THROTTLE_UNIT_TIME_ELEMENT + " element data found empty in " + "the policy.";
                log.warn((Object)errorMessage);
                throw new APIManagementException(errorMessage);
            }
            return Long.parseLong(maxCount.getText().trim()) * 60000L / Long.parseLong(timeUnit.getText().trim());
        }
        catch (NullPointerException e) {
            String errorMessage = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIManagementException(String.valueOf(errorMessage) + e.getMessage());
        }
    }

    static final /* synthetic */ long getTimeDuration_aroundBody8(OMElement policy, JoinPoint joinPoint) {
        try {
            OMElement duration = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_UNIT_TIME_ELEMENT);
            if (duration.getText().isEmpty()) {
                String message = String.valueOf(APIConstants.THROTTLE_UNIT_TIME_ELEMENT.getLocalPart()) + " element data not found empty in the policy.";
                log.warn((Object)message);
                throw new APIManagementException(message);
            }
            return Long.parseLong(duration.getText().trim());
        }
        catch (OMException e) {
            String errorMessage = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIManagementException(errorMessage, (Throwable)e);
        }
        catch (NumberFormatException e) {
            String message = "Error in retrieving time duration from the tiers xml";
            log.error((Object)message, (Throwable)e);
            throw new APIManagementException(message, (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIDescriptionGenUtil.java", APIDescriptionGenUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateDescriptionFromPolicy", "org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil", "org.apache.axiom.om.OMElement", "policy", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getAllowedRequestCount", "org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil", "org.apache.axiom.om.OMElement", "policy", "org.wso2.carbon.apimgt.api.APIManagementException", "long"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTierAttributes", "org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil", "org.apache.axiom.om.OMElement", "policy", "org.wso2.carbon.apimgt.api.APIManagementException", "java.util.Map"), 116);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getAllowedCountPerMinute", "org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil", "org.apache.axiom.om.OMElement", "policy", "org.wso2.carbon.apimgt.api.APIManagementException", "long"), 157);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTimeDuration", "org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil", "org.apache.axiom.om.OMElement", "policy", "org.wso2.carbon.apimgt.api.APIManagementException", "long"), 197);
    }
}

