/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.token;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO;
import org.wso2.carbon.apimgt.impl.token.ApiKeyGenerator;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator;
import org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator$AjcClosure7;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;

public class InternalAPIKeyGenerator
implements ApiKeyGenerator {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        InternalAPIKeyGenerator.ajc$preClinit();
        log = LogFactory.getLog(DefaultApiKeyGenerator.class);
    }

    @Override
    public String generateToken(JwtTokenInfoDTO jwtTokenInfoDTO) throws APIManagementException {
        JwtTokenInfoDTO jwtTokenInfoDTO2 = jwtTokenInfoDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jwtTokenInfoDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jwtTokenInfoDTO2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new InternalAPIKeyGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyGenerator.generateToken_aroundBody0(this, jwtTokenInfoDTO2, joinPoint);
    }

    protected JWTClaimsSet buildBody(JwtTokenInfoDTO jwtTokenInfoDTO) {
        JwtTokenInfoDTO jwtTokenInfoDTO2 = jwtTokenInfoDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jwtTokenInfoDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jwtTokenInfoDTO2, joinPoint};
            return (JWTClaimsSet)MethodTimeLogger.aspectOf().log(new InternalAPIKeyGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyGenerator.buildBody_aroundBody2(this, jwtTokenInfoDTO2, joinPoint);
    }

    protected JWSHeader buildHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (JWSHeader)MethodTimeLogger.aspectOf().log(new InternalAPIKeyGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyGenerator.buildHeader_aroundBody4(this, joinPoint);
    }

    protected void buildSignature(SignedJWT assertion) throws APIManagementException {
        SignedJWT signedJWT = assertion;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)signedJWT);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWT, joinPoint};
            MethodTimeLogger.aspectOf().log(new InternalAPIKeyGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InternalAPIKeyGenerator.buildSignature_aroundBody6(this, signedJWT, joinPoint);
    }

    static final /* synthetic */ String generateToken_aroundBody0(InternalAPIKeyGenerator ajc$this, JwtTokenInfoDTO jwtTokenInfoDTO, JoinPoint joinPoint) {
        JWSHeader jwtHeader = ajc$this.buildHeader();
        JWTClaimsSet jwtBody = ajc$this.buildBody(jwtTokenInfoDTO);
        SignedJWT signedJWT = new SignedJWT(jwtHeader, jwtBody);
        ajc$this.buildSignature(signedJWT);
        if (log.isDebugEnabled()) {
            log.debug((Object)("signed assertion value : " + signedJWT.getParsedString()));
        }
        return signedJWT.serialize();
    }

    static final /* synthetic */ JWTClaimsSet buildBody_aroundBody2(InternalAPIKeyGenerator ajc$this, JwtTokenInfoDTO jwtTokenInfoDTO, JoinPoint joinPoint) {
        long currentTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expireIn = jwtTokenInfoDTO.getExpirationTime() == -1L || jwtTokenInfoDTO.getExpirationTime() > Integer.MAX_VALUE - currentTime ? -1L : currentTime + jwtTokenInfoDTO.getExpirationTime();
        String issuerIdentifier = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenIssuerIdentifier();
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.claim("sub", (Object)APIUtil.getUserNameWithTenantSuffix(jwtTokenInfoDTO.getEndUserName()));
        jwtClaimsSetBuilder.claim("jti", (Object)UUID.randomUUID().toString());
        jwtClaimsSetBuilder.claim("iss", (Object)issuerIdentifier);
        jwtClaimsSetBuilder.claim("iat", (Object)currentTime);
        if (expireIn != -1L) {
            jwtClaimsSetBuilder.claim("exp", (Object)expireIn);
        }
        jwtClaimsSetBuilder.claim("subscribedAPIs", jwtTokenInfoDTO.getSubscribedApiDTOList());
        jwtClaimsSetBuilder.claim("keytype", (Object)jwtTokenInfoDTO.getKeyType());
        jwtClaimsSetBuilder.claim("token_type", (Object)"InternalKey");
        return jwtClaimsSetBuilder.build();
    }

    static final /* synthetic */ JWSHeader buildHeader_aroundBody4(InternalAPIKeyGenerator ajc$this, JoinPoint joinPoint) {
        return new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(APIUtil.getInternalApiKeyAlias()).build();
    }

    static final /* synthetic */ void buildSignature_aroundBody6(InternalAPIKeyGenerator ajc$this, SignedJWT assertion, JoinPoint joinPoint) {
        KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)-1234);
        try {
            PrivateKey privateKey = tenantKSM.getDefaultPrivateKey();
            RSASSASigner jwsSigner = new RSASSASigner(privateKey);
            assertion.sign((JWSSigner)jwsSigner);
        }
        catch (Exception e) {
            throw new APIManagementException("Error while signing Api Key", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InternalAPIKeyGenerator.java", InternalAPIKeyGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateToken", "org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator", "org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO", "jwtTokenInfoDTO", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 27);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildBody", "org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator", "org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO", "jwtTokenInfoDTO", "", "com.nimbusds.jwt.JWTClaimsSet"), 42);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildHeader", "org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "com.nimbusds.jose.JWSHeader"), 70);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildSignature", "org.wso2.carbon.apimgt.impl.token.InternalAPIKeyGenerator", "com.nimbusds.jwt.SignedJWT", "assertion", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 75);
    }
}

