/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.token;

import com.nimbusds.jwt.JWTClaimsSet;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO;
import org.wso2.carbon.apimgt.impl.token.ApiKeyGenerator;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure11;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure7;
import org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator$AjcClosure9;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;

public class DefaultApiKeyGenerator
implements ApiKeyGenerator {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        DefaultApiKeyGenerator.ajc$preClinit();
        log = LogFactory.getLog(DefaultApiKeyGenerator.class);
    }

    @Override
    public String generateToken(JwtTokenInfoDTO jwtTokenInfoDTO) throws APIManagementException {
        JwtTokenInfoDTO jwtTokenInfoDTO2 = jwtTokenInfoDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jwtTokenInfoDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jwtTokenInfoDTO2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultApiKeyGenerator.generateToken_aroundBody0(this, jwtTokenInfoDTO2, joinPoint);
    }

    protected String buildBody(JwtTokenInfoDTO jwtTokenInfoDTO) {
        JwtTokenInfoDTO jwtTokenInfoDTO2 = jwtTokenInfoDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jwtTokenInfoDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jwtTokenInfoDTO2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultApiKeyGenerator.buildBody_aroundBody2(this, jwtTokenInfoDTO2, joinPoint);
    }

    protected String buildHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultApiKeyGenerator.buildHeader_aroundBody4(this, joinPoint);
    }

    protected byte[] buildSignature(String assertion) throws APIManagementException {
        String string = assertion;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (byte[])MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultApiKeyGenerator.buildSignature_aroundBody6(this, string, joinPoint);
    }

    private KeyStore getApiKeySignKeyStore(KeyStoreManager keyStoreManager) throws Exception {
        KeyStoreManager keyStoreManager2 = keyStoreManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)keyStoreManager2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, keyStoreManager2, joinPoint};
            return (KeyStore)MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultApiKeyGenerator.getApiKeySignKeyStore_aroundBody8(this, keyStoreManager2, joinPoint);
    }

    private static String encode(byte[] stringToBeEncoded) throws APIManagementException {
        byte[] byArray = stringToBeEncoded;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)byArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{byArray, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DefaultApiKeyGenerator$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536));
        }
        return DefaultApiKeyGenerator.encode_aroundBody10(byArray, joinPoint);
    }

    static final /* synthetic */ String generateToken_aroundBody0(DefaultApiKeyGenerator ajc$this, JwtTokenInfoDTO jwtTokenInfoDTO, JoinPoint joinPoint) {
        String jwtHeader = ajc$this.buildHeader();
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = DefaultApiKeyGenerator.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String jwtBody = ajc$this.buildBody(jwtTokenInfoDTO);
        String base64UrlEncodedBody = "";
        if (jwtBody != null) {
            base64UrlEncodedBody = DefaultApiKeyGenerator.encode(jwtBody.getBytes());
        }
        String assertion = String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody;
        byte[] signedAssertion = ajc$this.buildSignature(assertion);
        if (log.isDebugEnabled()) {
            log.debug((Object)("signed assertion value : " + new String(signedAssertion, Charset.defaultCharset())));
        }
        String base64UrlEncodedAssertion = DefaultApiKeyGenerator.encode(signedAssertion);
        return String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody + '.' + base64UrlEncodedAssertion;
    }

    static final /* synthetic */ String buildBody_aroundBody2(DefaultApiKeyGenerator ajc$this, JwtTokenInfoDTO jwtTokenInfoDTO, JoinPoint joinPoint) {
        long currentTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expireIn = jwtTokenInfoDTO.getExpirationTime() == -1L || jwtTokenInfoDTO.getExpirationTime() > Integer.MAX_VALUE - currentTime ? -1L : currentTime + jwtTokenInfoDTO.getExpirationTime();
        String issuerIdentifier = OAuthServerConfiguration.getInstance().getOpenIDConnectIDTokenIssuerIdentifier();
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.claim("sub", (Object)APIUtil.getUserNameWithTenantSuffix(jwtTokenInfoDTO.getEndUserName()));
        jwtClaimsSetBuilder.claim("jti", (Object)UUID.randomUUID().toString());
        jwtClaimsSetBuilder.claim("iss", (Object)issuerIdentifier);
        jwtClaimsSetBuilder.claim("iat", (Object)currentTime);
        if (expireIn != -1L) {
            jwtClaimsSetBuilder.claim("exp", (Object)expireIn);
        }
        jwtClaimsSetBuilder.claim("subscribedAPIs", jwtTokenInfoDTO.getSubscribedApiDTOList());
        jwtClaimsSetBuilder.claim("tierInfo", jwtTokenInfoDTO.getSubscriptionPolicyDTOList());
        jwtClaimsSetBuilder.claim("application", (Object)jwtTokenInfoDTO.getApplication());
        jwtClaimsSetBuilder.claim("keytype", (Object)jwtTokenInfoDTO.getKeyType());
        jwtClaimsSetBuilder.claim("token_type", (Object)"apiKey");
        if (jwtTokenInfoDTO.getPermittedIP() != null) {
            jwtClaimsSetBuilder.claim("permittedIP", (Object)jwtTokenInfoDTO.getPermittedIP());
        }
        if (jwtTokenInfoDTO.getPermittedReferer() != null) {
            jwtClaimsSetBuilder.claim("permittedReferer", (Object)jwtTokenInfoDTO.getPermittedReferer());
        }
        return jwtClaimsSetBuilder.build().toJSONObject().toJSONString();
    }

    static final /* synthetic */ String buildHeader_aroundBody4(DefaultApiKeyGenerator ajc$this, JoinPoint joinPoint) {
        JSONObject headerWithKid;
        try {
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)-1234);
            X509Certificate publicCert = tenantKSM.getDefaultPrimaryCertificate();
            String headerWithoutKid = APIUtil.generateHeader(publicCert, "SHA256withRSA");
            headerWithKid = new JSONObject(headerWithoutKid);
            headerWithKid.put("kid", (Object)APIUtil.getApiKeyAlias());
        }
        catch (Exception e) {
            throw new APIManagementException("Error while building Api key header", (Throwable)e);
        }
        return headerWithKid.toString();
    }

    static final /* synthetic */ byte[] buildSignature_aroundBody6(DefaultApiKeyGenerator ajc$this, String assertion, JoinPoint joinPoint) {
        PrivateKey privateKey = null;
        KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)-1234);
        try {
            ServerConfigurationService config = tenantKSM.getServerConfigService();
            String apiKeySignKeyStoreName = APIUtil.getApiKeySignKeyStoreName();
            String keyStorePassword = config.getFirstProperty("Security.KeyStoreName.KeyPassword".replaceFirst("KeyStoreName", apiKeySignKeyStoreName));
            String apiKeySignAlias = config.getFirstProperty("Security.KeyStoreName.KeyAlias".replaceFirst("KeyStoreName", apiKeySignKeyStoreName));
            KeyStore apiKeySignKeyStore = ajc$this.getApiKeySignKeyStore(tenantKSM);
            if (apiKeySignKeyStore != null) {
                privateKey = (PrivateKey)apiKeySignKeyStore.getKey(apiKeySignAlias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new APIManagementException("Error while signing Api Key", (Throwable)e);
        }
        return APIUtil.signJwt(assertion, privateKey, "SHA256withRSA");
    }

    static final /* synthetic */ KeyStore getApiKeySignKeyStore_aroundBody8(DefaultApiKeyGenerator ajc$this, KeyStoreManager keyStoreManager, JoinPoint joinPoint) {
        KeyStore apiKeySignKeyStore;
        String apiKeySignKeyStoreName;
        ServerConfigurationService config = keyStoreManager.getServerConfigService();
        if (config.getFirstProperty("Security.KeyStoreName.Location".replaceFirst("KeyStoreName", apiKeySignKeyStoreName = APIUtil.getApiKeySignKeyStoreName())) == null) {
            return null;
        }
        String file = new File(config.getFirstProperty("Security.KeyStoreName.Location".replaceFirst("KeyStoreName", apiKeySignKeyStoreName))).getAbsolutePath();
        KeyStore store = KeyStore.getInstance(config.getFirstProperty("Security.KeyStoreName.Type".replaceFirst("KeyStoreName", apiKeySignKeyStoreName)));
        String password = config.getFirstProperty("Security.KeyStoreName.Password".replaceFirst("KeyStoreName", apiKeySignKeyStoreName));
        Throwable throwable = null;
        Object var15_10 = null;
        try (FileInputStream in = new FileInputStream(file);){
            store.load(in, password.toCharArray());
            apiKeySignKeyStore = store;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return apiKeySignKeyStore;
    }

    static final /* synthetic */ String encode_aroundBody10(byte[] stringToBeEncoded, JoinPoint joinPoint) {
        try {
            return Base64.getUrlEncoder().encodeToString(stringToBeEncoded);
        }
        catch (Exception e) {
            throw new APIManagementException("Error while encoding the Api Key ", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultApiKeyGenerator.java", DefaultApiKeyGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateToken", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO", "jwtTokenInfoDTO", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildBody", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "org.wso2.carbon.apimgt.impl.dto.JwtTokenInfoDTO", "jwtTokenInfoDTO", "", "java.lang.String"), 74);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildHeader", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "buildSignature", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "java.lang.String", "assertion", "org.wso2.carbon.apimgt.api.APIManagementException", "[B"), 125);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiKeySignKeyStore", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "org.wso2.carbon.core.util.KeyStoreManager", "keyStoreManager", "java.lang.Exception", "java.security.KeyStore"), 150);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "encode", "org.wso2.carbon.apimgt.impl.token.DefaultApiKeyGenerator", "[B", "stringToBeEncoded", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 178);
    }
}

