/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.service;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.dto.KeyManagerConfigurationDTO;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.TokenHandlingDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.service.KeyMgtRegistrationService$AjcClosure1;

public final class KeyMgtRegistrationService {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        KeyMgtRegistrationService.ajc$preClinit();
        log = LogFactory.getLog(KeyMgtRegistrationService.class);
    }

    private KeyMgtRegistrationService() {
        throw new IllegalStateException("Service class for key manager registration");
    }

    public static void registerDefaultKeyManager(String tenantDomain) throws APIManagementException {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyMgtRegistrationService$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        KeyMgtRegistrationService.registerDefaultKeyManager_aroundBody0(string, joinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void registerDefaultKeyManager_aroundBody0(String tenantDomain, JoinPoint joinPoint) {
        String string = KeyMgtRegistrationService.class.getName().concat(tenantDomain);
        synchronized (string) {
            ApiMgtDAO instance = ApiMgtDAO.getInstance();
            if (instance.getKeyManagerConfigurationByName(tenantDomain, "Resident Key Manager") == null) {
                APIManagerConfigurationService apiManagerConfigurationService = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService();
                KeyManagerConfigurationDTO keyManagerConfigurationDTO = new KeyManagerConfigurationDTO();
                keyManagerConfigurationDTO.setName("Resident Key Manager");
                keyManagerConfigurationDTO.setEnabled(true);
                keyManagerConfigurationDTO.setUuid(UUID.randomUUID().toString());
                keyManagerConfigurationDTO.setTenantDomain(tenantDomain);
                keyManagerConfigurationDTO.setDescription("This is Resident Key Manager");
                if (apiManagerConfigurationService != null && apiManagerConfigurationService.getAPIManagerConfiguration() != null) {
                    String defaultKeyManagerType = apiManagerConfigurationService.getAPIManagerConfiguration().getFirstProperty("APIKeyValidator.DefaultKeyManagerType");
                    if (StringUtils.isNotEmpty((CharSequence)defaultKeyManagerType)) {
                        keyManagerConfigurationDTO.setType(defaultKeyManagerType);
                    } else {
                        keyManagerConfigurationDTO.setType("default");
                    }
                }
                TokenHandlingDto tokenHandlingDto = new TokenHandlingDto();
                tokenHandlingDto.setEnable(true);
                tokenHandlingDto.setType(TokenHandlingDto.TypeEnum.REFERENCE);
                tokenHandlingDto.setValue("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}");
                keyManagerConfigurationDTO.addProperty("token_format_string", (Object)new Gson().toJson(Arrays.asList(tokenHandlingDto)));
                instance.addKeyManagerConfiguration(keyManagerConfigurationDTO);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KeyMgtRegistrationService.java", KeyMgtRegistrationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "registerDefaultKeyManager", "org.wso2.carbon.apimgt.impl.service.KeyMgtRegistrationService", "java.lang.String", "tenantDomain", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 47);
    }
}

