/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.recommendationmgt;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.ApiTypeWrapper;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommendationEnvironment;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure1;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure11;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure13;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure15;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure17;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure19;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure21;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure23;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure25;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure3;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure5;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure7;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor$AjcClosure9;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderEventPublisher;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RecommenderDetailsExtractor
implements RecommenderEventPublisher {
    private static final Logger log;
    private static String streamID;
    private boolean tenantFlowStarted = false;
    protected ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
    private int applicationId;
    private API api;
    private String userName;
    private String searchQuery;
    private String tenantDomain;
    private String requestTenantDomain;
    private String publishingDetailType;
    private Application application;
    private ApiTypeWrapper clickedApi;
    private RecommendationEnvironment recommendationEnvironment = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getApiRecommendationEnvironment();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        RecommenderDetailsExtractor.ajc$preClinit();
        log = LoggerFactory.getLogger(RecommenderDetailsExtractor.class);
        streamID = "org.wso2.apimgt.recommendation.event.stream:1.0.0";
    }

    public RecommenderDetailsExtractor(API api, String tenantDomain, String eventType) {
        if ("ADD_API".equals(eventType)) {
            this.publishingDetailType = "ADD_API";
        } else if ("DELETE_API".equals(eventType)) {
            this.publishingDetailType = "DELETE_API";
        }
        this.api = api;
        this.tenantDomain = tenantDomain;
    }

    public RecommenderDetailsExtractor(Application application, String userName, int applicationId, String requestedTenant) {
        this.publishingDetailType = "ADD_APPLICATION";
        this.application = application;
        this.applicationId = applicationId;
        this.userName = userName;
        this.tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        this.requestTenantDomain = requestedTenant;
    }

    public RecommenderDetailsExtractor(Application application, String userName, String requestedTenant) {
        this.publishingDetailType = "UPDATED_APPLICATION";
        this.application = application;
        this.applicationId = application.getId();
        this.userName = userName;
        this.tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        this.requestTenantDomain = requestedTenant;
    }

    public RecommenderDetailsExtractor(int applicationId, String userName, String requestedTenant) {
        this.publishingDetailType = "DELETE_APPLICATION";
        this.applicationId = applicationId;
        this.userName = userName;
        this.tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        this.requestTenantDomain = requestedTenant;
    }

    public RecommenderDetailsExtractor(ApiTypeWrapper clickedApi, String userName, String requestedTenant) {
        this.publishingDetailType = "ADD_USER_CLICKED_API";
        this.clickedApi = clickedApi;
        this.userName = userName;
        this.tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        this.requestTenantDomain = requestedTenant;
    }

    public RecommenderDetailsExtractor(String searchQuery, String userName, String requestedTenant) {
        this.publishingDetailType = "ADD_USER_SEARCHED_QUERY";
        this.searchQuery = searchQuery;
        this.userName = userName;
        this.tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        this.requestTenantDomain = requestedTenant;
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.run_aroundBody0(this, joinPoint);
    }

    @Override
    public void publishAPIDetails(API api, String tenantDomain) throws IOException {
        API aPI = api;
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)aPI, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, aPI, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishAPIDetails_aroundBody2(this, aPI, string, joinPoint);
    }

    @Override
    public void publishApplicationDetails(Application application, String userName, int applicationId) {
        Application application2 = application;
        String string = userName;
        int n = applicationId;
        Object[] objectArray = new Object[]{application2, string, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, application2, string, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishApplicationDetails_aroundBody4(this, application2, string, n, joinPoint);
    }

    @Override
    public void publishDeletedApplication(int appId) {
        int n = appId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishDeletedApplication_aroundBody6(this, n, joinPoint);
    }

    @Override
    public void publishClickedApi(ApiTypeWrapper api, String userName) {
        ApiTypeWrapper apiTypeWrapper = api;
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)apiTypeWrapper, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, apiTypeWrapper, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishClickedApi_aroundBody8(this, apiTypeWrapper, string, joinPoint);
    }

    @Override
    public void publishSearchQueries(String query, String username) {
        String string = query;
        String string2 = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishSearchQueries_aroundBody10(this, string, string2, joinPoint);
    }

    public void publishEvent(String payload) {
        String string = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.publishEvent_aroundBody12(this, string, joinPoint);
    }

    private void endTenantFlow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.endTenantFlow_aroundBody14(this, joinPoint);
    }

    private void startTenantFlow(String tenantDomain) {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.startTenantFlow_aroundBody16(this, string, joinPoint);
    }

    private String getUserId(String userName) {
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RecommenderDetailsExtractor.getUserId_aroundBody18(this, string, joinPoint);
    }

    private String getDescriptionFromSwagger(JSONObject swaggerDef, String resource, String resourceMethod, String keyWord) {
        JSONObject jSONObject = swaggerDef;
        String string = resource;
        String string2 = resourceMethod;
        String string3 = keyWord;
        Object[] objectArray = new Object[]{jSONObject, string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, jSONObject, string, string2, string3, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return RecommenderDetailsExtractor.getDescriptionFromSwagger_aroundBody20(this, jSONObject, string, string2, string3, joinPoint);
    }

    public void updateRecommendationsCache(String userName, String tenantDomain) {
        String string = userName;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RecommenderDetailsExtractor.updateRecommendationsCache_aroundBody22(this, string, string2, joinPoint);
    }

    public String getRecommendations(String userName, String tenantDomain) {
        String string = userName;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new RecommenderDetailsExtractor$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RecommenderDetailsExtractor.getRecommendations_aroundBody24(this, string, string2, joinPoint);
    }

    static final /* synthetic */ void run_aroundBody0(RecommenderDetailsExtractor ajc$this, JoinPoint joinPoint) {
        if (ajc$this.tenantDomain == null) {
            ajc$this.tenantDomain = "carbon.super";
        }
        ajc$this.startTenantFlow(ajc$this.tenantDomain);
        ajc$this.tenantFlowStarted = true;
        try {
            try {
                if (APIUtil.isRecommendationEnabled(ajc$this.tenantDomain)) {
                    if ("ADD_API".equals(ajc$this.publishingDetailType) || "DELETE_API".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishAPIDetails(ajc$this.api, ajc$this.tenantDomain);
                    } else if ("ADD_APPLICATION".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishApplicationDetails(ajc$this.application, ajc$this.userName, ajc$this.applicationId);
                    } else if ("UPDATED_APPLICATION".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishApplicationDetails(ajc$this.application, ajc$this.userName, ajc$this.applicationId);
                    } else if ("DELETE_APPLICATION".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishDeletedApplication(ajc$this.applicationId);
                    } else if ("ADD_USER_CLICKED_API".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishClickedApi(ajc$this.clickedApi, ajc$this.userName);
                    } else if ("ADD_USER_SEARCHED_QUERY".equals(ajc$this.publishingDetailType)) {
                        ajc$this.publishSearchQueries(ajc$this.searchQuery, ajc$this.userName);
                    }
                    if (!"ADD_API".equals(ajc$this.publishingDetailType) && ajc$this.userName != null && !"wso2.anonymous.user".equals(ajc$this.userName) && ajc$this.requestTenantDomain != null) {
                        ajc$this.updateRecommendationsCache(ajc$this.userName, ajc$this.requestTenantDomain);
                    }
                }
            }
            catch (IOException e) {
                log.error("When extracting data for the recommendation system !", (Throwable)e);
                if (ajc$this.tenantFlowStarted) {
                    ajc$this.endTenantFlow();
                }
            }
        }
        finally {
            if (ajc$this.tenantFlowStarted) {
                ajc$this.endTenantFlow();
            }
        }
    }

    static final /* synthetic */ void publishAPIDetails_aroundBody2(RecommenderDetailsExtractor ajc$this, API api, String tenantDomain, JoinPoint joinPoint) {
        String apiName = api.getId().getApiName();
        String apiStatus = api.getStatus();
        String apiId = api.getUUID();
        if (apiStatus == null) {
            apiStatus = "DELETED";
        }
        if (apiStatus.equals("PUBLISHED") && "ADD_API".equals(ajc$this.publishingDetailType)) {
            String apiDescription = api.getDescription();
            String apiContext = api.getContext();
            String apiTags = api.getTags().toString();
            Set uriTemplates = api.getUriTemplates();
            JSONObject swaggerDef = null;
            if (api.getSwaggerDefinition() != null) {
                swaggerDef = new JSONObject(api.getSwaggerDefinition());
            }
            JSONArray resourceArray = new JSONArray();
            for (URITemplate uriTemplate : uriTemplates) {
                JSONObject resourceObj = new JSONObject();
                String resource = uriTemplate.getUriTemplate();
                String resourceMethod = uriTemplate.getHTTPVerb();
                resourceObj.put("resource", (Object)resource);
                if (swaggerDef != null) {
                    String summary = ajc$this.getDescriptionFromSwagger(swaggerDef, resource, resourceMethod, "summary");
                    String description = ajc$this.getDescriptionFromSwagger(swaggerDef, resource, resourceMethod, "description");
                    resourceObj.put("summary", (Object)summary);
                    resourceObj.put("description", (Object)description);
                }
                resourceArray.put((Object)resourceObj);
            }
            JSONObject obj = new JSONObject();
            obj.put("api_id", (Object)apiId);
            obj.put("api_name", (Object)apiName);
            obj.put("description", (Object)apiDescription);
            obj.put("context", (Object)apiContext);
            obj.put("tenant", (Object)tenantDomain);
            obj.put("tags", (Object)apiTags);
            obj.put("resources", (Object)resourceArray);
            JSONObject payload = new JSONObject();
            payload.put("action", (Object)"ADD_API");
            payload.put("payload", (Object)obj);
            ajc$this.publishEvent(payload.toString());
            log.info("Add API event for " + apiName + " API was published to the recommendation server");
        } else {
            JSONObject obj = new JSONObject();
            obj.put("api_name", (Object)apiName);
            obj.put("tenant", (Object)tenantDomain);
            JSONObject payload = new JSONObject();
            payload.put("action", (Object)"DELETE_API");
            payload.put("payload", (Object)obj);
            ajc$this.publishEvent(payload.toString());
            log.info("Delete API event for " + apiName + " API was published to the recommendation server");
        }
    }

    static final /* synthetic */ void publishApplicationDetails_aroundBody4(RecommenderDetailsExtractor ajc$this, Application application, String userName, int applicationId, JoinPoint joinPoint) {
        String appName = application.getName();
        String appDescription = application.getDescription();
        String userID = ajc$this.getUserId(userName);
        JSONObject obj = new JSONObject();
        obj.put("user", (Object)userID);
        obj.put("application_id", applicationId);
        obj.put("application_name", (Object)appName);
        obj.put("application_description", (Object)appDescription);
        JSONObject payload = new JSONObject();
        payload.put("action", (Object)"ADD_APPLICATION");
        payload.put("payload", (Object)obj);
        ajc$this.publishEvent(payload.toString());
        log.info("Add Application event for " + appName + " application was published to the recommendation server");
    }

    static final /* synthetic */ void publishDeletedApplication_aroundBody6(RecommenderDetailsExtractor ajc$this, int appId, JoinPoint joinPoint) {
        JSONObject obj = new JSONObject();
        obj.put("appid", appId);
        JSONObject payload = new JSONObject();
        payload.put("action", (Object)"DELETE_APPLICATION");
        payload.put("payload", (Object)obj);
        ajc$this.publishEvent(payload.toString());
        log.info("Delete Application event for Application id " + appId + " was sent to recommendations server");
    }

    static final /* synthetic */ void publishClickedApi_aroundBody8(RecommenderDetailsExtractor ajc$this, ApiTypeWrapper api, String userName, JoinPoint joinPoint) {
        if (userName == null) {
            log.error("Username cannot be null");
            return;
        }
        if (!"wso2.anonymous.user".equals(userName)) {
            String userID = ajc$this.getUserId(userName);
            String apiName = api.getName();
            JSONObject obj = new JSONObject();
            obj.put("user", (Object)userID);
            obj.put("api_name", (Object)apiName);
            JSONObject payload = new JSONObject();
            payload.put("action", (Object)"ADD_USER_CLICKED_API");
            payload.put("payload", (Object)obj);
            ajc$this.publishEvent(payload.toString());
            if (log.isDebugEnabled()) {
                log.debug("User clicked API event was published for recommendation server with payload " + payload);
            }
        }
    }

    static final /* synthetic */ void publishSearchQueries_aroundBody10(RecommenderDetailsExtractor ajc$this, String query, String username, JoinPoint joinPoint) {
        if (username == null) {
            log.error("Username cannot be null");
            return;
        }
        if (!"wso2.anonymous.user".equals(ajc$this.userName)) {
            String userID = ajc$this.getUserId(ajc$this.userName);
            query = query.split("&", 2)[0];
            JSONObject obj = new JSONObject();
            obj.put("user", (Object)userID);
            obj.put("search_query", (Object)query);
            JSONObject payload = new JSONObject();
            payload.put("action", (Object)"ADD_USER_SEARCHED_QUERY");
            payload.put("payload", (Object)obj);
            ajc$this.publishEvent(payload.toString());
            if (log.isDebugEnabled()) {
                log.debug("User searched query event was published for recommendation server with payload " + payload);
            }
        }
    }

    static final /* synthetic */ void publishEvent_aroundBody12(RecommenderDetailsExtractor ajc$this, String payload, JoinPoint joinPoint) {
        Object[] objects = new Object[]{payload};
        Event event = new Event(streamID, System.currentTimeMillis(), null, null, objects);
        APIUtil.publishEvent("recommendationEventPublisher", Collections.EMPTY_MAP, event);
        if (log.isDebugEnabled()) {
            log.debug("Event Published for recommendation server with payload " + payload);
        }
    }

    static final /* synthetic */ void endTenantFlow_aroundBody14(RecommenderDetailsExtractor ajc$this, JoinPoint joinPoint) {
        PrivilegedCarbonContext.endTenantFlow();
    }

    static final /* synthetic */ void startTenantFlow_aroundBody16(RecommenderDetailsExtractor ajc$this, String tenantDomain, JoinPoint joinPoint) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
    }

    static final /* synthetic */ String getUserId_aroundBody18(RecommenderDetailsExtractor ajc$this, String userName, JoinPoint joinPoint) {
        String userID = null;
        try {
            userID = ajc$this.apiMgtDAO.getUserID(userName);
        }
        catch (APIManagementException e) {
            log.error("Error occurred when getting the userID for user " + userName, (Throwable)e);
        }
        return userID;
    }

    static final /* synthetic */ String getDescriptionFromSwagger_aroundBody20(RecommenderDetailsExtractor ajc$this, JSONObject swaggerDef, String resource, String resourceMethod, String keyWord, JoinPoint joinPoint) {
        String description = null;
        try {
            description = (String)swaggerDef.getJSONObject("paths").getJSONObject(resource).getJSONObject(resourceMethod.toLowerCase()).get(keyWord);
        }
        catch (JSONException jSONException) {
            log.debug(String.valueOf(keyWord) + " is not found for " + resource);
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void updateRecommendationsCache_aroundBody22(RecommenderDetailsExtractor ajc$this, String userName, String tenantDomain, JoinPoint joinPoint) {
        String cacheName;
        long currentTime = System.currentTimeMillis();
        long lastUpdatedTime = 0L;
        long waitDuration = ajc$this.recommendationEnvironment.getWaitDuration() * 60L * 1000L;
        Cache recommendationsCache = CacheProvider.getRecommendationsCache();
        JSONObject cachedObject = (JSONObject)recommendationsCache.get((Object)(cacheName = String.valueOf(userName) + "_" + tenantDomain));
        if (cachedObject != null) {
            lastUpdatedTime = (Long)cachedObject.get("LastUpdated");
        }
        if (currentTime - lastUpdatedTime < waitDuration) {
            return;
        }
        Class<RecommenderDetailsExtractor> clazz = RecommenderDetailsExtractor.class;
        synchronized (RecommenderDetailsExtractor.class) {
            if (currentTime - lastUpdatedTime < waitDuration) {
                // ** MonitorExit[var16_10] (shouldn't be in output)
                return;
            }
            String recommendations = ajc$this.getRecommendations(userName, tenantDomain);
            JSONObject object = new JSONObject();
            object.put("Recommendations", (Object)recommendations);
            object.put("LastUpdated", System.currentTimeMillis());
            recommendationsCache.put((Object)cacheName, (Object)object);
            // ** MonitorExit[var16_10] (shouldn't be in output)
            return;
        }
    }

    static final /* synthetic */ String getRecommendations_aroundBody24(RecommenderDetailsExtractor ajc$this, String userName, String tenantDomain, JoinPoint joinPoint) {
        String recommendationEndpointURL = String.valueOf(ajc$this.recommendationEnvironment.getRecommendationServerURL()) + "/getRecommendations";
        AccessTokenGenerator accessTokenGenerator = ServiceReferenceHolder.getInstance().getAccessTokenGenerator();
        try {
            String userID = ajc$this.apiMgtDAO.getUserID(userName);
            URL serverURL = new URL(recommendationEndpointURL);
            int serverPort = serverURL.getPort();
            String serverProtocol = serverURL.getProtocol();
            HttpGet method = new HttpGet(recommendationEndpointURL);
            HttpClient httpClient = APIUtil.getHttpClient(serverPort, serverProtocol);
            if (ajc$this.recommendationEnvironment.getOauthURL() != null) {
                String accessToken = accessTokenGenerator.getAccessToken();
                method.setHeader("Authorization", "Bearer " + accessToken);
            } else {
                byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.recommendationEnvironment.getUserName()) + ":" + ajc$this.recommendationEnvironment.getPassword()).getBytes(StandardCharsets.UTF_8));
                method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            }
            method.setHeader("User", userID);
            method.setHeader("Account", tenantDomain);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                log.info("Recommendations received for the user " + userName + " from recommendations server");
                String contentString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                if (log.isDebugEnabled()) {
                    log.debug("Recommendations received for user " + userName + " is " + contentString);
                }
                return contentString;
            }
            if (httpResponse.getStatusLine().getStatusCode() == 401 && accessTokenGenerator != null) {
                log.warn("Error getting recommendations from server. Invalid credentials used");
                accessTokenGenerator.removeInvalidToken(new String[]{"default"});
            } else {
                log.warn("Error getting recommendations from server. Server responded with " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (IOException e) {
            log.error("Connection failure for the recommendation engine", (Throwable)e);
        }
        catch (APIManagementException e) {
            log.error("Error while getting recommendations for user " + userName, (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RecommenderDetailsExtractor.java", RecommenderDetailsExtractor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "", "", "", "void"), 131);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishAPIDetails", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "org.wso2.carbon.apimgt.api.model.API:java.lang.String", "api:tenantDomain", "java.io.IOException", "void"), 170);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDescriptionFromSwagger", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "org.json.JSONObject:java.lang.String:java.lang.String:java.lang.String", "swaggerDef:resource:resourceMethod:keyWord", "", "java.lang.String"), 346);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRecommendationsCache", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String:java.lang.String", "userName:tenantDomain", "", "void"), 366);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRecommendations", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String:java.lang.String", "userName:tenantDomain", "", "java.lang.String"), 393);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishApplicationDetails", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "org.wso2.carbon.apimgt.api.model.Application:java.lang.String:int", "application:userName:applicationId", "", "void"), 233);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishDeletedApplication", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "int", "appId", "", "void"), 253);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishClickedApi", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "org.wso2.carbon.apimgt.api.model.ApiTypeWrapper:java.lang.String", "api:userName", "", "void"), 266);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishSearchQueries", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String:java.lang.String", "query:username", "", "void"), 290);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishEvent", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String", "payload", "", "void"), 313);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "endTenantFlow", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "", "", "", "void"), 323);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "startTenantFlow", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String", "tenantDomain", "", "void"), 328);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserId", "org.wso2.carbon.apimgt.impl.recommendationmgt.RecommenderDetailsExtractor", "java.lang.String", "userName", "", "java.lang.String"), 335);
    }
}

