/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.recommendationmgt;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure11;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure13;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure7;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator$AjcClosure9;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class AccessTokenGenerator {
    private static final Log log;
    private String oauthUrl;
    private String consumerKey;
    private String consumerSecret;
    private String tokenEndpoint;
    private String revokeEndpoint;
    private Map<String, AccessTokenInfo> accessTokenInfoMap = new ConcurrentHashMap<String, AccessTokenInfo>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        AccessTokenGenerator.ajc$preClinit();
        log = LogFactory.getLog(AccessTokenGenerator.class);
    }

    public AccessTokenGenerator(String oauthUrl, String consumerKey, String consumerSecret) {
        this.oauthUrl = oauthUrl;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public AccessTokenGenerator(String tokenEndpoint, String revokeEndpoint, String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.tokenEndpoint = tokenEndpoint;
        this.revokeEndpoint = revokeEndpoint;
    }

    public String getAccessToken(String[] scopes) {
        String[] stringArray = scopes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, stringArray, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AccessTokenGenerator.getAccessToken_aroundBody0(this, stringArray, joinPoint);
    }

    private void revokeAccessToken(String accessToken) {
        String string = accessToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AccessTokenGenerator.revokeAccessToken_aroundBody2(this, string, joinPoint);
    }

    private AccessTokenInfo generateNewAccessToken(String[] scopes) {
        String[] stringArray = scopes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)stringArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, stringArray, joinPoint};
            return (AccessTokenInfo)MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AccessTokenGenerator.generateNewAccessToken_aroundBody4(this, stringArray, joinPoint);
    }

    public void setOauthUrl(String oauthUrl) {
        String string = oauthUrl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.oauthUrl = string;
    }

    public void removeInvalidToken(String[] scopes) {
        String[] stringArray = scopes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)stringArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, stringArray, joinPoint};
            MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AccessTokenGenerator.removeInvalidToken_aroundBody8(this, stringArray, joinPoint);
    }

    private String getScopeHash(String[] scopes) {
        String[] stringArray = scopes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)stringArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, stringArray, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AccessTokenGenerator.getScopeHash_aroundBody10(this, stringArray, joinPoint);
    }

    public String getAccessToken() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AccessTokenGenerator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.getAccessToken(new String[]{"default"});
    }

    /*
     * Enabled aggressive block sorting
     */
    static final /* synthetic */ String getAccessToken_aroundBody0(AccessTokenGenerator ajc$this, String[] scopes, JoinPoint joinPoint) {
        AccessTokenInfo accessTokenInfo;
        String scopeHash;
        block8: {
            block9: {
                scopeHash = ajc$this.getScopeHash(scopes);
                accessTokenInfo = ajc$this.accessTokenInfoMap.get(scopeHash);
                if (accessTokenInfo == null) break block9;
                long expiryTime = accessTokenInfo.getIssuedTime() + accessTokenInfo.getValidityPeriod();
                long buffer = 20000L;
                if (System.currentTimeMillis() > expiryTime) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Access token expired. New token requested");
                    }
                    ajc$this.accessTokenInfoMap.remove(scopeHash);
                    accessTokenInfo = ajc$this.generateNewAccessToken(scopes);
                    ajc$this.accessTokenInfoMap.put(scopeHash, accessTokenInfo);
                    break block8;
                } else if (buffer > expiryTime - System.currentTimeMillis()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Access Token will expire soon. Generated a new Token after revoking the previous");
                    }
                    ajc$this.revokeAccessToken(accessTokenInfo.getAccessToken());
                    ajc$this.accessTokenInfoMap.remove(scopeHash);
                    accessTokenInfo = ajc$this.generateNewAccessToken(scopes);
                    ajc$this.accessTokenInfoMap.put(scopeHash, accessTokenInfo);
                    break block8;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Valid Access Token already available for the provided application");
                    }
                    return accessTokenInfo.getAccessToken();
                }
            }
            accessTokenInfo = ajc$this.generateNewAccessToken(scopes);
        }
        if (accessTokenInfo != null) {
            ajc$this.accessTokenInfoMap.put(scopeHash, accessTokenInfo);
            return accessTokenInfo.getAccessToken();
        }
        return null;
    }

    static final /* synthetic */ void revokeAccessToken_aroundBody2(AccessTokenGenerator ajc$this, String accessToken, JoinPoint joinPoint) {
        try {
            int serverPort;
            URL oauthURL;
            String revokeEndpoint;
            if (StringUtils.isNotEmpty((CharSequence)ajc$this.revokeEndpoint)) {
                revokeEndpoint = ajc$this.revokeEndpoint;
                oauthURL = new URL(revokeEndpoint);
                serverPort = oauthURL.getPort();
            } else {
                oauthURL = new URL(ajc$this.oauthUrl);
                revokeEndpoint = ajc$this.oauthUrl.concat("/revoke");
                serverPort = oauthURL.getPort();
            }
            String serverProtocol = oauthURL.getProtocol();
            HttpPost request = new HttpPost(revokeEndpoint);
            HttpClient httpClient = APIUtil.getHttpClient(serverPort, serverProtocol);
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.consumerKey) + ":" + ajc$this.consumerSecret).getBytes(StandardCharsets.UTF_8));
            request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("token", accessToken));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully revoked the token");
                }
            } else {
                log.error((Object)("Error occurred when revoking the Access token. Server responded with " + httpResponse.getStatusLine().getStatusCode()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occurred when revoking the Access token", (Throwable)e);
        }
    }

    static final /* synthetic */ AccessTokenInfo generateNewAccessToken_aroundBody4(AccessTokenGenerator ajc$this, String[] scopes, JoinPoint joinPoint) {
        try {
            int serverPort;
            URL oauthURL;
            String tokenEndpoint;
            if (StringUtils.isNotEmpty((CharSequence)ajc$this.tokenEndpoint)) {
                tokenEndpoint = ajc$this.tokenEndpoint;
                oauthURL = new URL(tokenEndpoint);
                serverPort = oauthURL.getPort();
            } else {
                oauthURL = new URL(ajc$this.oauthUrl);
                serverPort = oauthURL.getPort();
                tokenEndpoint = ajc$this.oauthUrl.concat("/token");
            }
            String serverProtocol = oauthURL.getProtocol();
            HttpPost request = new HttpPost(tokenEndpoint);
            HttpClient httpClient = APIUtil.getHttpClient(serverPort, serverProtocol);
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.consumerKey) + ":" + ajc$this.consumerSecret).getBytes(StandardCharsets.UTF_8));
            request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
            if (scopes != null && scopes.length > 0) {
                urlParameters.add(new BasicNameValuePair("scope", String.join((CharSequence)" ", scopes)));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                String payload = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                JSONObject response = new JSONObject(payload);
                String accessToken = (String)response.get("access_token");
                int validityPeriod = (Integer)response.get("expires_in") * 1000;
                long expiryTime = System.currentTimeMillis() + (long)validityPeriod;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully received an access token which expires in " + expiryTime));
                }
                AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
                accessTokenInfo.setAccessToken(accessToken);
                accessTokenInfo.setIssuedTime(System.currentTimeMillis());
                accessTokenInfo.setValidityPeriod((long)validityPeriod);
                return accessTokenInfo;
            }
            log.error((Object)("Error occurred when generating a new Access token. Server responded with " + httpResponse.getStatusLine().getStatusCode()));
        }
        catch (IOException e) {
            log.error((Object)"Error occurred when generating a new Access token", (Throwable)e);
        }
        return null;
    }

    static final /* synthetic */ void removeInvalidToken_aroundBody8(AccessTokenGenerator ajc$this, String[] scopes, JoinPoint joinPoint) {
        String scopeHash = ajc$this.getScopeHash(scopes);
        ajc$this.accessTokenInfoMap.remove(scopeHash);
    }

    static final /* synthetic */ String getScopeHash_aroundBody10(AccessTokenGenerator ajc$this, String[] scopes, JoinPoint joinPoint) {
        Arrays.sort((Object[])scopes);
        return DigestUtils.md5Hex((String)String.join((CharSequence)" ", scopes));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccessTokenGenerator.java", AccessTokenGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessToken", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "[Ljava.lang.String;", "scopes", "", "java.lang.String"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "revokeAccessToken", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "java.lang.String", "accessToken", "", "void"), 111);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateNewAccessToken", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "[Ljava.lang.String;", "scopes", "", "org.wso2.carbon.apimgt.api.model.AccessTokenInfo"), 157);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOauthUrl", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "java.lang.String", "oauthUrl", "", "void"), 219);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeInvalidToken", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "[Ljava.lang.String;", "scopes", "", "void"), 224);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getScopeHash", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "[Ljava.lang.String;", "scopes", "", "java.lang.String"), 229);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessToken", "org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator", "", "", "", "java.lang.String"), 234);
    }
}

