/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.loader;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.loader.KeyManagerConfigurationDataRetriever$AjcClosure1;
import org.wso2.carbon.apimgt.impl.loader.KeyManagerConfigurationDataRetriever$AjcClosure3;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class KeyManagerConfigurationDataRetriever
extends TimerTask {
    private Log log = LogFactory.getLog(KeyManagerConfigurationDataRetriever.class);
    private String tenantDomain;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public KeyManagerConfigurationDataRetriever(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerConfigurationDataRetriever$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        KeyManagerConfigurationDataRetriever.run_aroundBody0(this, joinPoint);
    }

    public void startLoadKeyManagerConfigurations() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerConfigurationDataRetriever$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        KeyManagerConfigurationDataRetriever.startLoadKeyManagerConfigurations_aroundBody2(this, joinPoint);
    }

    static {
        KeyManagerConfigurationDataRetriever.ajc$preClinit();
    }

    static final /* synthetic */ void run_aroundBody0(KeyManagerConfigurationDataRetriever ajc$this, JoinPoint joinPoint) {
        EventHubConfigurationDto eventHubConfigurationDto;
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        if (apiManagerConfiguration != null && (eventHubConfigurationDto = apiManagerConfiguration.getEventHubConfigurationDto()) != null && eventHubConfigurationDto.isEnabled()) {
            try {
                boolean retry;
                String url = eventHubConfigurationDto.getServiceUrl().concat("/internal/data/v1").concat("/keymanagers");
                byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(eventHubConfigurationDto.getUsername()) + ":" + eventHubConfigurationDto.getPassword()).getBytes());
                HttpGet method = new HttpGet(url);
                method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
                method.setHeader("xWSO2Tenant", ajc$this.tenantDomain);
                URL configUrl = new URL(url);
                int port = configUrl.getPort();
                String protocol = configUrl.getProtocol();
                HttpClient httpClient = APIUtil.getHttpClient(port, protocol);
                HttpResponse httpResponse = null;
                int retryCount = 0;
                do {
                    try {
                        httpResponse = httpClient.execute((HttpUriRequest)method);
                        if (httpResponse.getStatusLine().getStatusCode() == 200) {
                            KeyManagerConfiguration[] keyManagerConfigurations;
                            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                            KeyManagerConfiguration[] keyManagerConfigurationArray = keyManagerConfigurations = (KeyManagerConfiguration[])new Gson().fromJson(responseString, KeyManagerConfiguration[].class);
                            int n = keyManagerConfigurations.length;
                            int n2 = 0;
                            while (n2 < n) {
                                KeyManagerConfiguration keyManagerConfiguration = keyManagerConfigurationArray[n2];
                                if (keyManagerConfiguration.isEnabled()) {
                                    try {
                                        ServiceReferenceHolder.getInstance().getKeyManagerConfigurationService().addKeyManagerConfiguration(keyManagerConfiguration.getTenantDomain(), keyManagerConfiguration.getName(), keyManagerConfiguration.getType(), keyManagerConfiguration);
                                    }
                                    catch (APIManagementException e) {
                                        ajc$this.log.error((Object)("Error while configuring Key Manager " + keyManagerConfiguration.getName() + " in tenant " + keyManagerConfiguration.getTenantDomain()), (Throwable)e);
                                    }
                                }
                                ++n2;
                            }
                            retry = false;
                            continue;
                        }
                        retry = true;
                        ++retryCount;
                    }
                    catch (IOException ex) {
                        int maxRetries = 15;
                        if (++retryCount < maxRetries) {
                            retry = true;
                            long retryTimeout = 15L;
                            ajc$this.log.warn((Object)("Failed retrieving Key Manager Configurations from remote endpoint: " + ex.getMessage() + ". Retrying after " + retryTimeout + " seconds..."));
                            Thread.sleep(retryTimeout * 1000L);
                            continue;
                        }
                        throw ex;
                    }
                } while (retry);
            }
            catch (IOException | InterruptedException e) {
                ajc$this.log.error((Object)"Error while retrieving key manager configurations", (Throwable)e);
            }
        }
    }

    static final /* synthetic */ void startLoadKeyManagerConfigurations_aroundBody2(KeyManagerConfigurationDataRetriever ajc$this, JoinPoint joinPoint) {
        new Timer().schedule((TimerTask)ajc$this, 5L);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KeyManagerConfigurationDataRetriever.java", KeyManagerConfigurationDataRetriever.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.wso2.carbon.apimgt.impl.loader.KeyManagerConfigurationDataRetriever", "", "", "", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "startLoadKeyManagerConfigurations", "org.wso2.carbon.apimgt.impl.loader.KeyManagerConfigurationDataRetriever", "", "", "", "void"), 110);
    }
}

