/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.carbon.apimgt.common.gateway.dto.TokenIssuerDto;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.DefaultJWTTransformer;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.JWTTransformer;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidator;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure1;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure11;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure13;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure15;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure17;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure19;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure21;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure23;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure3;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure5;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure7;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl$AjcClosure9;
import org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo;
import org.wso2.carbon.apimgt.impl.utils.JWTUtil;

public class JWTValidatorImpl
implements JWTValidator {
    TokenIssuerDto tokenIssuer;
    private Log log = LogFactory.getLog(JWTValidatorImpl.class);
    JWTTransformer jwtTransformer;
    private JWKSet jwkSet;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    @Override
    public JWTValidationInfo validateToken(SignedJWTInfo signedJWTInfo) throws APIManagementException {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)signedJWTInfo2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWTInfo2, joinPoint};
            return (JWTValidationInfo)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidatorImpl.validateToken_aroundBody0(this, signedJWTInfo2, joinPoint);
    }

    private boolean isValidCertificateBoundAccessToken(SignedJWTInfo signedJWTInfo) {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)signedJWTInfo2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWTInfo2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidatorImpl.isValidCertificateBoundAccessToken_aroundBody2(this, signedJWTInfo2, joinPoint);
    }

    private boolean isCertificateBoundAccessTokenEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidatorImpl.isCertificateBoundAccessTokenEnabled_aroundBody4(this, joinPoint);
    }

    @Override
    public void loadTokenIssuerConfiguration(TokenIssuerDto tokenIssuerConfigurations) {
        TokenIssuerDto tokenIssuerDto = tokenIssuerConfigurations;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)tokenIssuerDto);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, tokenIssuerDto, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidatorImpl.loadTokenIssuerConfiguration_aroundBody6(this, tokenIssuerDto, joinPoint);
    }

    protected boolean validateSignature(SignedJWT signedJWT) throws APIManagementException {
        SignedJWT signedJWT2 = signedJWT;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)signedJWT2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWT2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidatorImpl.validateSignature_aroundBody8(this, signedJWT2, joinPoint);
    }

    protected boolean validateTokenExpiry(JWTClaimsSet jwtClaimsSet) {
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidatorImpl.validateTokenExpiry_aroundBody10(this, jWTClaimsSet, joinPoint);
    }

    protected JWTClaimsSet transformJWTClaims(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return (JWTClaimsSet)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.jwtTransformer.transform(jWTClaimsSet);
    }

    protected String getConsumerKey(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.jwtTransformer.getTransformedConsumerKey(jWTClaimsSet);
    }

    protected List<String> getScopes(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.jwtTransformer.getTransformedScopes(jWTClaimsSet);
    }

    protected Boolean getIsAppToken(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return (Boolean)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.jwtTransformer.getTransformedIsAppTokenType(jWTClaimsSet);
    }

    private void createJWTValidationInfoFromJWT(JWTValidationInfo jwtValidationInfo, JWTClaimsSet jwtClaimsSet) throws ParseException {
        JWTValidationInfo jWTValidationInfo = jwtValidationInfo;
        JWTClaimsSet jWTClaimsSet = jwtClaimsSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)jWTValidationInfo, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, jWTValidationInfo, jWTClaimsSet, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidatorImpl.createJWTValidationInfoFromJWT_aroundBody20(this, jWTValidationInfo, jWTClaimsSet, joinPoint);
    }

    private JWKSet retrieveJWKSet() throws IOException, ParseException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (JWKSet)MethodTimeLogger.aspectOf().log(new JWTValidatorImpl$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidatorImpl.retrieveJWKSet_aroundBody22(this, joinPoint);
    }

    static {
        JWTValidatorImpl.ajc$preClinit();
    }

    static final /* synthetic */ JWTValidationInfo validateToken_aroundBody0(JWTValidatorImpl ajc$this, SignedJWTInfo signedJWTInfo, JoinPoint joinPoint) {
        JWTValidationInfo jwtValidationInfo = new JWTValidationInfo();
        try {
            boolean state = ajc$this.validateSignature(signedJWTInfo.getSignedJWT());
            if (state) {
                JWTClaimsSet jwtClaimsSet = signedJWTInfo.getJwtClaimsSet();
                state = ajc$this.isValidCertificateBoundAccessToken(signedJWTInfo);
                if (state) {
                    state = ajc$this.validateTokenExpiry(jwtClaimsSet);
                    if (state) {
                        jwtValidationInfo.setConsumerKey(ajc$this.getConsumerKey(jwtClaimsSet));
                        jwtValidationInfo.setScopes(ajc$this.getScopes(jwtClaimsSet));
                        jwtValidationInfo.setAppToken(ajc$this.getIsAppToken(jwtClaimsSet));
                        JWTClaimsSet transformedJWTClaimSet = ajc$this.transformJWTClaims(jwtClaimsSet);
                        ajc$this.createJWTValidationInfoFromJWT(jwtValidationInfo, transformedJWTClaimSet);
                        jwtValidationInfo.setRawPayload(signedJWTInfo.getToken());
                        return jwtValidationInfo;
                    }
                    jwtValidationInfo.setValid(false);
                    jwtValidationInfo.setValidationCode(900901);
                    return jwtValidationInfo;
                }
                jwtValidationInfo.setValid(false);
                jwtValidationInfo.setValidationCode(900901);
                return jwtValidationInfo;
            }
            jwtValidationInfo.setValid(false);
            jwtValidationInfo.setValidationCode(900901);
            return jwtValidationInfo;
        }
        catch (ParseException | JWTGeneratorException e) {
            throw new APIManagementException("Error while parsing JWT", e);
        }
    }

    static final /* synthetic */ boolean isValidCertificateBoundAccessToken_aroundBody2(JWTValidatorImpl ajc$this, SignedJWTInfo signedJWTInfo, JoinPoint joinPoint) {
        if (ajc$this.isCertificateBoundAccessTokenEnabled()) {
            if (signedJWTInfo.getX509ClientCertificate() == null || StringUtils.isEmpty((String)signedJWTInfo.getX509ClientCertificateHash())) {
                return true;
            }
            return signedJWTInfo.getX509ClientCertificateHash().equals(signedJWTInfo.getCertificateThumbprint());
        }
        return true;
    }

    static final /* synthetic */ boolean isCertificateBoundAccessTokenEnabled_aroundBody4(JWTValidatorImpl ajc$this, JoinPoint joinPoint) {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        if (config != null) {
            String firstProperty = config.getFirstProperty("OAuthConfigurations.EnableCertificateBoundAccessToken");
            return Boolean.parseBoolean(firstProperty);
        }
        return false;
    }

    static final /* synthetic */ void loadTokenIssuerConfiguration_aroundBody6(JWTValidatorImpl ajc$this, TokenIssuerDto tokenIssuerConfigurations, JoinPoint joinPoint) {
        ajc$this.tokenIssuer = tokenIssuerConfigurations;
        JWTTransformer jwtTransformer = ServiceReferenceHolder.getInstance().getJWTTransformer(ajc$this.tokenIssuer.getIssuer());
        ajc$this.jwtTransformer = jwtTransformer != null ? jwtTransformer : new DefaultJWTTransformer();
        ajc$this.jwtTransformer.loadConfiguration(ajc$this.tokenIssuer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final /* synthetic */ boolean validateSignature_aroundBody8(JWTValidatorImpl ajc$this, SignedJWT signedJWT, JoinPoint joinPoint) {
        String keyID;
        block6: {
            String certificateAlias = "gateway_certificate_alias";
            keyID = signedJWT.getHeader().getKeyID();
            if (!StringUtils.isNotEmpty((String)keyID)) return JWTUtil.verifyTokenSignature(signedJWT, certificateAlias);
            if (!ajc$this.tokenIssuer.getJwksConfigurationDTO().isEnabled() || !StringUtils.isNotEmpty((String)ajc$this.tokenIssuer.getJwksConfigurationDTO().getUrl())) break block6;
            if (ajc$this.jwkSet == null) {
                ajc$this.jwkSet = ajc$this.retrieveJWKSet();
            }
            if (ajc$this.jwkSet.getKeyByKeyId(keyID) == null) {
                ajc$this.jwkSet = ajc$this.retrieveJWKSet();
            }
            if (ajc$this.jwkSet.getKeyByKeyId(keyID) instanceof RSAKey) {
                RSAKey keyByKeyId = (RSAKey)ajc$this.jwkSet.getKeyByKeyId(keyID);
                RSAPublicKey rsaPublicKey = keyByKeyId.toRSAPublicKey();
                if (rsaPublicKey == null) return JWTUtil.verifyTokenSignature(signedJWT, certificateAlias);
                return JWTUtil.verifyTokenSignature(signedJWT, rsaPublicKey);
            }
            if (!ajc$this.log.isDebugEnabled()) return false;
            ajc$this.log.debug((Object)"Key Algorithm not supported");
            return false;
        }
        try {
            if (ajc$this.tokenIssuer.getCertificate() == null) return JWTUtil.verifyTokenSignature(signedJWT, keyID);
            ajc$this.log.debug((Object)"Retrieve certificate from Token issuer and validating");
            RSAPublicKey rsaPublicKey = (RSAPublicKey)ajc$this.tokenIssuer.getCertificate().getPublicKey();
            return JWTUtil.verifyTokenSignature(signedJWT, rsaPublicKey);
        }
        catch (JOSEException | IOException | ParseException e) {
            ajc$this.log.error((Object)"Error while parsing JWT", e);
            return true;
        }
    }

    static final /* synthetic */ boolean validateTokenExpiry_aroundBody10(JWTValidatorImpl ajc$this, JWTClaimsSet jwtClaimsSet, JoinPoint joinPoint) {
        long timestampSkew = ServiceReferenceHolder.getInstance().getOauthServerConfiguration().getTimeStampSkewInSeconds();
        Date now = new Date();
        Date exp = jwtClaimsSet.getExpirationTime();
        return exp == null || DateUtils.isAfter((Date)exp, (Date)now, (long)timestampSkew);
    }

    static final /* synthetic */ void createJWTValidationInfoFromJWT_aroundBody20(JWTValidatorImpl ajc$this, JWTValidationInfo jwtValidationInfo, JWTClaimsSet jwtClaimsSet, JoinPoint joinPoint) {
        jwtValidationInfo.setIssuer(jwtClaimsSet.getIssuer());
        jwtValidationInfo.setValid(true);
        jwtValidationInfo.setClaims(jwtClaimsSet.getClaims());
        if (jwtClaimsSet.getExpirationTime() != null) {
            jwtValidationInfo.setExpiryTime(jwtClaimsSet.getExpirationTime().getTime());
        }
        if (jwtClaimsSet.getIssueTime() != null) {
            jwtValidationInfo.setIssuedTime(jwtClaimsSet.getIssueTime().getTime());
        }
        jwtValidationInfo.setUser(jwtClaimsSet.getSubject());
        jwtValidationInfo.setJti(jwtClaimsSet.getJWTID());
        if (jwtClaimsSet.getClaim("scope") != null) {
            jwtValidationInfo.setScopes(Arrays.asList(jwtClaimsSet.getStringClaim("scope").split(" ")));
        }
    }

    static final /* synthetic */ JWKSet retrieveJWKSet_aroundBody22(JWTValidatorImpl ajc$this, JoinPoint joinPoint) {
        String jwksInfo = JWTUtil.retrieveJWKSConfiguration(ajc$this.tokenIssuer.getJwksConfigurationDTO().getUrl());
        ajc$this.jwkSet = JWKSet.parse((String)jwksInfo);
        return ajc$this.jwkSet;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JWTValidatorImpl.java", JWTValidatorImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateToken", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo", "signedJWTInfo", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isValidCertificateBoundAccessToken", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo", "signedJWTInfo", "", "boolean"), 96);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createJWTValidationInfoFromJWT", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo:com.nimbusds.jwt.JWTClaimsSet", "jwtValidationInfo:jwtClaimsSet", "java.text.ParseException", "void"), 207);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveJWKSet", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "", "", "java.io.IOException:java.text.ParseException", "com.nimbusds.jose.jwk.JWKSet"), 228);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isCertificateBoundAccessTokenEnabled", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "", "", "", "boolean"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadTokenIssuerConfiguration", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "org.wso2.carbon.apimgt.common.gateway.dto.TokenIssuerDto", "tokenIssuerConfigurations", "", "void"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "validateSignature", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.SignedJWT", "signedJWT", "org.wso2.carbon.apimgt.api.APIManagementException", "boolean"), 135);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "validateTokenExpiry", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.JWTClaimsSet", "jwtClaimsSet", "", "boolean"), 178);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "transformJWTClaims", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.JWTClaimsSet", "jwtClaimsSet", "org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException", "com.nimbusds.jwt.JWTClaimsSet"), 187);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getConsumerKey", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.JWTClaimsSet", "jwtClaimsSet", "org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException", "java.lang.String"), 192);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getScopes", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.JWTClaimsSet", "jwtClaimsSet", "org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException", "java.util.List"), 197);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getIsAppToken", "org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl", "com.nimbusds.jwt.JWTClaimsSet", "jwtClaimsSet", "org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException", "java.lang.Boolean"), 202);
    }
}

