/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.indexing.indexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.solr.common.SolrException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer$AjcClosure1;
import org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer$AjcClosure3;
import org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer$AjcClosure5;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.indexers.RXTIndexer;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class DocumentIndexer
extends RXTIndexer {
    public static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        DocumentIndexer.ajc$preClinit();
        log = LogFactory.getLog(DocumentIndexer.class);
    }

    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException, RegistryException {
        AsyncIndexer.File2Index file2Index = fileData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)file2Index);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, file2Index, joinPoint};
            return (IndexDocument)MethodTimeLogger.aspectOf().log(new DocumentIndexer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DocumentIndexer.getIndexedDocument_aroundBody0(this, file2Index, joinPoint);
    }

    private void fetchRequiredDetailsFromAssociatedAPI(Registry registry, Resource documentResource, Map<String, List<String>> fields) throws RegistryException, APIManagementException {
        Registry registry2 = registry;
        Resource resource = documentResource;
        Map<String, List<String>> map = fields;
        Object[] objectArray = new Object[]{registry2, resource, map};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, registry2, resource, map, joinPoint};
            MethodTimeLogger.aspectOf().log(new DocumentIndexer$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        DocumentIndexer.fetchRequiredDetailsFromAssociatedAPI_aroundBody2(this, registry2, resource, map, joinPoint);
    }

    private String fetchDocumentContent(Registry registry, Resource documentResource) throws RegistryException, IOException, APIManagementException {
        Registry registry2 = registry;
        Resource resource = documentResource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)registry2, (Object)resource);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, registry2, resource, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DocumentIndexer$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DocumentIndexer.fetchDocumentContent_aroundBody4(this, registry2, resource, joinPoint);
    }

    static final /* synthetic */ IndexDocument getIndexedDocument_aroundBody0(DocumentIndexer ajc$this, AsyncIndexer.File2Index fileData, JoinPoint joinPoint) {
        IndexDocument indexDocument;
        IndexDocument newIndexDocument = indexDocument = super.getIndexedDocument(fileData);
        Registry registry = GovernanceUtils.getGovernanceSystemRegistry((Registry)IndexingManager.getInstance().getRegistry(fileData.tenantId));
        String documentResourcePath = fileData.path.substring("/_system/governance".length());
        if (documentResourcePath.contains("/apimgt/applicationdata/apis/")) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing document indexer for resource at " + documentResourcePath));
        }
        Resource documentResource = null;
        Map fields = indexDocument.getFields();
        if (registry.resourceExists(documentResourcePath)) {
            documentResource = registry.get(documentResourcePath);
        }
        if (documentResource != null) {
            try {
                ajc$this.fetchRequiredDetailsFromAssociatedAPI(registry, documentResource, fields);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(ajc$this.fetchDocumentContent(registry, documentResource));
                if (fields.get("overview_name") != null) {
                    stringBuilder.append("overview_name=" + StringUtils.join((Iterable)((Iterable)fields.get("overview_name")), (String)","));
                }
                if (fields.get("overview_summary") != null) {
                    stringBuilder.append("overview_summary=" + StringUtils.join((Iterable)((Iterable)fields.get("overview_summary")), (String)","));
                }
                newIndexDocument = new IndexDocument(fileData.path, "", stringBuilder.toString(), indexDocument.getTenantId());
                fields.put("document_indexed", Arrays.asList("true"));
                newIndexDocument.setFields(fields);
            }
            catch (APIManagementException e) {
                log.error((Object)"Error while updating indexed document.", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while getting document content.", (Throwable)e);
            }
        }
        return newIndexDocument;
    }

    static final /* synthetic */ void fetchRequiredDetailsFromAssociatedAPI_aroundBody2(DocumentIndexer ajc$this, Registry registry, Resource documentResource, Map fields, JoinPoint joinPoint) {
        String pathToDocFile = documentResource.getPath();
        String apiPath = String.valueOf(pathToDocFile.substring(0, pathToDocFile.indexOf("documentation"))) + "api";
        if (registry.resourceExists(apiPath)) {
            Resource apiResource = registry.get(apiPath);
            GenericArtifactManager apiArtifactManager = APIUtil.getArtifactManager(registry, "api");
            GenericArtifact apiArtifact = apiArtifactManager.getGenericArtifact(apiResource.getUUID());
            String apiStatus = apiArtifact.getAttribute("overview_status").toLowerCase();
            String publisherRoles = apiResource.getProperty("publisher_roles");
            fields.put("overview_status", Arrays.asList(apiStatus));
            fields.put("publisher_roles", Arrays.asList(publisherRoles));
        } else {
            log.warn((Object)("API does not exist at " + apiPath));
        }
    }

    static final /* synthetic */ String fetchDocumentContent_aroundBody4(DocumentIndexer ajc$this, Registry registry, Resource documentResource, JoinPoint joinPoint) {
        String contentString;
        String sourceType;
        block43: {
            GenericArtifactManager docArtifactManager = APIUtil.getArtifactManager(registry, "document");
            GenericArtifact documentArtifact = docArtifactManager.getGenericArtifact(documentResource.getUUID());
            sourceType = documentArtifact.getAttribute("overview_sourceType");
            contentString = null;
            if (!Documentation.DocumentSourceType.FILE.name().equals(sourceType)) break block43;
            String path = documentArtifact.getAttribute("overview_filePath");
            int indexOfApimgt = path.indexOf("/apimgt");
            String filepath = path.substring(indexOfApimgt);
            Resource contentResource = registry.get(filepath);
            int indexOfFiles = filepath.indexOf("files") + "files".length() + 1;
            String fileName = filepath.substring(indexOfFiles);
            String extension = FilenameUtils.getExtension((String)fileName);
            InputStream inputStream = null;
            try {
                inputStream = contentResource.getContentStream();
                switch (extension) {
                    case "pdf": {
                        PDFParser pdfParser = new PDFParser(inputStream);
                        pdfParser.parse();
                        COSDocument cosDocument = pdfParser.getDocument();
                        PDFTextStripper stripper = new PDFTextStripper();
                        contentString = stripper.getText(new PDDocument(cosDocument));
                        break;
                    }
                    case "doc": {
                        POIFSFileSystem pfs = new POIFSFileSystem(inputStream);
                        WordExtractor msWord2003Extractor = new WordExtractor(pfs);
                        contentString = msWord2003Extractor.getText();
                        break;
                    }
                    case "docx": {
                        XWPFDocument doc = new XWPFDocument(inputStream);
                        XWPFWordExtractor msWord2007Extractor = new XWPFWordExtractor(doc);
                        contentString = msWord2007Extractor.getText();
                        break;
                    }
                    case "xls": {
                        POIFSFileSystem pfs = new POIFSFileSystem(inputStream);
                        ExcelExtractor extractor = new ExcelExtractor(pfs);
                        contentString = extractor.getText();
                        break;
                    }
                    case "xlsx": {
                        XSSFWorkbook xssfSheets = new XSSFWorkbook(inputStream);
                        XSSFExcelExtractor xssfExcelExtractor = new XSSFExcelExtractor(xssfSheets);
                        contentString = xssfExcelExtractor.getText();
                        break;
                    }
                    case "ppt": {
                        POIFSFileSystem fs = new POIFSFileSystem(inputStream);
                        PowerPointExtractor extractor = new PowerPointExtractor(fs);
                        contentString = extractor.getText();
                        break;
                    }
                    case "pptx": {
                        XMLSlideShow xmlSlideShow = new XMLSlideShow(inputStream);
                        XSLFPowerPointExtractor xslfPowerPointExtractor = new XSLFPowerPointExtractor(xmlSlideShow);
                        contentString = xslfPowerPointExtractor.getText();
                        break;
                    }
                    case "txt": 
                    case "xml": 
                    case "wsdl": {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        StringBuilder contentBuilder = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            contentBuilder.append(line);
                        }
                        contentString = contentBuilder.toString();
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        if (Documentation.DocumentSourceType.INLINE.name().equals(sourceType)) {
            String fileName = ((ResourceImpl)documentResource).getName();
            String pathToDocFile = documentResource.getPath();
            String pathToContent = String.valueOf(pathToDocFile.substring(0, pathToDocFile.lastIndexOf(fileName))) + "contents" + "/" + fileName;
            if (registry.resourceExists(pathToContent)) {
                Resource contentResource = registry.get(pathToContent);
                InputStream instream = null;
                BufferedReader reader = null;
                try {
                    String line;
                    instream = contentResource.getContentStream();
                    reader = new BufferedReader(new InputStreamReader(instream));
                    StringBuilder contentBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        contentBuilder.append(line);
                    }
                    contentString = contentBuilder.toString();
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    throw throwable;
                }
                if (reader != null) {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }
        return contentString;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DocumentIndexer.java", DocumentIndexer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIndexedDocument", "org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer", "org.wso2.carbon.registry.indexing.AsyncIndexer$File2Index", "fileData", "org.apache.solr.common.SolrException:org.wso2.carbon.registry.core.exceptions.RegistryException", "org.wso2.carbon.registry.indexing.solr.IndexDocument"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "fetchRequiredDetailsFromAssociatedAPI", "org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer", "org.wso2.carbon.registry.core.Registry:org.wso2.carbon.registry.core.Resource:java.util.Map", "registry:documentResource:fields", "org.wso2.carbon.registry.core.exceptions.RegistryException:org.wso2.carbon.apimgt.api.APIManagementException", "void"), 134);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "fetchDocumentContent", "org.wso2.carbon.apimgt.impl.indexing.indexer.DocumentIndexer", "org.wso2.carbon.registry.core.Registry:org.wso2.carbon.registry.core.Resource", "registry:documentResource", "org.wso2.carbon.registry.core.exceptions.RegistryException:java.io.IOException:org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 162);
    }
}

