/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.dto.GatewayArtifactSynchronizerProperties;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.ArtifactRetriever;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure1;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure11;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure13;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure15;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure3;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure5;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure7;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever$AjcClosure9;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class DBRetriever
implements ArtifactRetriever {
    private static final Log log;
    protected EventHubConfigurationDto eventHubConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getEventHubConfigurationDto();
    protected GatewayArtifactSynchronizerProperties gatewayArtifactSynchronizerProperties = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getGatewayArtifactSynchronizerProperties();
    private String baseURL = String.valueOf(this.eventHubConfigurationDto.getServiceUrl()) + "/internal/data/v1";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        DBRetriever.ajc$preClinit();
        log = LogFactory.getLog(DBRetriever.class);
    }

    @Override
    public void init() throws ArtifactSynchronizerException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        DBRetriever.init_aroundBody0(this, joinPoint);
    }

    @Override
    public String retrieveArtifact(String apiId, String gatewayLabel) throws ArtifactSynchronizerException {
        String string = apiId;
        String string2 = gatewayLabel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.retrieveArtifact_aroundBody2(this, string, string2, joinPoint);
    }

    private JSONArray retrieveArtifact(CloseableHttpResponse httpResponse) throws IOException, ArtifactSynchronizerException {
        CloseableHttpResponse closeableHttpResponse = httpResponse;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)closeableHttpResponse);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, closeableHttpResponse, joinPoint};
            return (JSONArray)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.retrieveArtifact_aroundBody4(this, closeableHttpResponse, joinPoint);
    }

    @Override
    public List<String> retrieveAllArtifacts(String label, String tenantDomain) throws ArtifactSynchronizerException {
        String string = label;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.retrieveAllArtifacts_aroundBody6(this, string, string2, joinPoint);
    }

    @Override
    public Map<String, String> retrieveAttributes(String apiName, String version, String tenantDomain) throws ArtifactSynchronizerException {
        String string = apiName;
        String string2 = version;
        String string3 = tenantDomain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.retrieveAttributes_aroundBody8(this, string, string2, string3, joinPoint);
    }

    private CloseableHttpResponse invokeService(String endpoint, String tenantDomain) throws IOException, ArtifactSynchronizerException {
        String string = endpoint;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (CloseableHttpResponse)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.invokeService_aroundBody10(this, string, string2, joinPoint);
    }

    @Override
    public void disconnect() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        DBRetriever.disconnect_aroundBody12(this, joinPoint);
    }

    @Override
    public String getName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new DBRetriever$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DBRetriever.getName_aroundBody14(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody0(DBRetriever ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ String retrieveArtifact_aroundBody2(DBRetriever ajc$this, String apiId, String gatewayLabel, JoinPoint joinPoint) {
        block14: {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            try {
                Thread.sleep(ajc$this.gatewayArtifactSynchronizerProperties.getEventWaitingTime());
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)"Error occurred while waiting to retrieve artifacts from event hub");
            }
            try {
                String encodedGatewayLabel = URLEncoder.encode(gatewayLabel, "UTF-8");
                encodedGatewayLabel = encodedGatewayLabel.replace("\\+", "%20");
                String path = "/runtime-artifacts?apiId=" + apiId + "&gatewayLabel=" + encodedGatewayLabel + "&type=Synapse";
                String endpoint = String.valueOf(ajc$this.baseURL) + path;
                Throwable throwable = null;
                Object var14_12 = null;
                try (CloseableHttpResponse httpResponse = ajc$this.invokeService(endpoint, tenantDomain);){
                    JSONArray jsonArray = ajc$this.retrieveArtifact(httpResponse);
                    if (jsonArray == null || jsonArray.length() <= 0) break block14;
                    return jsonArray.getString(0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                String msg = "Error while executing the http client";
                log.error((Object)msg, (Throwable)e);
                throw new ArtifactSynchronizerException(msg, e);
            }
        }
        return null;
    }

    static final /* synthetic */ JSONArray retrieveArtifact_aroundBody4(DBRetriever ajc$this, CloseableHttpResponse httpResponse, JoinPoint joinPoint) {
        if (httpResponse.getStatusLine().getStatusCode() == 404) {
            log.info((Object)"No artifacts available to deploy");
            return new JSONArray();
        }
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            if (httpResponse.getEntity() != null) {
                String gatewayRuntimeArtifact = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                JSONObject artifactObject = new JSONObject(gatewayRuntimeArtifact);
                return (JSONArray)artifactObject.get("list");
            }
            throw new ArtifactSynchronizerException("HTTP response is empty");
        }
        String errorMessage = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        throw new ArtifactSynchronizerException(String.valueOf(errorMessage) + "Event-Hub status code is : " + httpResponse.getStatusLine().getStatusCode());
    }

    static final /* synthetic */ List retrieveAllArtifacts_aroundBody6(DBRetriever ajc$this, String label, String tenantDomain, JoinPoint joinPoint) {
        ArrayList<String> gatewayRuntimeArtifactsArray = new ArrayList<String>();
        try {
            String endcodedgatewayLabel = URLEncoder.encode(label, "UTF-8");
            String path = "/runtime-artifacts?gatewayLabel=" + endcodedgatewayLabel + "&type=Synapse";
            String endpoint = String.valueOf(ajc$this.baseURL) + path;
            Throwable throwable = null;
            Object var14_12 = null;
            try (CloseableHttpResponse httpResponse = ajc$this.invokeService(endpoint, tenantDomain);){
                JSONArray jsonArray = ajc$this.retrieveArtifact(httpResponse);
                if (jsonArray != null) {
                    int i = 0;
                    while (i < jsonArray.length()) {
                        gatewayRuntimeArtifactsArray.add(jsonArray.getString(i));
                        ++i;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return gatewayRuntimeArtifactsArray;
        }
        catch (IOException e) {
            String msg = "Error while executing the http client";
            log.error((Object)msg, (Throwable)e);
            throw new ArtifactSynchronizerException(msg, e);
        }
    }

    static final /* synthetic */ Map retrieveAttributes_aroundBody8(DBRetriever ajc$this, String apiName, String version, String tenantDomain, JoinPoint joinPoint) {
        CloseableHttpResponse httpResponse = null;
        try {
            String endcodedVersion = URLEncoder.encode(version, "UTF-8");
            String path = "/synapse-attributes?apiName=" + apiName + "&tenantDomain=" + tenantDomain + "&version=" + endcodedVersion;
            String endpoint = String.valueOf(ajc$this.baseURL) + path;
            httpResponse = ajc$this.invokeService(endpoint, tenantDomain);
            if (httpResponse.getEntity() == null) {
                throw new ArtifactSynchronizerException("HTTP response is empty");
            }
            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            httpResponse.close();
            HashMap<String, String> apiAttribute = new HashMap<String, String>();
            JSONObject artifactObject = new JSONObject(responseString);
            String label = null;
            String apiId = null;
            try {
                apiId = (String)artifactObject.get("apiId");
                String labelsStr = artifactObject.get("labels").toString();
                Set labelsSet = (Set)new Gson().fromJson(labelsStr, new TypeToken<HashSet<String>>(){}.getType());
                Set<String> gatewaySubscribedLabel = ajc$this.gatewayArtifactSynchronizerProperties.getGatewayLabels();
                if (!labelsSet.isEmpty() || !gatewaySubscribedLabel.isEmpty()) {
                    labelsSet.retainAll(gatewaySubscribedLabel);
                    if (!labelsSet.isEmpty()) {
                        label = (String)labelsSet.iterator().next();
                    }
                }
            }
            catch (ClassCastException e) {
                log.error((Object)("Unexpected response received from the storage." + e.getMessage()));
            }
            apiAttribute.put("apiId", apiId);
            apiAttribute.put("label", label);
            return apiAttribute;
        }
        catch (IOException e) {
            String msg = "Error while executing the http client";
            log.error((Object)msg, (Throwable)e);
            throw new ArtifactSynchronizerException(msg, e);
        }
    }

    static final /* synthetic */ CloseableHttpResponse invokeService_aroundBody10(DBRetriever ajc$this, String endpoint, String tenantDomain, JoinPoint joinPoint) {
        HttpGet method = new HttpGet(endpoint);
        URL url = new URL(endpoint);
        String username = ajc$this.eventHubConfigurationDto.getUsername();
        String password = ajc$this.eventHubConfigurationDto.getPassword();
        byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(username) + ":" + password).getBytes("UTF-8"));
        int port = url.getPort();
        String protocol = url.getProtocol();
        method.setHeader("Authorization", "Basic " + new String(credentials, "UTF-8"));
        if (tenantDomain != null) {
            method.setHeader("xWSO2Tenant", tenantDomain);
        }
        HttpClient httpClient = APIUtil.getHttpClient(port, protocol);
        try {
            return APIUtil.executeHTTPRequest((HttpRequestBase)method, httpClient);
        }
        catch (APIManagementException e) {
            throw new ArtifactSynchronizerException(e);
        }
    }

    static final /* synthetic */ void disconnect_aroundBody12(DBRetriever ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ String getName_aroundBody14(DBRetriever ajc$this, JoinPoint joinPoint) {
        return "DBRetriever";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DBRetriever.java", DBRetriever.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "", "", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "void"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveArtifact", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "java.lang.String:java.lang.String", "apiId:gatewayLabel", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "java.lang.String"), 67);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveArtifact", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "org.apache.http.client.methods.CloseableHttpResponse", "httpResponse", "java.io.IOException:org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "org.json.JSONArray"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveAllArtifacts", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "java.lang.String:java.lang.String", "label:tenantDomain", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "java.util.List"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveAttributes", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "java.lang.String:java.lang.String:java.lang.String", "apiName:version:tenantDomain", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "java.util.Map"), 146);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "invokeService", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "java.lang.String:java.lang.String", "endpoint:tenantDomain", "java.io.IOException:org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "org.apache.http.client.methods.CloseableHttpResponse"), 196);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disconnect", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "", "", "", "void"), 222);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.DBRetriever", "", "", "", "java.lang.String"), 227);
    }
}

