/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.factory;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstantOracle;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstantPostgreSQL;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstants;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstantsDB2;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstantsH2MySQL;
import org.wso2.carbon.apimgt.impl.dao.constants.SQLConstantsMSSQL;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder;
import org.wso2.carbon.apimgt.impl.factory.SQLConstantManagerFactory$AjcClosure1;
import org.wso2.carbon.apimgt.impl.factory.SQLConstantManagerFactory$AjcClosure3;
import org.wso2.carbon.apimgt.impl.utils.APIMgtDBUtil;

public class SQLConstantManagerFactory {
    private static Log log;
    private static SQLConstants sqlConstants;
    private static SQLConstantsH2MySQL sqlConstantsH2MySQL;
    private static SQLConstantsMSSQL sqlConstantsMSSQL;
    private static SQLConstantsDB2 sqlConstantsDB2;
    private static SQLConstantPostgreSQL sqlConstantPostgreSQL;
    private static SQLConstantOracle sqlConstantOracle;
    private static String dbType;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        SQLConstantManagerFactory.ajc$preClinit();
        log = LogFactory.getLog(KeyManagerHolder.class);
        sqlConstants = null;
        sqlConstantsH2MySQL = null;
        sqlConstantsMSSQL = null;
        sqlConstantsDB2 = null;
        sqlConstantPostgreSQL = null;
        sqlConstantOracle = null;
        dbType = null;
    }

    public static void initializeSQLConstantManager() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            MethodTimeLogger.aspectOf().log(new SQLConstantManagerFactory$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        SQLConstantManagerFactory.initializeSQLConstantManager_aroundBody0(joinPoint);
    }

    public static String getSQlString(String sql) throws APIManagementException {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new SQLConstantManagerFactory$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return SQLConstantManagerFactory.getSQlString_aroundBody2(string, joinPoint);
    }

    static final /* synthetic */ void initializeSQLConstantManager_aroundBody0(JoinPoint joinPoint) {
        block11: {
            Connection connection = null;
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    if (connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2")) {
                        sqlConstantsH2MySQL = new SQLConstantsH2MySQL();
                        dbType = "h2mysql";
                        break block11;
                    }
                    if (connection.getMetaData().getDatabaseProductName().contains("DB2")) {
                        sqlConstantsDB2 = new SQLConstantsDB2();
                        dbType = "db2";
                        break block11;
                    }
                    if (connection.getMetaData().getDriverName().contains("MS SQL")) {
                        dbType = "mssql";
                        sqlConstantsMSSQL = new SQLConstantsMSSQL();
                        break block11;
                    }
                    if (connection.getMetaData().getDriverName().contains("Microsoft")) {
                        dbType = "mssql";
                        sqlConstantsMSSQL = new SQLConstantsMSSQL();
                        break block11;
                    }
                    if (connection.getMetaData().getDriverName().contains("PostgreSQL")) {
                        dbType = "postgre";
                        sqlConstantPostgreSQL = new SQLConstantPostgreSQL();
                        break block11;
                    }
                    if (connection.getMetaData().getDriverName().contains("Oracle")) {
                        dbType = "oracle";
                        sqlConstantOracle = new SQLConstantOracle();
                        break block11;
                    }
                    log.error((Object)"Could not find DB type to load constants");
                    throw new APIManagementException("Error occurred while initializing SQL Constants Manager");
                }
                catch (SQLException e) {
                    log.error((Object)"Error occurred while initializeSQLConstantManager");
                    throw new APIManagementException("Error occurred while initializing SQL Constants Manager", (Throwable)e);
                }
            }
            finally {
                APIMgtDBUtil.closeAllConnections(null, connection, null);
            }
        }
    }

    static final /* synthetic */ String getSQlString_aroundBody2(String sql, JoinPoint joinPoint) {
        String sqlString = null;
        try {
            Class<?> clazz = null;
            if ("h2mysql".equals(dbType)) {
                clazz = sqlConstantsH2MySQL.getClass();
            } else if ("mssql".equals(dbType)) {
                clazz = sqlConstantsMSSQL.getClass();
            } else if ("db2".equals(dbType)) {
                clazz = sqlConstantsDB2.getClass();
            } else if ("postgre".equals(dbType)) {
                clazz = sqlConstantPostgreSQL.getClass();
            } else if ("oracle".equals(dbType)) {
                clazz = sqlConstantOracle.getClass();
            } else {
                String errorMsg = "No DB type Found";
                log.error((Object)errorMsg);
                throw new APIManagementException(errorMsg);
            }
            Field field = clazz.getDeclaredField(sql);
            field.setAccessible(true);
            sqlString = (String)field.get(sqlConstantsH2MySQL);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Illegal Access attempt to sql constant class");
            throw new APIManagementException("Illegal Access attempt to sql constant class", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)("No such a field found in sql constant class" + sql));
            throw new APIManagementException("No such a field found in sql constant class " + sql, (Throwable)e);
        }
        return sqlString;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SQLConstantManagerFactory.java", SQLConstantManagerFactory.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSQLConstantManager", "org.wso2.carbon.apimgt.impl.factory.SQLConstantManagerFactory", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSQlString", "org.wso2.carbon.apimgt.impl.factory.SQLConstantManagerFactory", "java.lang.String", "sql", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 95);
    }
}

