/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.factory;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.cert.Certificate;
import javax.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.KeyManager;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;
import org.wso2.carbon.apimgt.common.gateway.dto.ClaimMappingDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWKSConfigurationDTO;
import org.wso2.carbon.apimgt.common.gateway.dto.TokenIssuerDto;
import org.wso2.carbon.apimgt.impl.AMDefaultKeyManagerImpl;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.KeyManagerDto;
import org.wso2.carbon.apimgt.impl.dto.TenantKeyManagerDto;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure1;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure11;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure13;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure15;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure17;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure3;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure5;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure7;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder$AjcClosure9;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidator;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidatorImpl;
import org.wso2.carbon.apimgt.impl.loader.KeyManagerConfigurationDataRetriever;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class KeyManagerHolder {
    private static Log log;
    private static Map<String, TenantKeyManagerDto> tenantWiseMap;
    private static Map<String, KeyManagerDto> globalJWTValidatorMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        KeyManagerHolder.ajc$preClinit();
        log = LogFactory.getLog(KeyManagerHolder.class);
        tenantWiseMap = new HashMap<String, TenantKeyManagerDto>();
        globalJWTValidatorMap = new HashMap<String, KeyManagerDto>();
    }

    public static void addKeyManagerConfiguration(String tenantDomain, String name, String type, KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        String string = tenantDomain;
        String string2 = name;
        String string3 = type;
        KeyManagerConfiguration keyManagerConfiguration2 = keyManagerConfiguration;
        Object[] objectArray = new Object[]{string, string2, string3, keyManagerConfiguration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{string, string2, string3, keyManagerConfiguration2, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure1(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        KeyManagerHolder.addKeyManagerConfiguration_aroundBody0(string, string2, string3, keyManagerConfiguration2, joinPoint);
    }

    public static Map<String, KeyManagerDto> getTenantKeyManagers(String tenantDomain) {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return KeyManagerHolder.getTenantKeyManagers_aroundBody2(string, joinPoint);
    }

    private KeyManagerHolder() {
    }

    public static void updateKeyManagerConfiguration(String tenantDomain, String name, String type, KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        String string = tenantDomain;
        String string2 = name;
        String string3 = type;
        KeyManagerConfiguration keyManagerConfiguration2 = keyManagerConfiguration;
        Object[] objectArray = new Object[]{string, string2, string3, keyManagerConfiguration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{string, string2, string3, keyManagerConfiguration2, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure5(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        KeyManagerHolder.updateKeyManagerConfiguration_aroundBody4(string, string2, string3, keyManagerConfiguration2, joinPoint);
    }

    public static void removeKeyManagerConfiguration(String tenantDomain, String name) {
        String string = tenantDomain;
        String string2 = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        KeyManagerHolder.removeKeyManagerConfiguration_aroundBody6(string, string2, joinPoint);
    }

    private static JWTValidator getJWTValidator(KeyManagerConfiguration keyManagerConfiguration, String jwtValidatorImplementation) throws APIManagementException {
        KeyManagerConfiguration keyManagerConfiguration2 = keyManagerConfiguration;
        String string = jwtValidatorImplementation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)keyManagerConfiguration2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{keyManagerConfiguration2, string, joinPoint};
            return (JWTValidator)MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure9(objectArray).linkClosureAndJoinPoint(65536));
        }
        return KeyManagerHolder.getJWTValidator_aroundBody8(keyManagerConfiguration2, string, joinPoint);
    }

    public static KeyManager getKeyManagerInstance(String tenantDomain, String keyManagerName) {
        String string = tenantDomain;
        String string2 = keyManagerName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            return (KeyManager)MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536));
        }
        return KeyManagerHolder.getKeyManagerInstance_aroundBody10(string, string2, joinPoint);
    }

    public static KeyManagerDto getKeyManagerByIssuer(String tenantDomain, String issuer) {
        String string = tenantDomain;
        String string2 = issuer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            return (KeyManagerDto)MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure13(objectArray).linkClosureAndJoinPoint(65536));
        }
        return KeyManagerHolder.getKeyManagerByIssuer_aroundBody12(string, string2, joinPoint);
    }

    private static TenantKeyManagerDto getTenantKeyManagerDto(String tenantDomain) {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, joinPoint};
            return (TenantKeyManagerDto)MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure15(objectArray).linkClosureAndJoinPoint(65536));
        }
        return KeyManagerHolder.getTenantKeyManagerDto_aroundBody14(string, joinPoint);
    }

    public static void addGlobalJWTValidators(TokenIssuerDto tokenIssuerDto) {
        TokenIssuerDto tokenIssuerDto2 = tokenIssuerDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)tokenIssuerDto2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{tokenIssuerDto2, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyManagerHolder$AjcClosure17(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        KeyManagerHolder.addGlobalJWTValidators_aroundBody16(tokenIssuerDto2, joinPoint);
    }

    static final /* synthetic */ void addKeyManagerConfiguration_aroundBody0(String tenantDomain, String name, String type, KeyManagerConfiguration keyManagerConfiguration, JoinPoint joinPoint) {
        String issuer = (String)keyManagerConfiguration.getParameter("issuer");
        TenantKeyManagerDto tenantKeyManagerDto = tenantWiseMap.get(tenantDomain);
        if (tenantKeyManagerDto == null) {
            tenantKeyManagerDto = new TenantKeyManagerDto();
        }
        if (tenantKeyManagerDto.getKeyManagerByName(name) != null) {
            log.error((Object)("Key Manager " + name + " already initialized in tenant " + tenantDomain));
        }
        if (keyManagerConfiguration.isEnabled()) {
            AMDefaultKeyManagerImpl keyManager = null;
            JWTValidator jwtValidator = null;
            APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String defaultKeyManagerType = apiManagerConfiguration.getFirstProperty("APIKeyValidator.DefaultKeyManagerType");
            KeyManagerConnectorConfiguration keyManagerConnectorConfiguration = ServiceReferenceHolder.getInstance().getKeyManagerConnectorConfiguration(type);
            if (keyManagerConnectorConfiguration != null) {
                if (StringUtils.isNotEmpty((CharSequence)keyManagerConnectorConfiguration.getImplementation())) {
                    try {
                        keyManager = (KeyManager)Class.forName(keyManagerConnectorConfiguration.getImplementation()).newInstance();
                        keyManager.setTenantDomain(tenantDomain);
                        if (StringUtils.isNotEmpty((CharSequence)defaultKeyManagerType) && defaultKeyManagerType.equals(type)) {
                            keyManagerConfiguration.addParameter("Username", (Object)apiManagerConfiguration.getFirstProperty("APIKeyValidator.Username"));
                            keyManagerConfiguration.addParameter("Password", (Object)apiManagerConfiguration.getFirstProperty("APIKeyValidator.Password"));
                        }
                        keyManager.loadConfiguration(keyManagerConfiguration);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new APIManagementException("Error while loading keyManager configuration", (Throwable)e);
                    }
                }
                jwtValidator = KeyManagerHolder.getJWTValidator(keyManagerConfiguration, keyManagerConnectorConfiguration.getJWTValidator());
            } else if ("default".equals(type)) {
                keyManager = new AMDefaultKeyManagerImpl();
                keyManager.setTenantDomain(tenantDomain);
                keyManager.loadConfiguration(keyManagerConfiguration);
                jwtValidator = KeyManagerHolder.getJWTValidator(keyManagerConfiguration, null);
            }
            KeyManagerDto keyManagerDto = new KeyManagerDto();
            keyManagerDto.setName(name);
            keyManagerDto.setIssuer(issuer);
            keyManagerDto.setJwtValidator(jwtValidator);
            keyManagerDto.setKeyManager(keyManager);
            tenantKeyManagerDto.putKeyManagerDto(keyManagerDto);
            tenantWiseMap.put(tenantDomain, tenantKeyManagerDto);
        }
    }

    static final /* synthetic */ Map getTenantKeyManagers_aroundBody2(String tenantDomain, JoinPoint joinPoint) {
        TenantKeyManagerDto tenantKeyManagerDto = KeyManagerHolder.getTenantKeyManagerDto(tenantDomain);
        if (tenantKeyManagerDto != null) {
            return tenantKeyManagerDto.getKeyManagerMap();
        }
        return Collections.emptyMap();
    }

    static final /* synthetic */ void updateKeyManagerConfiguration_aroundBody4(String tenantDomain, String name, String type, KeyManagerConfiguration keyManagerConfiguration, JoinPoint joinPoint) {
        KeyManagerHolder.removeKeyManagerConfiguration(tenantDomain, name);
        if (keyManagerConfiguration.isEnabled()) {
            KeyManagerHolder.addKeyManagerConfiguration(tenantDomain, name, type, keyManagerConfiguration);
        }
    }

    static final /* synthetic */ void removeKeyManagerConfiguration_aroundBody6(String tenantDomain, String name, JoinPoint joinPoint) {
        TenantKeyManagerDto tenantKeyManagerDto = tenantWiseMap.get(tenantDomain);
        if (tenantKeyManagerDto != null) {
            tenantKeyManagerDto.removeKeyManagerDtoByName(name);
        }
    }

    static final /* synthetic */ JWTValidator getJWTValidator_aroundBody8(KeyManagerConfiguration keyManagerConfiguration, String jwtValidatorImplementation, JoinPoint joinPoint) {
        Object issuer;
        Object selfValidateJWT = keyManagerConfiguration.getParameter("self_validate_jwt");
        if (selfValidateJWT != null && ((Boolean)selfValidateJWT).booleanValue() && (issuer = keyManagerConfiguration.getParameter("issuer")) != null) {
            JWTValidator jwtValidator;
            Object jwksEndpoint;
            Object scopeClaim;
            Object consumerKeyClaim;
            TokenIssuerDto tokenIssuerDto = new TokenIssuerDto((String)issuer);
            Object claimMappings = keyManagerConfiguration.getParameter("claim_mappings");
            if (claimMappings instanceof List) {
                Gson gson = new Gson();
                JsonElement jsonElement = gson.toJsonTree(claimMappings);
                ClaimMappingDto[] claimMappingDto = (ClaimMappingDto[])gson.fromJson(jsonElement, ClaimMappingDto[].class);
                tokenIssuerDto.addClaimMappings(claimMappingDto);
            }
            if ((consumerKeyClaim = keyManagerConfiguration.getParameter("consumer_key_claim")) instanceof String && StringUtils.isNotEmpty((CharSequence)((String)consumerKeyClaim))) {
                tokenIssuerDto.setConsumerKeyClaim((String)consumerKeyClaim);
            }
            if ((scopeClaim = keyManagerConfiguration.getParameter("scopes_claim")) instanceof String && StringUtils.isNotEmpty((CharSequence)((String)scopeClaim))) {
                tokenIssuerDto.setScopesClaim((String)scopeClaim);
            }
            if ((jwksEndpoint = keyManagerConfiguration.getParameter("jwks_endpoint")) != null && StringUtils.isNotEmpty((CharSequence)((String)jwksEndpoint))) {
                JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
                jwksConfigurationDTO.setEnabled(true);
                jwksConfigurationDTO.setUrl((String)jwksEndpoint);
                tokenIssuerDto.setJwksConfigurationDTO(jwksConfigurationDTO);
            }
            Object certificateType = keyManagerConfiguration.getParameter("certificate_type");
            Object certificateValue = keyManagerConfiguration.getParameter("certificate_value");
            if (certificateType != null && StringUtils.isNotEmpty((CharSequence)((String)certificateType)) && certificateValue != null && StringUtils.isNotEmpty((CharSequence)((String)certificateValue))) {
                if ("JWKS".equals(certificateType)) {
                    JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
                    jwksConfigurationDTO.setEnabled(true);
                    jwksConfigurationDTO.setUrl((String)certificateValue);
                    tokenIssuerDto.setJwksConfigurationDTO(jwksConfigurationDTO);
                } else {
                    X509Certificate x509Certificate = APIUtil.retrieveCertificateFromContent((String)certificateValue);
                    if (x509Certificate != null) {
                        tokenIssuerDto.setCertificate((Certificate)x509Certificate);
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)jwtValidatorImplementation)) {
                jwtValidator = new JWTValidatorImpl();
            } else {
                try {
                    jwtValidator = (JWTValidator)Class.forName(jwtValidatorImplementation).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.error((Object)"Error while initializing JWT Validator", (Throwable)e);
                    throw new APIManagementException("Error while initializing JWT Validator", (Throwable)e);
                }
            }
            jwtValidator.loadTokenIssuerConfiguration(tokenIssuerDto);
            return jwtValidator;
        }
        return null;
    }

    static final /* synthetic */ KeyManager getKeyManagerInstance_aroundBody10(String tenantDomain, String keyManagerName, JoinPoint joinPoint) {
        TenantKeyManagerDto tenantKeyManagerDto = KeyManagerHolder.getTenantKeyManagerDto(tenantDomain);
        if (tenantKeyManagerDto != null) {
            KeyManagerDto keyManagerDto = tenantKeyManagerDto.getKeyManagerByName(keyManagerName);
            if (keyManagerDto == null) {
                return null;
            }
            return keyManagerDto.getKeyManager();
        }
        return null;
    }

    static final /* synthetic */ KeyManagerDto getKeyManagerByIssuer_aroundBody12(String tenantDomain, String issuer, JoinPoint joinPoint) {
        if (globalJWTValidatorMap.containsKey(issuer)) {
            return globalJWTValidatorMap.get(issuer);
        }
        TenantKeyManagerDto tenantKeyManagerDto = KeyManagerHolder.getTenantKeyManagerDto(tenantDomain);
        if (tenantKeyManagerDto != null) {
            return tenantKeyManagerDto.getKeyManagerDtoByIssuer(issuer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ TenantKeyManagerDto getTenantKeyManagerDto_aroundBody14(String tenantDomain, JoinPoint joinPoint) {
        TenantKeyManagerDto tenantKeyManagerDto = tenantWiseMap.get(tenantDomain);
        if (tenantKeyManagerDto == null) {
            String string = "KeyManagerHolder".concat(tenantDomain);
            synchronized (string) {
                if (tenantKeyManagerDto == null) {
                    new KeyManagerConfigurationDataRetriever(tenantDomain).run();
                    tenantKeyManagerDto = tenantWiseMap.get(tenantDomain);
                }
            }
        }
        return tenantKeyManagerDto;
    }

    static final /* synthetic */ void addGlobalJWTValidators_aroundBody16(TokenIssuerDto tokenIssuerDto, JoinPoint joinPoint) {
        KeyManagerDto keyManagerDto = new KeyManagerDto();
        keyManagerDto.setIssuer(tokenIssuerDto.getIssuer());
        keyManagerDto.setName("Resident Key Manager");
        JWTValidatorImpl jwtValidator = new JWTValidatorImpl();
        jwtValidator.loadTokenIssuerConfiguration(tokenIssuerDto);
        keyManagerDto.setJwtValidator(jwtValidator);
        globalJWTValidatorMap.put(tokenIssuerDto.getIssuer(), keyManagerDto);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KeyManagerHolder.java", KeyManagerHolder.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "addKeyManagerConfiguration", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String:java.lang.String:java.lang.String:org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration", "tenantDomain:name:type:keyManagerConfiguration", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getTenantKeyManagers", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String", "tenantDomain", "", "java.util.Map"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "updateKeyManagerConfiguration", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String:java.lang.String:java.lang.String:org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration", "tenantDomain:name:type:keyManagerConfiguration", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "removeKeyManagerConfiguration", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String:java.lang.String", "tenantDomain:name", "", "void"), 146);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getJWTValidator", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration:java.lang.String", "keyManagerConfiguration:jwtValidatorImplementation", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.impl.jwt.JWTValidator"), 154);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getKeyManagerInstance", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String:java.lang.String", "tenantDomain:keyManagerName", "", "org.wso2.carbon.apimgt.api.model.KeyManager"), 225);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getKeyManagerByIssuer", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String:java.lang.String", "tenantDomain:issuer", "", "org.wso2.carbon.apimgt.impl.dto.KeyManagerDto"), 238);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getTenantKeyManagerDto", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "java.lang.String", "tenantDomain", "", "org.wso2.carbon.apimgt.impl.dto.TenantKeyManagerDto"), 250);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "addGlobalJWTValidators", "org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder", "org.wso2.carbon.apimgt.common.gateway.dto.TokenIssuerDto", "tokenIssuerDto", "", "void"), 263);
    }
}

