/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.definitions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ErrorItem;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParser;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure1;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure11;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure3;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure5;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure7;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil$AjcClosure9;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class AsyncApiParserUtil {
    private static final APIDefinition asyncApiParser;
    private static final Log log;
    private static final String PATH_SEPARATOR = "/";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        AsyncApiParserUtil.ajc$preClinit();
        asyncApiParser = new AsyncApiParser();
        log = LogFactory.getLog(AsyncApiParserUtil.class);
    }

    public static APIDefinitionValidationResponse validateAsyncAPISpecification(String schemaToBeValidated, boolean returnJSONContent) throws APIManagementException {
        String string = schemaToBeValidated;
        boolean bl = returnJSONContent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), joinPoint};
            return (APIDefinitionValidationResponse)MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AsyncApiParserUtil.validateAsyncAPISpecification_aroundBody0(string, bl, joinPoint);
    }

    public static APIDefinitionValidationResponse validateAsyncAPISpecificationByURL(String url, boolean returnJSONContent) throws APIManagementException {
        String string = url;
        boolean bl = returnJSONContent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), joinPoint};
            return (APIDefinitionValidationResponse)MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AsyncApiParserUtil.validateAsyncAPISpecificationByURL_aroundBody2(string, bl, joinPoint);
    }

    public static void updateValidationResponseAsSuccess(APIDefinitionValidationResponse validationResponse, String originalAPIDefinition, String asyncAPIVersion, String title, String version, String context, String description, List<String> endpoints) {
        APIDefinitionValidationResponse aPIDefinitionValidationResponse = validationResponse;
        String string = originalAPIDefinition;
        String string2 = asyncAPIVersion;
        String string3 = title;
        String string4 = version;
        String string5 = context;
        String string6 = description;
        List<String> list = endpoints;
        Object[] objectArray = new Object[]{aPIDefinitionValidationResponse, string, string2, string3, string4, string5, string6, list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{aPIDefinitionValidationResponse, string, string2, string3, string4, string5, string6, list, joinPoint};
            MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure5(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        AsyncApiParserUtil.updateValidationResponseAsSuccess_aroundBody4(aPIDefinitionValidationResponse, string, string2, string3, string4, string5, string6, list, joinPoint);
    }

    public static ErrorItem addErrorToValidationResponse(APIDefinitionValidationResponse validationResponse, String errMessage) {
        APIDefinitionValidationResponse aPIDefinitionValidationResponse = validationResponse;
        String string = errMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)aPIDefinitionValidationResponse, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{aPIDefinitionValidationResponse, string, joinPoint};
            return (ErrorItem)MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AsyncApiParserUtil.addErrorToValidationResponse_aroundBody6(aPIDefinitionValidationResponse, string, joinPoint);
    }

    public static void saveAPIDefinition(API api, String apiDefinitionJSON, Registry registry) throws APIManagementException {
        API aPI = api;
        String string = apiDefinitionJSON;
        Registry registry2 = registry;
        Object[] objectArray = new Object[]{aPI, string, registry2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{aPI, string, registry2, joinPoint};
            MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure9(objectArray2).linkClosureAndJoinPoint(65536));
            return;
        }
        AsyncApiParserUtil.saveAPIDefinition_aroundBody8(aPI, string, registry2, joinPoint);
    }

    public static String getAPIDefinition(Identifier apiIdentifier, Registry registry) throws APIManagementException {
        Identifier identifier = apiIdentifier;
        Registry registry2 = registry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)identifier, (Object)registry2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{identifier, registry2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AsyncApiParserUtil$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AsyncApiParserUtil.getAPIDefinition_aroundBody10(identifier, registry2, joinPoint);
    }

    static final /* synthetic */ APIDefinitionValidationResponse validateAsyncAPISpecification_aroundBody0(String schemaToBeValidated, boolean returnJSONContent, JoinPoint joinPoint) {
        APIDefinitionValidationResponse validationResponse = asyncApiParser.validateAPIDefinition(schemaToBeValidated, returnJSONContent);
        if (!validationResponse.isValid()) {
            for (ErrorHandler errorItem : validationResponse.getErrorItems()) {
                if (!"#: required key [asyncapi] not found".equals(errorItem.getErrorMessage())) continue;
                AsyncApiParserUtil.addErrorToValidationResponse(validationResponse, "#: attribute [asyncapi] should be present");
                return validationResponse;
            }
        }
        return validationResponse;
    }

    static final /* synthetic */ APIDefinitionValidationResponse validateAsyncAPISpecificationByURL_aroundBody2(String url, boolean returnJSONContent, JoinPoint joinPoint) {
        APIDefinitionValidationResponse validationResponse = new APIDefinitionValidationResponse();
        try {
            URL urlObj = new URL(url);
            HttpClient httpClient = APIUtil.getHttpClient(urlObj.getPort(), urlObj.getProtocol());
            HttpGet httpGet = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (200 == response.getStatusLine().getStatusCode()) {
                ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                Object obj = yamlReader.readValue(urlObj, Object.class);
                ObjectMapper jsonWriter = new ObjectMapper();
                String json = jsonWriter.writeValueAsString(obj);
                validationResponse = AsyncApiParserUtil.validateAsyncAPISpecification(json, returnJSONContent);
            } else {
                validationResponse.setValid(false);
                validationResponse.getErrorItems().add(ExceptionCodes.ASYNCAPI_URL_NO_200);
            }
        }
        catch (IOException e) {
            ExceptionCodes errorHandler = ExceptionCodes.ASYNCAPI_URL_MALFORMED;
            log.error((Object)errorHandler.getErrorDescription(), (Throwable)e);
            validationResponse.setValid(false);
            validationResponse.getErrorItems().add(errorHandler);
        }
        return validationResponse;
    }

    static final /* synthetic */ void updateValidationResponseAsSuccess_aroundBody4(APIDefinitionValidationResponse validationResponse, String originalAPIDefinition, String asyncAPIVersion, String title, String version, String context, String description, List endpoints, JoinPoint joinPoint) {
        validationResponse.setValid(true);
        validationResponse.setContent(originalAPIDefinition);
        APIDefinitionValidationResponse.Info info = new APIDefinitionValidationResponse.Info();
        info.setOpenAPIVersion(asyncAPIVersion);
        info.setName(title);
        info.setVersion(version);
        info.setContext(context);
        info.setDescription(description);
        info.setEndpoints(endpoints);
        validationResponse.setInfo(info);
    }

    static final /* synthetic */ ErrorItem addErrorToValidationResponse_aroundBody6(APIDefinitionValidationResponse validationResponse, String errMessage, JoinPoint joinPoint) {
        ErrorItem errorItem = new ErrorItem();
        errorItem.setMessage(errMessage);
        validationResponse.getErrorItems().add(errorItem);
        return errorItem;
    }

    static final /* synthetic */ void saveAPIDefinition_aroundBody8(API api, String apiDefinitionJSON, Registry registry, JoinPoint joinPoint) {
        String apiName = api.getId().getApiName();
        String apiVersion = api.getId().getVersion();
        String apiProviderName = api.getId().getProviderName();
        try {
            String resourcePath = APIUtil.getAsyncAPIDefinitionFilePath(apiName, apiVersion, apiProviderName);
            resourcePath = String.valueOf(resourcePath) + "asyncapi.json";
            Resource resource = !registry.resourceExists(resourcePath) ? registry.newResource() : registry.get(resourcePath);
            resource.setContent((Object)apiDefinitionJSON);
            resource.setMediaType("application/json");
            registry.put(resourcePath, resource);
            String[] visibleRoles = null;
            if (api.getVisibleRoles() != null) {
                visibleRoles = api.getVisibleRoles().split(",");
            }
            APIUtil.clearResourcePermissions(resourcePath, (Identifier)api.getId(), ((UserRegistry)registry).getTenantId());
            APIUtil.setResourcePermissions(apiProviderName, api.getVisibility(), visibleRoles, resourcePath);
        }
        catch (RegistryException e) {
            APIUtil.handleException("Error while adding AsyncApi Definition for " + apiName + "-" + apiVersion, e);
        }
    }

    static final /* synthetic */ String getAPIDefinition_aroundBody10(Identifier apiIdentifier, Registry registry, JoinPoint joinPoint) {
        String resourcePath = "";
        if (apiIdentifier instanceof APIIdentifier) {
            resourcePath = APIUtil.getAsyncAPIDefinitionFilePath(apiIdentifier.getName(), apiIdentifier.getVersion(), apiIdentifier.getProviderName());
        }
        JSONParser parser = new JSONParser();
        String apiDocContent = null;
        try {
            if (registry.resourceExists(String.valueOf(resourcePath) + "asyncapi.json")) {
                Resource apiDocResource = registry.get(String.valueOf(resourcePath) + "asyncapi.json");
                apiDocContent = new String((byte[])apiDocResource.getContent(), Charset.defaultCharset());
                parser.parse(apiDocContent);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Resourceasyncapi.json not found at " + resourcePath));
            }
        }
        catch (RegistryException e) {
            APIUtil.handleException("Error while retrieving AsyncAPI Definition for " + apiIdentifier.getName() + "-" + apiIdentifier.getVersion(), e);
        }
        catch (ParseException e) {
            APIUtil.handleException("Error while parsing AsyncAPI Definition for " + apiIdentifier.getName() + "-" + apiIdentifier.getVersion() + " in " + resourcePath, e);
        }
        return apiDocContent;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AsyncApiParserUtil.java", AsyncApiParserUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "validateAsyncAPISpecification", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "java.lang.String:boolean", "schemaToBeValidated:returnJSONContent", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "validateAsyncAPISpecificationByURL", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "java.lang.String:boolean", "url:returnJSONContent", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "updateValidationResponseAsSuccess", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.util.List", "validationResponse:originalAPIDefinition:asyncAPIVersion:title:version:context:description:endpoints", "", "void"), 94);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "addErrorToValidationResponse", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse:java.lang.String", "validationResponse:errMessage", "", "org.wso2.carbon.apimgt.api.ErrorItem"), 116);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "saveAPIDefinition", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "org.wso2.carbon.apimgt.api.model.API:java.lang.String:org.wso2.carbon.registry.api.Registry", "api:apiDefinitionJSON:registry", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 132);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getAPIDefinition", "org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil", "org.wso2.carbon.apimgt.api.model.Identifier:org.wso2.carbon.registry.api.Registry", "apiIdentifier:registry", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 172);
    }
}

