/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.dao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.api.APIMgtDAOException;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure1;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure11;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure13;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure15;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure17;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure3;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure5;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure7;
import org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO$AjcClosure9;
import org.wso2.carbon.apimgt.impl.dto.SystemApplicationDTO;
import org.wso2.carbon.apimgt.impl.utils.APIMgtDBUtil;

public class SystemApplicationDAO {
    private static final Logger log;
    private static final String SYSTEM_APP_TABLE_NAME = "AM_SYSTEM_APPS";
    private static Semaphore semaphore;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        SystemApplicationDAO.ajc$preClinit();
        log = LoggerFactory.getLogger(SystemApplicationDAO.class);
        semaphore = new Semaphore(1);
    }

    public static Semaphore getLock() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (Semaphore)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return SystemApplicationDAO.semaphore;
    }

    public boolean isTableExists() throws APIMgtDAOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SystemApplicationDAO.isTableExists_aroundBody2(this, joinPoint);
    }

    public boolean addApplicationKey(String appName, String consumerKey, String consumerSecret, String tenantDomain) throws APIMgtDAOException {
        String string = appName;
        String string2 = consumerKey;
        String string3 = consumerSecret;
        String string4 = tenantDomain;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648)));
        }
        return SystemApplicationDAO.addApplicationKey_aroundBody4(this, string, string2, string3, string4, joinPoint);
    }

    public SystemApplicationDTO[] getApplications(String tenantDomain) throws APIMgtDAOException {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (SystemApplicationDTO[])MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SystemApplicationDAO.getApplications_aroundBody6(this, string, joinPoint);
    }

    public SystemApplicationDTO getClientCredentialsForApplication(String appName, String tenantDomain) throws APIMgtDAOException {
        String string = appName;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (SystemApplicationDTO)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SystemApplicationDAO.getClientCredentialsForApplication_aroundBody8(this, string, string2, joinPoint);
    }

    public boolean removeConsumerKeyForApplication(String appName, String tenantDomain) throws APIMgtDAOException {
        String string = appName;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SystemApplicationDAO.removeConsumerKeyForApplication_aroundBody10(this, string, string2, joinPoint);
    }

    public boolean isClientCredentialsExistForApplication(String appName, String tenantDomain) throws APIMgtDAOException {
        String string = appName;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SystemApplicationDAO.isClientCredentialsExistForApplication_aroundBody12(this, string, string2, joinPoint);
    }

    private void handleException(String message, Throwable e) throws APIMgtDAOException {
        String string = message;
        Throwable throwable = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)throwable);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, throwable, joinPoint};
            MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SystemApplicationDAO.handleException_aroundBody14(this, string, throwable, joinPoint);
    }

    private void handleConnectionRollBack(Connection connection) {
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)connection2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, connection2, joinPoint};
            MethodTimeLogger.aspectOf().log(new SystemApplicationDAO$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SystemApplicationDAO.handleConnectionRollBack_aroundBody16(this, connection2, joinPoint);
    }

    static final /* synthetic */ boolean isTableExists_aroundBody2(SystemApplicationDAO ajc$this, JoinPoint joinPoint) {
        boolean isExists;
        block7: {
            isExists = false;
            Connection connection = null;
            ResultSet resultSet = null;
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    resultSet = databaseMetaData.getTables(null, null, SYSTEM_APP_TABLE_NAME, null);
                    if (resultSet.next()) {
                        isExists = true;
                    }
                }
                catch (SQLException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error while retrieving database information. ", (Throwable)e);
                    }
                    ajc$this.handleException("Error retrieving Database information", e);
                    APIMgtDBUtil.closeAllConnections(null, connection, resultSet);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(null, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(null, connection, resultSet);
        }
        return isExists;
    }

    static final /* synthetic */ boolean addApplicationKey_aroundBody4(SystemApplicationDAO ajc$this, String appName, String consumerKey, String consumerSecret, String tenantDomain, JoinPoint joinPoint) {
        boolean result;
        block6: {
            result = false;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String addCertQuery = "INSERT INTO AM_SYSTEM_APPS (NAME,CONSUMER_KEY,CONSUMER_SECRET,TENANT_DOMAIN,CREATED_TIME) VALUES (?,?,?,?,?)";
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    connection.setAutoCommit(false);
                    preparedStatement = connection.prepareStatement(addCertQuery);
                    preparedStatement.setString(1, appName);
                    preparedStatement.setString(2, consumerKey);
                    preparedStatement.setString(3, consumerSecret);
                    preparedStatement.setString(4, tenantDomain);
                    preparedStatement.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    result = preparedStatement.executeUpdate() >= 1;
                    connection.commit();
                }
                catch (SQLException e) {
                    ajc$this.handleConnectionRollBack(connection);
                    if (log.isDebugEnabled()) {
                        log.debug("Error occurred while adding client credentials to SYSTEM_APPS table ", (Throwable)e);
                    }
                    ajc$this.handleException("Error while persisting client credentials to SYSTEM_APPS table ", e);
                    APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
        }
        return result;
    }

    static final /* synthetic */ SystemApplicationDTO[] getApplications_aroundBody6(SystemApplicationDAO ajc$this, String tenantDomain, JoinPoint joinPoint) {
        ArrayList<SystemApplicationDTO> systemApplicationDTOS;
        block7: {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            SystemApplicationDTO systemApplicationDTO = null;
            systemApplicationDTOS = new ArrayList<SystemApplicationDTO>();
            String getCredentialsQuery = "SELECT * FROM AM_SYSTEM_APPS WHERE TENANT_DOMAIN = ?";
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    connection.setAutoCommit(false);
                    connection.commit();
                    preparedStatement = connection.prepareStatement(getCredentialsQuery);
                    preparedStatement.setString(1, tenantDomain);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        systemApplicationDTO = new SystemApplicationDTO();
                        systemApplicationDTO.setConsumerKey(resultSet.getString("CONSUMER_KEY"));
                        systemApplicationDTO.setConsumerSecret(resultSet.getString("CONSUMER_SECRET"));
                        systemApplicationDTOS.add(systemApplicationDTO);
                    }
                }
                catch (SQLException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error while retrieving system applications for tenant: " + tenantDomain);
                    }
                    ajc$this.handleException("Error while retrieving system applications for tenant: " + tenantDomain, e);
                    APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        }
        return systemApplicationDTOS.toArray(new SystemApplicationDTO[systemApplicationDTOS.size()]);
    }

    static final /* synthetic */ SystemApplicationDTO getClientCredentialsForApplication_aroundBody8(SystemApplicationDAO ajc$this, String appName, String tenantDomain, JoinPoint joinPoint) {
        SystemApplicationDTO systemApplicationDTO;
        block7: {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            systemApplicationDTO = null;
            String getCredentialsQuery = "SELECT CONSUMER_KEY,CONSUMER_SECRET FROM AM_SYSTEM_APPS WHERE NAME = ? AND TENANT_DOMAIN = ?";
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    connection.setAutoCommit(false);
                    connection.commit();
                    preparedStatement = connection.prepareStatement(getCredentialsQuery);
                    preparedStatement.setString(1, appName);
                    preparedStatement.setString(2, tenantDomain);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        systemApplicationDTO = new SystemApplicationDTO();
                        systemApplicationDTO.setConsumerKey(resultSet.getString("CONSUMER_KEY"));
                        systemApplicationDTO.setConsumerSecret(resultSet.getString("CONSUMER_SECRET"));
                    }
                }
                catch (SQLException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error while retrieving client credentials for application: " + appName);
                    }
                    ajc$this.handleException("Error while retrieving client credentials for application: " + appName, e);
                    APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        }
        return systemApplicationDTO;
    }

    static final /* synthetic */ boolean removeConsumerKeyForApplication_aroundBody10(SystemApplicationDAO ajc$this, String appName, String tenantDomain, JoinPoint joinPoint) {
        boolean result;
        block5: {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            result = false;
            String deleteApplicationKeyQuery = "DELETE FROM AM_SYSTEM_APPS WHERE NAME = ? AND TENANT_DOMAIN = ?";
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    connection.setAutoCommit(false);
                    preparedStatement = connection.prepareStatement(deleteApplicationKeyQuery);
                    preparedStatement.setString(1, appName);
                    preparedStatement.setString(2, tenantDomain);
                    result = preparedStatement.executeUpdate() == 1;
                    connection.commit();
                }
                catch (SQLException e) {
                    ajc$this.handleConnectionRollBack(connection);
                    ajc$this.handleException("Error while deleting System Application. ", e);
                    APIMgtDBUtil.closeStatement(preparedStatement);
                    APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeStatement(preparedStatement);
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                throw throwable;
            }
            APIMgtDBUtil.closeStatement(preparedStatement);
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
        }
        return result;
    }

    static final /* synthetic */ boolean isClientCredentialsExistForApplication_aroundBody12(SystemApplicationDAO ajc$this, String appName, String tenantDomain, JoinPoint joinPoint) {
        boolean result;
        block5: {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            result = false;
            String checkClientCredentialsExistsQuery = "SELECT CONSUMER_KEY,CONSUMER_SECRET FROM AM_SYSTEM_APPS WHERE NAME = ? AND TENANT_DOMAIN = ?";
            try {
                try {
                    connection = APIMgtDBUtil.getConnection();
                    connection.setAutoCommit(false);
                    preparedStatement = connection.prepareStatement(checkClientCredentialsExistsQuery);
                    preparedStatement.setString(1, appName);
                    preparedStatement.setString(2, tenantDomain);
                    result = preparedStatement.executeUpdate() == 1;
                    connection.commit();
                }
                catch (SQLException e) {
                    ajc$this.handleConnectionRollBack(connection);
                    ajc$this.handleException("Error while checking for System Application. ", e);
                    APIMgtDBUtil.closeStatement(preparedStatement);
                    APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeStatement(preparedStatement);
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
                throw throwable;
            }
            APIMgtDBUtil.closeStatement(preparedStatement);
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, null);
        }
        return result;
    }

    static final /* synthetic */ void handleException_aroundBody14(SystemApplicationDAO ajc$this, String message, Throwable e, JoinPoint joinPoint) {
        throw new APIMgtDAOException(message, e);
    }

    static final /* synthetic */ void handleConnectionRollBack_aroundBody16(SystemApplicationDAO ajc$this, Connection connection, JoinPoint joinPoint) {
        try {
            if (connection != null) {
                connection.rollback();
            } else {
                log.warn("Could not perform rollback since the connection is null.");
            }
        }
        catch (SQLException e1) {
            log.error("Error while rolling back the transaction.", (Throwable)e1);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SystemApplicationDAO.java", SystemApplicationDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLock", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "", "", "", "java.util.concurrent.Semaphore"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTableExists", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "", "", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "boolean"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addApplicationKey", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "appName:consumerKey:consumerSecret:tenantDomain", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "boolean"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApplications", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String", "tenantDomain", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "[Lorg.wso2.carbon.apimgt.impl.dto.SystemApplicationDTO;"), 140);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientCredentialsForApplication", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String:java.lang.String", "appName:tenantDomain", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "org.wso2.carbon.apimgt.impl.dto.SystemApplicationDTO"), 181);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeConsumerKeyForApplication", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String:java.lang.String", "appName:tenantDomain", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "boolean"), 221);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClientCredentialsExistForApplication", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String:java.lang.String", "appName:tenantDomain", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "boolean"), 252);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleException", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.lang.String:java.lang.Throwable", "message:e", "org.wso2.carbon.apimgt.api.APIMgtDAOException", "void"), 284);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleConnectionRollBack", "org.wso2.carbon.apimgt.impl.dao.SystemApplicationDAO", "java.sql.Connection", "connection", "", "void"), 294);
    }
}

