/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.util.Map;
import java.util.UUID;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.MDC;

@Aspect
public class MethodTimeLogger {
    private static final Log log = LogFactory.getLog((String)"correlation");
    private static boolean isEnabled = false;
    private static boolean logAllMethods = false;
    private static boolean isSet = false;
    private static boolean isLogAllSet = false;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodTimeLogger ajc$perSingletonInstance;

    static {
        try {
            MethodTimeLogger.ajc$perSingletonInstance = new MethodTimeLogger();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(* *(..)) && (@annotation(MethodStats) || @target(MethodStats))")
    public static /* synthetic */ void pointCut() {
    }

    @Pointcut(value="execution(* *(..)) && if()")
    public static /* synthetic */ boolean pointCutAll() {
        String config;
        if (!isLogAllSet && StringUtils.isNotEmpty((CharSequence)(config = System.getProperty("logAllMethods")))) {
            logAllMethods = config.contains("org.wso2.carbon.apimgt.impl");
            isLogAllSet = true;
        }
        return logAllMethods;
    }

    @Pointcut(value="if()")
    public static /* synthetic */ boolean isConfigEnabled() {
        String config;
        if (!isSet && StringUtils.isNotEmpty((CharSequence)(config = System.getProperty("enableCorrelationLogs")))) {
            isEnabled = Boolean.parseBoolean(config);
            isSet = true;
        }
        return isEnabled;
    }

    @Around(value="isConfigEnabled() && (pointCut() || pointCutAll())")
    public Object log(ProceedingJoinPoint point) throws Throwable {
        Map headers;
        long start = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object result = point.proceed();
        String[] args = signature.getParameterNames();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (args != null && args.length != 0) {
            String delimiter = "";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                stringBuilder.append(delimiter);
                delimiter = ", ";
                stringBuilder.append(arg);
                ++n2;
            }
        }
        stringBuilder.append("]");
        String argString = stringBuilder.toString();
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && (headers = (Map)messageContext.getProperty("TRANSPORT_HEADERS")) != null) {
            String correlationId = (String)headers.get("activityid");
            if (StringUtils.isNotEmpty((CharSequence)correlationId)) {
                MDC.put((String)"Correlation-ID", (String)correlationId);
            }
            if (StringUtils.isEmpty((CharSequence)MDC.get((String)"Correlation-ID"))) {
                correlationId = UUID.randomUUID().toString();
                MDC.put((String)"Correlation-ID", (String)correlationId);
                headers.put("activityid", correlationId);
            }
        }
        log.info((Object)(String.valueOf(System.currentTimeMillis() - start) + "|METHOD|" + ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getDeclaringTypeName() + "|" + ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod().getName() + "|" + argString));
        return result;
    }

    public static MethodTimeLogger aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.wso2.carbon.apimgt.impl.MethodTimeLogger", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

