/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.GZIPUtils$AjcClosure1;
import org.wso2.carbon.apimgt.impl.GZIPUtils$AjcClosure3;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;

public class GZIPUtils {
    private static final Log log;
    private static final int BUFFER_SIZE = 1028;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        GZIPUtils.ajc$preClinit();
        log = LogFactory.getLog(GZIPUtils.class);
    }

    public static void compressFile(String sourcePath, String destinationPath) throws APIManagementException {
        String string = sourcePath;
        String string2 = destinationPath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new GZIPUtils$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        GZIPUtils.compressFile_aroundBody0(string, string2, joinPoint);
    }

    public static File constructZippedResponse(Object data) throws APIManagementException {
        Object object = data;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)object);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{object, joinPoint};
            return (File)MethodTimeLogger.aspectOf().log(new GZIPUtils$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return GZIPUtils.constructZippedResponse_aroundBody2(object, joinPoint);
    }

    static final /* synthetic */ void compressFile_aroundBody0(String sourcePath, String destinationPath, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compressing file : " + sourcePath + " to : " + destinationPath));
        }
        byte[] buffer = new byte[1028];
        GZIPOutputStream gzipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(destinationPath);
                gzipOutputStream = new GZIPOutputStream(fileOutputStream);
                fileInputStream = new FileInputStream(sourcePath);
                int length = 0;
                while ((length = fileInputStream.read(buffer)) > 0) {
                    gzipOutputStream.write(buffer, 0, length);
                }
                gzipOutputStream.finish();
            }
            catch (IOException e) {
                throw new APIManagementException("Error while compressing file at " + sourcePath + " to" + destinationPath, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            IOUtils.closeQuietly(gzipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtils.closeQuietly((OutputStream)gzipOutputStream);
    }

    static final /* synthetic */ File constructZippedResponse_aroundBody2(Object data, JoinPoint joinPoint) {
        File zippedResponse;
        String tmpSourceFileName = String.valueOf(System.currentTimeMillis()) + ".json";
        String tmpDestinationFileName = String.valueOf(System.currentTimeMillis()) + ".json.gz";
        String sourcePath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + tmpSourceFileName;
        String destinationPath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + tmpDestinationFileName;
        File file = new File(sourcePath);
        FileWriter fileWriter = null;
        try {
            try {
                file.createNewFile();
                fileWriter = new FileWriter(file);
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.writeValue((Writer)fileWriter, data);
                GZIPUtils.compressFile(sourcePath, destinationPath);
                zippedResponse = new File(destinationPath);
            }
            catch (IOException e) {
                throw new APIManagementException("Error while constructing zipped response..", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        return zippedResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GZIPUtils.java", GZIPUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "compressFile", "org.wso2.carbon.apimgt.impl.GZIPUtils", "java.lang.String:java.lang.String", "sourcePath:destinationPath", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "constructZippedResponse", "org.wso2.carbon.apimgt.impl.GZIPUtils", "java.lang.Object", "data", "org.wso2.carbon.apimgt.api.APIManagementException", "java.io.File"), 64);
    }
}

