/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.EmptyCallbackURLForCodeGrantsException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.KeyManager;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure1;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure11;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure13;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure15;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure3;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure5;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure7;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager$AjcClosure9;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dto.TokenHandlingDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;

public abstract class AbstractKeyManager
implements KeyManager {
    private static Log log;
    protected KeyManagerConfiguration configuration;
    protected String tenantDomain;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        AbstractKeyManager.ajc$preClinit();
        log = LogFactory.getLog(AbstractKeyManager.class);
    }

    public AccessTokenRequest buildAccessTokenRequestFromJSON(String jsonInput, AccessTokenRequest tokenRequest) throws APIManagementException {
        String string = jsonInput;
        AccessTokenRequest accessTokenRequest = tokenRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)accessTokenRequest);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, accessTokenRequest, joinPoint};
            return (AccessTokenRequest)MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractKeyManager.buildAccessTokenRequestFromJSON_aroundBody0(this, string, accessTokenRequest, joinPoint);
    }

    public boolean registerNewResource(API api, Map resourceAttributes) throws APIManagementException {
        API aPI = api;
        Map map = resourceAttributes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)aPI, (Object)map);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, aPI, map, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return AbstractKeyManager.registerNewResource_aroundBody2(this, aPI, map, joinPoint);
    }

    public OAuthApplicationInfo buildFromJSON(OAuthApplicationInfo oAuthApplicationInfo, String jsonInput) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo2 = oAuthApplicationInfo;
        String string = jsonInput;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)oAuthApplicationInfo2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, oAuthApplicationInfo2, string, joinPoint};
            return (OAuthApplicationInfo)MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractKeyManager.buildFromJSON_aroundBody4(this, oAuthApplicationInfo2, string, joinPoint);
    }

    public AccessTokenRequest buildAccessTokenRequestFromOAuthApp(OAuthApplicationInfo oAuthApplication, AccessTokenRequest tokenRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthApplication;
        AccessTokenRequest accessTokenRequest = tokenRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)oAuthApplicationInfo, (Object)accessTokenRequest);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, oAuthApplicationInfo, accessTokenRequest, joinPoint};
            return (AccessTokenRequest)MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractKeyManager.buildAccessTokenRequestFromOAuthApp_aroundBody6(this, oAuthApplicationInfo, accessTokenRequest, joinPoint);
    }

    public boolean canHandleToken(String accessToken) throws APIManagementException {
        String string = accessToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return AbstractKeyManager.canHandleToken_aroundBody8(this, string, joinPoint);
    }

    public void setTenantDomain(String tenantDomain) {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.tenantDomain = string;
    }

    protected void handleException(String msg, Exception e) throws APIManagementException {
        String string = msg;
        Exception exception = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)exception);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, exception, joinPoint};
            MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AbstractKeyManager.handleException_aroundBody12(this, string, exception, joinPoint);
    }

    protected void validateOAuthAppCreationProperties(OAuthApplicationInfo oAuthApplicationInfo) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo2 = oAuthApplicationInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)oAuthApplicationInfo2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, oAuthApplicationInfo2, joinPoint};
            MethodTimeLogger.aspectOf().log(new AbstractKeyManager$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AbstractKeyManager.validateOAuthAppCreationProperties_aroundBody14(this, oAuthApplicationInfo2, joinPoint);
    }

    static final /* synthetic */ AccessTokenRequest buildAccessTokenRequestFromJSON_aroundBody0(AbstractKeyManager ajc$this, String jsonInput, AccessTokenRequest tokenRequest, JoinPoint joinPoint) {
        if (jsonInput == null || jsonInput.isEmpty()) {
            log.debug((Object)"JsonInput is null or Empty.");
            return tokenRequest;
        }
        JSONParser parser = new JSONParser();
        if (tokenRequest == null) {
            log.debug((Object)"Input request is null. Creating a new Request Object.");
            tokenRequest = new AccessTokenRequest();
        }
        try {
            JSONObject jsonObject = (JSONObject)parser.parse(jsonInput);
            if (jsonObject != null && !jsonObject.isEmpty()) {
                JSONObject params = jsonObject;
                if (params.get("client_id") != null) {
                    tokenRequest.setClientId((String)params.get("client_id"));
                }
                if (params.get("client_secret") != null) {
                    tokenRequest.setClientSecret((String)params.get("client_secret"));
                }
                if (params.get("validityPeriod") != null) {
                    tokenRequest.setValidityPeriod(Long.parseLong((String)params.get("validityPeriod")));
                }
                return tokenRequest;
            }
        }
        catch (ParseException e) {
            ajc$this.handleException("Error occurred while parsing JSON String", (Exception)((Object)e));
        }
        return null;
    }

    static final /* synthetic */ boolean registerNewResource_aroundBody2(AbstractKeyManager ajc$this, API api, Map resourceAttributes, JoinPoint joinPoint) {
        return true;
    }

    static final /* synthetic */ OAuthApplicationInfo buildFromJSON_aroundBody4(AbstractKeyManager ajc$this, OAuthApplicationInfo oAuthApplicationInfo, String jsonInput, JoinPoint joinPoint) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonObject = (JSONObject)parser.parse(jsonInput);
            if (jsonObject != null) {
                JSONObject params = jsonObject;
                if (params.get("grant_types") != null) {
                    String grantTypeString = params.get("grant_types").toString();
                    if (StringUtils.isEmpty((CharSequence)oAuthApplicationInfo.getCallBackURL()) && (grantTypeString.contains("implicit") || grantTypeString.contains("authorization_code"))) {
                        throw new EmptyCallbackURLForCodeGrantsException("The callback url must have at least one URI value when using Authorization code or implicit grant types.");
                    }
                }
                if (params.get("client_id") != null) {
                    oAuthApplicationInfo.setClientId((String)params.get("client_id"));
                }
                if (params.get("client_secret") != null) {
                    oAuthApplicationInfo.setClientSecret((String)params.get("client_secret"));
                }
                oAuthApplicationInfo.putAll((Map)params);
                ajc$this.validateOAuthAppCreationProperties(oAuthApplicationInfo);
                return oAuthApplicationInfo;
            }
        }
        catch (ParseException e) {
            ajc$this.handleException("Error occurred while parsing JSON String", (Exception)((Object)e));
        }
        return null;
    }

    static final /* synthetic */ AccessTokenRequest buildAccessTokenRequestFromOAuthApp_aroundBody6(AbstractKeyManager ajc$this, OAuthApplicationInfo oAuthApplication, AccessTokenRequest tokenRequest, JoinPoint joinPoint) {
        if (oAuthApplication == null) {
            return tokenRequest;
        }
        if (tokenRequest == null) {
            tokenRequest = new AccessTokenRequest();
        }
        if (oAuthApplication.getClientId() == null || oAuthApplication.getClientSecret() == null) {
            throw new APIManagementException("Consumer key or Consumer Secret missing.");
        }
        tokenRequest.setClientId(oAuthApplication.getClientId());
        tokenRequest.setClientSecret(oAuthApplication.getClientSecret());
        if (oAuthApplication.getParameter("tokenScope") != null) {
            Object[] tokenScopes = (String[])oAuthApplication.getParameter("tokenScope");
            tokenRequest.setScope((String[])tokenScopes);
            oAuthApplication.addParameter("tokenScope", (Object)Arrays.toString(tokenScopes));
        }
        if (oAuthApplication.getParameter("validityPeriod") != null) {
            tokenRequest.setValidityPeriod(Long.parseLong((String)oAuthApplication.getParameter("validityPeriod")));
        }
        return tokenRequest;
    }

    static final /* synthetic */ boolean canHandleToken_aroundBody8(AbstractKeyManager ajc$this, String accessToken, JoinPoint joinPoint) {
        boolean result = false;
        boolean canHandle = false;
        Object tokenHandlingScript = ajc$this.configuration.getParameter("token_format_string");
        if (tokenHandlingScript != null && StringUtils.isNotEmpty((CharSequence)((String)tokenHandlingScript))) {
            TokenHandlingDto[] tokenHandlers = (TokenHandlingDto[])new Gson().fromJson((String)tokenHandlingScript, TokenHandlingDto[].class);
            if (tokenHandlers.length == 0) {
                return true;
            }
            TokenHandlingDto[] tokenHandlingDtoArray = tokenHandlers;
            int n = tokenHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                TokenHandlingDto tokenHandler = tokenHandlingDtoArray[n2];
                if (tokenHandler.getEnable().booleanValue()) {
                    if (TokenHandlingDto.TypeEnum.REFERENCE.equals((Object)tokenHandler.getType())) {
                        if (tokenHandler.getValue() != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(tokenHandler.getValue()))) {
                            Pattern pattern = Pattern.compile((String)tokenHandler.getValue());
                            Matcher matcher = pattern.matcher(accessToken);
                            canHandle = matcher.find();
                        }
                    } else if (TokenHandlingDto.TypeEnum.JWT.equals((Object)tokenHandler.getType()) && accessToken.contains(".")) {
                        Map validationJson = (Map)tokenHandler.getValue();
                        try {
                            SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
                            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
                            for (Map.Entry entry : validationJson.entrySet()) {
                                if (!"body".equals(entry.getKey())) continue;
                                boolean state = false;
                                for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                                    String key = (String)e.getKey();
                                    String value = (String)e.getValue();
                                    Object claimValue = jwtClaimsSet.getClaim(key);
                                    if (claimValue != null) {
                                        Pattern pattern = Pattern.compile(value);
                                        Matcher matcher = pattern.matcher((String)claimValue);
                                        state = matcher.find();
                                        continue;
                                    }
                                    state = false;
                                }
                                canHandle = state;
                            }
                        }
                        catch (java.text.ParseException e) {
                            log.warn((Object)"Error while parsing Token", (Throwable)e);
                        }
                    }
                    if (canHandle) {
                        result = true;
                        break;
                    }
                }
                ++n2;
            }
        } else {
            result = true;
        }
        return result;
    }

    static final /* synthetic */ void handleException_aroundBody12(AbstractKeyManager ajc$this, String msg, Exception e, JoinPoint joinPoint) {
        log.error((Object)msg, (Throwable)e);
        throw new APIManagementException(msg, (Throwable)e);
    }

    static final /* synthetic */ void validateOAuthAppCreationProperties_aroundBody14(AbstractKeyManager ajc$this, OAuthApplicationInfo oAuthApplicationInfo, JoinPoint joinPoint) {
        String type = ajc$this.getType();
        if (!"default".equals(type)) {
            ArrayList<String> missedRequiredValues = new ArrayList<String>();
            KeyManagerConnectorConfiguration keyManagerConnectorConfiguration = ServiceReferenceHolder.getInstance().getKeyManagerConnectorConfiguration(type);
            if (keyManagerConnectorConfiguration != null) {
                List applicationConfigurationDtoList = keyManagerConnectorConfiguration.getApplicationConfigurations();
                Object additionalProperties = oAuthApplicationInfo.getParameter("additionalProperties");
                if (additionalProperties != null) {
                    JsonObject additionalPropertiesJson = (JsonObject)new JsonParser().parse((String)additionalProperties);
                    for (ConfigurationDto configurationDto : applicationConfigurationDtoList) {
                        JsonElement value = additionalPropertiesJson.get(configurationDto.getName());
                        if (value != null || !configurationDto.isRequired()) continue;
                        missedRequiredValues.add(configurationDto.getName());
                    }
                    if (!missedRequiredValues.isEmpty()) {
                        throw new APIManagementException("Missing required properties to create/update oauth application", (ErrorHandler)ExceptionCodes.KEY_MANAGER_MISSING_REQUIRED_PROPERTIES_IN_APPLICATION);
                    }
                }
            } else {
                throw new APIManagementException("Invalid Key Manager Type " + type, (ErrorHandler)ExceptionCodes.KEY_MANAGER_NOT_FOUND);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractKeyManager.java", AbstractKeyManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildAccessTokenRequestFromJSON", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "java.lang.String:org.wso2.carbon.apimgt.api.model.AccessTokenRequest", "jsonInput:tokenRequest", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.model.AccessTokenRequest"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerNewResource", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "org.wso2.carbon.apimgt.api.model.API:java.util.Map", "api:resourceAttributes", "org.wso2.carbon.apimgt.api.APIManagementException", "boolean"), 107);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildFromJSON", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo:java.lang.String", "oAuthApplicationInfo:jsonInput", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo"), 119);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildAccessTokenRequestFromOAuthApp", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo:org.wso2.carbon.apimgt.api.model.AccessTokenRequest", "oAuthApplication:tokenRequest", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.model.AccessTokenRequest"), 159);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canHandleToken", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "java.lang.String", "accessToken", "org.wso2.carbon.apimgt.api.APIManagementException", "boolean"), 191);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTenantDomain", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "java.lang.String", "tenantDomain", "", "void"), 253);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleException", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "java.lang.String:java.lang.Exception", "msg:e", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 264);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "validateOAuthAppCreationProperties", "org.wso2.carbon.apimgt.impl.AbstractKeyManager", "org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo", "oAuthApplicationInfo", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 269);
    }
}

